/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.cmd;

import eu.isas.searchgui.cmd.PathSettingsCLIParams;
import org.apache.commons.cli.Options;

public enum FastaCLIParams {
    in("in", "FASTA file", true, true),
    decoy("decoy", "Create a concatenated target/decoy database.", false, false),
    decoy_suffix("decoy_suffix", "Target decoy suffix, defaults to _concatenated_target_decoy.", false, true);

    public String id;
    public String description;
    public boolean mandatory;
    public boolean hasArgument;

    private FastaCLIParams(String id, String description, boolean mandatory, boolean hasArgument) {
        this.id = id;
        this.description = description;
        this.mandatory = mandatory;
        this.hasArgument = hasArgument;
    }

    public static String getOptionsAsString() {
        String output = "";
        String formatter = "%-25s";
        output = output + "Mandatory Parameters:\n\n";
        output = output + "-" + String.format(formatter, FastaCLIParams.in.id) + " " + FastaCLIParams.in.description + "\n";
        output = output + "\n\nOptional Parameters:\n\n";
        output = output + "-" + String.format(formatter, FastaCLIParams.decoy.id) + " " + FastaCLIParams.decoy.description + "\n";
        output = output + "-" + String.format(formatter, FastaCLIParams.decoy_suffix.id) + " " + FastaCLIParams.decoy_suffix.description + "\n";
        output = output + "\n\nOptional Temporary Folder:\n\n";
        output = output + "-" + String.format(formatter, PathSettingsCLIParams.ALL.id) + " " + PathSettingsCLIParams.ALL.description + "\n";
        return output;
    }

    public static void createOptionsCLI(Options aOptions) {
        for (FastaCLIParams param : FastaCLIParams.values()) {
            aOptions.addOption(param.id, param.hasArgument, param.description);
        }
    }
}

