/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.cmd;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.enzymes.EnzymeFactory;
import com.compomics.util.experiment.biology.taxonomy.SpeciesFactory;
import com.compomics.util.experiment.io.temp.TempFilesManager;
import com.compomics.util.gui.waiting.waitinghandlers.WaitingHandlerCLIImpl;
import com.compomics.util.parameters.UtilitiesUserParameters;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.parameters.tools.ProcessingParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.searchgui.SearchHandler;
import eu.isas.searchgui.cmd.PathSettingsCLI;
import eu.isas.searchgui.cmd.SearchCLIInputBean;
import eu.isas.searchgui.cmd.SearchCLIParams;
import eu.isas.searchgui.utilities.Properties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.Callable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;

public class SearchCLI
implements Callable {
    private SearchCLIInputBean searchCLIInputBean;
    private static File logFolder = null;
    private WaitingHandler waitingHandler = new WaitingHandlerCLIImpl();

    public SearchCLI(String[] args) {
        try {
            try {
                Class<?> loggerClass = Class.forName("jdk.internal.module.IllegalAccessLogger");
                Field loggerField = loggerClass.getDeclaredField("logger");
                Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
                Field unsafeField = unsafeClass.getDeclaredField("theUnsafe");
                unsafeField.setAccessible(true);
                Object unsafe = unsafeField.get(null);
                Long offset = (Long)unsafeClass.getMethod("staticFieldOffset", Field.class).invoke(unsafe, loggerField);
                unsafeClass.getMethod("putObjectVolatile", Object.class, Long.TYPE, Object.class).invoke(unsafe, loggerClass, offset, null);
            }
            catch (Throwable loggerClass) {
                // empty catch block
            }
            String[] nonPathSettingArgsAsList = PathSettingsCLI.extractAndUpdatePathOptions(args);
            try {
                SpeciesFactory speciesFactory = SpeciesFactory.getInstance();
                speciesFactory.initiate(SearchHandler.getConfigFolder());
            }
            catch (Exception e) {
                this.waitingHandler.appendReport("An error occurred while loading the species.", true, true);
                e.printStackTrace();
            }
            Options nonPathOptions = new Options();
            SearchCLIParams.createOptionsCLI(nonPathOptions);
            DefaultParser parser = new DefaultParser();
            CommandLine line = parser.parse(nonPathOptions, nonPathSettingArgsAsList);
            if (!SearchCLIInputBean.isValidStartup(line)) {
                PrintWriter lPrintWriter = new PrintWriter(System.out);
                lPrintWriter.print(System.getProperty("line.separator") + "======================" + System.getProperty("line.separator"));
                lPrintWriter.print("SearchCLI" + System.getProperty("line.separator"));
                lPrintWriter.print("======================" + System.getProperty("line.separator"));
                lPrintWriter.print(SearchCLI.getHeader());
                lPrintWriter.print(SearchCLIParams.getOptionsAsString());
                lPrintWriter.flush();
                lPrintWriter.close();
                System.exit(0);
            } else {
                this.searchCLIInputBean = new SearchCLIInputBean(line);
                this.call();
            }
        }
        catch (Exception e) {
            this.waitingHandler.appendReport("An error occurred while running the command line. " + SearchCLI.getLogFileMessage(), true, true);
            e.printStackTrace();
        }
    }

    public Object call() {
        EnzymeFactory enzymeFactory = EnzymeFactory.getInstance();
        try {
            SearchParameters searchParameters;
            String error;
            WaitingHandlerCLIImpl waitingHandlerCLIImpl = new WaitingHandlerCLIImpl();
            ArrayList<File> spectrumFiles = this.searchCLIInputBean.getSpectrumFiles();
            ProcessingParameters processingParameters = new ProcessingParameters();
            processingParameters.setnThreads(this.searchCLIInputBean.getNThreads());
            IdentificationParameters identificationParameters = this.searchCLIInputBean.getIdentificationParameters();
            identificationParameters.getFastaParameters().setTargetDecoyFileNameSuffix(this.searchCLIInputBean.getTargetDecoyFileNameTag());
            File parametersFile = this.searchCLIInputBean.getIdentificationParametersFile();
            if (parametersFile == null) {
                String name = identificationParameters.getName();
                name = name == null ? "SearchCLI.par" : name + ".par";
                parametersFile = new File(this.searchCLIInputBean.getOutputFolder(), name);
                IdentificationParameters.saveIdentificationParameters((IdentificationParameters)identificationParameters, (File)parametersFile);
            }
            if ((error = SearchHandler.loadModifications(searchParameters = identificationParameters.getSearchParameters())) != null) {
                System.out.println(error);
            }
            UtilitiesUserParameters userParameters = UtilitiesUserParameters.loadUserParameters();
            userParameters.setRefMass(this.searchCLIInputBean.getRefMass().doubleValue());
            userParameters.setRenameXTandemFile(this.searchCLIInputBean.renameXTandemFile().booleanValue());
            userParameters.setGzip(this.searchCLIInputBean.isGzip());
            userParameters.setSearchGuiOutputParameters(this.searchCLIInputBean.getOutputOption());
            userParameters.setOutputData(this.searchCLIInputBean.isOutputData().booleanValue());
            userParameters.setIncludeDateInOutputName(this.searchCLIInputBean.isOutputDate().booleanValue());
            UtilitiesUserParameters.saveUserParameters((UtilitiesUserParameters)userParameters);
            SearchHandler searchHandler = new SearchHandler(identificationParameters, this.searchCLIInputBean.getOutputFolder(), this.searchCLIInputBean.getConfigFolder(), this.searchCLIInputBean.getDefaultOutputFileName(), spectrumFiles, this.searchCLIInputBean.getFastaFile(), new ArrayList<File>(), parametersFile, this.searchCLIInputBean.isOmssaEnabled(), this.searchCLIInputBean.isXTandemEnabled(), this.searchCLIInputBean.isMsgfEnabled(), this.searchCLIInputBean.isMsAmandaEnabled(), this.searchCLIInputBean.isMyriMatchEnabled(), this.searchCLIInputBean.isCometEnabled(), this.searchCLIInputBean.isTideEnabled(), this.searchCLIInputBean.isAndromedaEnabled(), this.searchCLIInputBean.isMetaMorpheusEnabled(), this.searchCLIInputBean.isSageEnabled(), this.searchCLIInputBean.isNovorEnabled(), this.searchCLIInputBean.isDirecTagEnabled(), this.searchCLIInputBean.getOmssaLocation(), this.searchCLIInputBean.getXtandemLocation(), this.searchCLIInputBean.getMsgfLocation(), this.searchCLIInputBean.getMsAmandaLocation(), this.searchCLIInputBean.getMyriMatchLocation(), this.searchCLIInputBean.getCometLocation(), this.searchCLIInputBean.getTideLocation(), this.searchCLIInputBean.getTideIndexLocation(), this.searchCLIInputBean.getAndromedaLocation(), this.searchCLIInputBean.getMetaMorpheusLocation(), this.searchCLIInputBean.getSageLocation(), this.searchCLIInputBean.getNovorLocation(), this.searchCLIInputBean.getDirecTagLocation(), this.searchCLIInputBean.getMakeblastdbLocation(), processingParameters);
            searchHandler.setLogFolder(logFolder);
            if (userParameters.isAutoUpdate()) {
                Util.sendGAUpdate((String)"UA-36198780-2", (String)"startrun-cl", (String)("searchgui-" + new Properties().getVersion()));
            }
            searchHandler.startSearch((WaitingHandler)waitingHandlerCLIImpl);
        }
        catch (Exception e) {
            this.waitingHandler.appendReport("An error occurred while running the command line. " + SearchCLI.getLogFileMessage(), true, true);
            e.printStackTrace();
        }
        try {
            TempFilesManager.deleteTempFolders();
        }
        catch (Exception e) {
            this.waitingHandler.appendReport("An error occurred while deleting the temp folder. " + SearchCLI.getLogFileMessage(), true, true);
            e.printStackTrace();
        }
        return null;
    }

    private static String getHeader() {
        return System.getProperty("line.separator") + "SearchCLI searches spectrum files according to search parameters using multiple search engines." + System.getProperty("line.separator") + System.getProperty("line.separator") + "Spectra must be provided either as mgf or mzML." + System.getProperty("line.separator") + System.getProperty("line.separator") + "The identification parameters can be provided as a file as saved from the GUI or generated using the IdentificationParametersCLI." + System.getProperty("line.separator") + "See https://compomics.github.io/projects/compomics-utilities/wiki/IdentificationParametersCLI.html for more details." + System.getProperty("line.separator") + System.getProperty("line.separator") + "For further help see https://compomics.github.io/projects/searchgui.html and https://compomics.github.io/projects/searchgui/wiki/SearchCLI.html." + System.getProperty("line.separator") + System.getProperty("line.separator") + "Or contact the developers at https://groups.google.com/group/peptide-shaker." + System.getProperty("line.separator") + System.getProperty("line.separator") + "----------------------" + System.getProperty("line.separator") + "OPTIONS" + System.getProperty("line.separator") + "----------------------" + System.getProperty("line.separator") + "\n";
    }

    public static void main(String[] args) {
        try {
            new SearchCLI(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void redirectErrorStream(File aLogFolder) {
        logFolder = aLogFolder;
        try {
            aLogFolder.mkdirs();
            File file = new File(aLogFolder, "SearchGUI.log");
            System.setErr(new PrintStream(new FileOutputStream(file, true)));
            System.err.println(System.getProperty("line.separator") + System.getProperty("line.separator") + new Date() + ": SearchGUI version " + new Properties().getVersion() + ".");
            System.err.println("Memory given to the Java virtual machine: " + Runtime.getRuntime().maxMemory() + ".");
            System.err.println("Total amount of memory in the Java virtual machine: " + Runtime.getRuntime().totalMemory() + ".");
            System.err.println("Free memory: " + Runtime.getRuntime().freeMemory() + ".");
            System.err.println("Java version: " + System.getProperty("java.version") + ".");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getLogFileMessage() {
        if (logFolder == null) {
            return "Please see the SearchGUI log file.";
        }
        return "Please see the SearchGUI log file: " + logFolder.getAbsolutePath() + File.separator + "SearchGUI.log";
    }
}

