/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.processbuilders;

import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.biology.aminoacids.AminoAcid;
import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidPattern;
import com.compomics.util.experiment.biology.atoms.AtomChain;
import com.compomics.util.experiment.biology.atoms.AtomImpl;
import com.compomics.util.experiment.biology.enzymes.Enzyme;
import com.compomics.util.experiment.biology.enzymes.EnzymeFactory;
import com.compomics.util.experiment.biology.ions.NeutralLoss;
import com.compomics.util.experiment.biology.ions.impl.ReporterIon;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.io.biology.protein.converters.GenericFastaConverter;
import com.compomics.util.io.IoUtil;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.search.DigestionParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.parameters.identification.tool_specific.AndromedaParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.searchgui.processbuilders.SearchGUIProcessBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class AndromedaProcessBuilder
extends SearchGUIProcessBuilder {
    private File andromedaFolder;
    private File andromedaTempFolder = null;
    private File spectrumFile;
    private File fastaFile;
    public static final String EXECUTABLE_FILE_NAME = "AndromedaCmd.exe";
    private SearchParameters searchParameters;
    private AndromedaParameters andromedaParameters;

    public AndromedaProcessBuilder(File andromedaFolder, File andromedaTempFolder, SearchParameters searchParameters, File searchParametersFile, File spectrumFile, File fastaFile, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler, int nThreads) throws IOException {
        this.andromedaFolder = andromedaFolder;
        this.andromedaTempFolder = andromedaTempFolder;
        this.searchParameters = searchParameters;
        this.andromedaParameters = (AndromedaParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.andromeda.getIndex());
        this.spectrumFile = spectrumFile;
        this.fastaFile = fastaFile;
        this.waitingHandler = waitingHandler;
        this.exceptionHandler = exceptionHandler;
        if (!andromedaTempFolder.exists()) {
            andromedaTempFolder.mkdirs();
        }
        File andromeda = new File(andromedaFolder.getAbsolutePath() + File.separator + EXECUTABLE_FILE_NAME);
        andromeda.setExecutable(true);
        File andromedaParametersFile = this.createParametersFile(searchParametersFile);
        this.process_name_array.add(andromeda.getAbsolutePath());
        this.process_name_array.add("-i");
        this.process_name_array.add(spectrumFile.getAbsolutePath());
        this.process_name_array.add("-p");
        this.process_name_array.add(andromedaParametersFile.getAbsolutePath());
        this.process_name_array.add("-f");
        this.process_name_array.add(andromedaTempFolder.getAbsolutePath());
        this.process_name_array.add("-n");
        this.process_name_array.add(nThreads + "");
        this.process_name_array.add("-s");
        this.process_name_array.add("FALSE");
        this.process_name_array.trimToSize();
        System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "andromeda command: ");
        for (Object currentElement : this.process_name_array) {
            System.out.print(currentElement + " ");
        }
        System.out.println(System.getProperty("line.separator"));
        this.pb = new ProcessBuilder(this.process_name_array);
        this.pb.directory(andromedaFolder);
        this.pb.redirectErrorStream(true);
    }

    public static File createGenericFastaFile(File andromedaTempFolder, File originalFastaFile, WaitingHandler waitingHandler) throws IOException {
        File andromedaFastaFile = new File(andromedaTempFolder, originalFastaFile.getName());
        if (!andromedaFastaFile.exists()) {
            GenericFastaConverter.convertFile((File)originalFastaFile, (File)andromedaFastaFile, (WaitingHandler)waitingHandler);
        }
        return andromedaFastaFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createDatabaseFile(File andromedaFolder, File andromedaTempFolder, File fastaFile) throws IOException {
        File databaseFolder = new File(andromedaFolder, "conf");
        File databaseFile = new File(databaseFolder, "databases.xml");
        File genericFastaFile = new File(andromedaTempFolder, IoUtil.getFileName((File)fastaFile));
        BufferedWriter bw = new BufferedWriter(new FileWriter(databaseFile));
        String dbName = genericFastaFile.getName();
        String date = "0001-01-01T00:00:00";
        try {
            bw.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            bw.newLine();
            bw.write("<databases xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">");
            bw.newLine();
            bw.write("   <database create_date=\"" + date + "\" last_modified_date=\"" + date + "\" user=\"SearchGUI\" filename=\"" + dbName + "\" search_expression=\"&gt;generic\\|([^|]*)\\|(.*)\" mutation_parse_rule=\"\" species=\"Homo sapiens (Human)\" taxid=\"9606\" source=\"UniprotKB\" />");
            bw.newLine();
            bw.write("</databases>");
            bw.newLine();
        }
        finally {
            bw.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createEnzymesFile(File andromedaFolder) throws IOException {
        EnzymeFactory enzymeFactory = EnzymeFactory.getInstance();
        File confFolder = new File(andromedaFolder, "conf");
        File enzymesFile = new File(confFolder, "enzymes.xml");
        BufferedWriter bw = new BufferedWriter(new FileWriter(enzymesFile));
        int index = 0;
        String date = "0001-01-01T00:00:00";
        try {
            bw.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            bw.newLine();
            bw.write("<enzymes xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
            bw.newLine();
            for (Enzyme enzyme : enzymeFactory.getEnzymes()) {
                ArrayList<Character> aaAfter;
                bw.write("   <enzyme index=\"" + index + "\" title=\"" + enzyme.getName() + "\" description=\"" + enzyme.getDescription() + "\" create_date=\"" + date + "\" last_modified_date=\"" + date + "\" user=\"SearchGUI\">");
                bw.newLine();
                bw.write("      <specificity>");
                bw.newLine();
                ArrayList<Character> aaBefore = new ArrayList<Character>(enzyme.getAminoAcidBefore());
                if (aaBefore.isEmpty()) {
                    for (char aa : AminoAcid.getUniqueAminoAcids()) {
                        aaBefore.add(Character.valueOf(aa));
                    }
                }
                if ((aaAfter = new ArrayList<Character>(enzyme.getAminoAcidAfter())).isEmpty()) {
                    for (char aa : AminoAcid.getUniqueAminoAcids()) {
                        aaAfter.add(Character.valueOf(aa));
                    }
                }
                for (Character aa1 : aaBefore) {
                    for (Character aa2 : aaAfter) {
                        if (enzyme.getRestrictionBefore().contains(aa1) || enzyme.getRestrictionAfter().contains(aa2)) continue;
                        bw.write("         <string>" + aa1 + aa2 + "</string>");
                        bw.newLine();
                    }
                }
                bw.write("      </specificity>");
                bw.newLine();
                bw.write("    </enzyme>");
                bw.newLine();
                ++index;
            }
            bw.write("</enzymes>");
            bw.newLine();
        }
        finally {
            bw.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createPtmFile(File andromedaFolder, IdentificationParameters identificationParameters, File identificationParametersFile) throws IOException, ClassNotFoundException {
        File confFolder = new File(andromedaFolder, "conf");
        File modFile = new File(confFolder, "modifications.xml");
        BufferedWriter bw = new BufferedWriter(new FileWriter(modFile));
        int index = 0;
        String date = "0001-01-01T00:00:00";
        ModificationFactory ptmFactory = ModificationFactory.getInstance();
        SearchParameters searchParameters = identificationParameters.getSearchParameters();
        AndromedaParameters andromedaParameters = (AndromedaParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.andromeda.getIndex());
        try {
            Modification ptm;
            bw.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            bw.newLine();
            bw.write("<modifications xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">");
            bw.newLine();
            for (String ptmName : ptmFactory.getDefaultModifications()) {
                ptm = ptmFactory.getModification(ptmName);
                AndromedaProcessBuilder.writePtm(bw, date, ptm, index);
                andromedaParameters.setPtmIndex(ptmName, index);
                ++index;
            }
            for (String ptmName : ptmFactory.getUserModifications()) {
                ptm = ptmFactory.getModification(ptmName);
                AndromedaProcessBuilder.writePtm(bw, date, ptm, index);
                andromedaParameters.setPtmIndex(ptmName, index);
                ++index;
            }
            bw.write("</modifications>");
            bw.newLine();
        }
        finally {
            bw.close();
        }
        IdentificationParameters.saveIdentificationParameters((IdentificationParameters)identificationParameters, (File)identificationParametersFile);
    }

    private static void writePtm(BufferedWriter bw, String date, Modification modification, int index) throws IOException {
        bw.write("   <modification index=\"" + index + "\" title=\"" + modification.getName() + "\" description=\"" + modification.getName() + "\" create_date=\"" + date + "\" last_modified_date=\"" + date + "\" user=\"SearchGUI\" reporterCorrectionM2=\"0\" reporterCorrectionM1=\"0\" reporterCorrectionP1=\"0\" reporterCorrectionP2=\"0\" composition=\"" + AndromedaProcessBuilder.getComposition(modification) + "\" multi_modification=\"false\">");
        bw.newLine();
        if (null == modification.getModificationType()) {
            throw new IllegalArgumentException("Export not implemented for PTM of type " + modification.getModificationType() + ".");
        }
        switch (modification.getModificationType()) {
            case modaa: {
                bw.write("      <position>anywhere</position>");
                break;
            }
            case modn_protein: {
                bw.write("      <position>proteinNterm</position>");
                break;
            }
            case modnaa_protein: {
                bw.write("      <position>proteinNterm</position>");
                break;
            }
            case modn_peptide: {
                bw.write("      <position>anyNterm</position>");
                break;
            }
            case modnaa_peptide: {
                bw.write("      <position>anyNterm</position>");
                break;
            }
            case modc_protein: {
                bw.write("      <position>proteinCterm</position>");
                break;
            }
            case modcaa_protein: {
                bw.write("      <position>proteinCterm</position>");
                break;
            }
            case modc_peptide: {
                bw.write("      <position>anyCterm</position>");
                break;
            }
            case modcaa_peptide: {
                bw.write("      <position>anyCterm</position>");
                break;
            }
            default: {
                throw new IllegalArgumentException("Export not implemented for PTM of type " + modification.getModificationType() + ".");
            }
        }
        bw.newLine();
        int siteIndex = 0;
        AminoAcidPattern aminoAcidPattern = modification.getPattern();
        if (aminoAcidPattern != null && !aminoAcidPattern.getAminoAcidsAtTarget().isEmpty()) {
            for (Character aa : aminoAcidPattern.getAminoAcidsAtTarget()) {
                bw.write("      <modification_site index=\"" + siteIndex + "\" site=\"" + aa + "\">");
                bw.newLine();
                ++siteIndex;
                ArrayList neutralLosses = modification.getNeutralLosses();
                if (!neutralLosses.isEmpty()) {
                    bw.write("         <neutralloss_collection>");
                    bw.newLine();
                    for (NeutralLoss neutralLoss : neutralLosses) {
                        if (neutralLoss.getComposition() == null) continue;
                        bw.write("            <neutralloss name=\"" + neutralLoss.name + "\" shortname=\"" + neutralLoss.name + "\" composition=\"" + AndromedaProcessBuilder.getComposition(neutralLoss.getComposition()) + "\" />");
                        bw.newLine();
                    }
                    bw.write("         </neutralloss_collection>");
                    bw.newLine();
                } else {
                    bw.write("         <neutralloss_collection />");
                    bw.newLine();
                }
                ArrayList reporterIons = modification.getReporterIons();
                if (!reporterIons.isEmpty()) {
                    bw.write("         <diagnostic_collection>");
                    bw.newLine();
                    for (ReporterIon reporterIon : reporterIons) {
                        if (reporterIon.getAtomicComposition() == null) continue;
                        bw.write("            <diagnostic name=\"" + reporterIon.getName() + "\" shortname=\"" + reporterIon.getName() + "\" composition=\"" + AndromedaProcessBuilder.getComposition(reporterIon.getAtomicComposition()) + "\" />");
                        bw.newLine();
                    }
                    bw.write("         </diagnostic_collection>");
                    bw.newLine();
                } else {
                    bw.write("         <neutralloss_collection />");
                    bw.newLine();
                }
                bw.write("      </modification_site>");
                bw.newLine();
            }
        } else {
            bw.write("      <modification_site site=\"-\">");
            bw.newLine();
            bw.write("         <neutralloss_collection />");
            bw.newLine();
            bw.write("         <diagnostic_collection />");
            bw.newLine();
            bw.write("      </modification_site>");
            bw.newLine();
        }
        bw.write("      <type>Standard</type>");
        bw.newLine();
        bw.write("      <terminus_type>none</terminus_type>");
        bw.newLine();
        bw.write("   </modification>");
        bw.newLine();
    }

    private static String getComposition(AtomChain atomChain) {
        Integer occurrence;
        HashMap<String, Integer> monoisotopic = new HashMap<String, Integer>();
        HashMap<String, Integer> isotopic = new HashMap<String, Integer>();
        ArrayList<String> atoms = new ArrayList<String>();
        for (AtomImpl atomImpl : atomChain.getAtomChain()) {
            String atom = atomImpl.getAtomSymbol();
            if (!atoms.contains(atom)) {
                atoms.add(atom);
            }
            if (atomImpl.getIsotope() == 0) {
                occurrence = (Integer)monoisotopic.get(atom);
                if (occurrence == null) {
                    occurrence = 0;
                }
                monoisotopic.put(atom, occurrence + 1);
                continue;
            }
            occurrence = (Integer)isotopic.get(atom);
            if (occurrence == null) {
                occurrence = 0;
            }
            isotopic.put(atom, occurrence + 1);
        }
        Collections.sort(atoms);
        StringBuilder result = new StringBuilder();
        for (String atom : atoms) {
            occurrence = (Integer)monoisotopic.get(atom);
            if (occurrence != null && occurrence != 0) {
                if (result.length() > 0) {
                    result.append(" ");
                }
                result.append(atom);
                if (occurrence > 1 || occurrence < -1) {
                    result.append("(").append(occurrence).append(")");
                }
            }
            if ((occurrence = (Integer)isotopic.get(atom)) == null || occurrence == 0) continue;
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(atom).append("x");
            if (occurrence <= 1 && occurrence >= -1) continue;
            result.append("(").append(occurrence).append(")");
        }
        return result.toString();
    }

    private static String getComposition(Modification modification) {
        Integer occurrence;
        String atom2;
        AtomChain atomChainAdded = modification.getAtomChainAdded();
        AtomChain atomChainRemoved = modification.getAtomChainRemoved();
        HashMap<String, Integer> monoisotopic = new HashMap<String, Integer>();
        HashMap<String, Integer> isotopic = new HashMap<String, Integer>();
        ArrayList<String> atoms = new ArrayList<String>();
        if (atomChainAdded != null) {
            for (AtomImpl atomImpl : atomChainAdded.getAtomChain()) {
                atom2 = atomImpl.getAtomSymbol();
                if (!atoms.contains(atom2)) {
                    atoms.add(atom2);
                }
                if (atomImpl.getIsotope() == 0) {
                    occurrence = (Integer)monoisotopic.get(atom2);
                    if (occurrence == null) {
                        occurrence = 0;
                    }
                    monoisotopic.put(atom2, occurrence + 1);
                    continue;
                }
                occurrence = (Integer)isotopic.get(atom2);
                if (occurrence == null) {
                    occurrence = 0;
                }
                isotopic.put(atom2, occurrence + 1);
            }
        }
        if (atomChainRemoved != null) {
            for (AtomImpl atomImpl : atomChainRemoved.getAtomChain()) {
                atom2 = atomImpl.getAtomSymbol();
                if (!atoms.contains(atom2)) {
                    atoms.add(atom2);
                }
                if (atomImpl.getIsotope() == 0) {
                    occurrence = (Integer)monoisotopic.get(atom2);
                    if (occurrence == null) {
                        occurrence = 0;
                    }
                    monoisotopic.put(atom2, occurrence - 1);
                    continue;
                }
                occurrence = (Integer)isotopic.get(atom2);
                if (occurrence == null) {
                    occurrence = 0;
                }
                isotopic.put(atom2, occurrence - 1);
            }
        }
        Collections.sort(atoms);
        StringBuilder result = new StringBuilder();
        for (String atom2 : atoms) {
            occurrence = (Integer)monoisotopic.get(atom2);
            if (occurrence != null && occurrence != 0) {
                if (result.length() > 0) {
                    result.append(" ");
                }
                result.append(atom2);
                if (occurrence > 1 || occurrence < -1) {
                    result.append("(").append(occurrence).append(")");
                }
            }
            if ((occurrence = (Integer)isotopic.get(atom2)) == null || occurrence == 0) continue;
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(atom2).append("x");
            if (occurrence <= 1 && occurrence >= -1) continue;
            result.append("(").append(occurrence).append(")");
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createParametersFile(File searchParametersFile) throws IOException {
        String fileName;
        try {
            fileName = IoUtil.removeExtension((String)searchParametersFile.getName()) + ".apar";
        }
        catch (Exception e) {
            fileName = "SearchGUI.apar";
        }
        File parameterFile = new File(this.andromedaTempFolder, fileName);
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(parameterFile));){
            boolean semiSpecific = false;
            DigestionParameters digestionParameters = this.searchParameters.getDigestionParameters();
            if (digestionParameters.getCleavageParameter() == DigestionParameters.CleavageParameter.enzyme) {
                StringBuilder enzymesAsString = new StringBuilder();
                for (Object enzyme : digestionParameters.getEnzymes()) {
                    if (enzymesAsString.length() > 0) {
                        enzymesAsString.append(",");
                    }
                    enzymesAsString.append(enzyme.getName());
                }
                bw.write("enzymes=" + enzymesAsString.toString());
                bw.newLine();
                Enzyme firstEnzyme = (Enzyme)digestionParameters.getEnzymes().get(0);
                if (digestionParameters.getSpecificity(firstEnzyme.getName()) == DigestionParameters.Specificity.semiSpecific || digestionParameters.getSpecificity(firstEnzyme.getName()) == DigestionParameters.Specificity.specificCTermOnly || digestionParameters.getSpecificity(firstEnzyme.getName()) == DigestionParameters.Specificity.specificNTermOnly) {
                    semiSpecific = true;
                }
            } else if (digestionParameters.getCleavageParameter() == DigestionParameters.CleavageParameter.unSpecific) {
                bw.write("enzyme mode=unspecific");
                bw.newLine();
            }
            if (semiSpecific) {
                bw.write("enzyme mode=semispecific");
            } else {
                bw.write("enzyme mode=specific");
            }
            bw.newLine();
            ModificationParameters modificationProfile = this.searchParameters.getModificationParameters();
            StringBuilder list = new StringBuilder();
            for (String ptmName : modificationProfile.getVariableModifications()) {
                if (list.length() > 0) {
                    list.append(",");
                }
                list.append(ptmName);
            }
            bw.write("variable modifications=" + list);
            bw.newLine();
            list = new StringBuilder();
            for (String ptmName : modificationProfile.getFixedModifications()) {
                if (list.length() > 0) {
                    list.append(",");
                }
                list.append(ptmName);
            }
            bw.write("fixed modifications=" + list);
            bw.newLine();
            bw.write("label modifications=");
            bw.newLine();
            if (!modificationProfile.getRefinementVariableModifications().isEmpty()) {
                bw.write("has additional variable modifications=True");
                bw.newLine();
                list = new StringBuilder();
                for (String ptmName : modificationProfile.getRefinementVariableModifications()) {
                    if (list.length() > 0) {
                        list.append(",");
                    }
                    list.append(ptmName);
                }
                bw.write("additional variable modifications=" + list);
                bw.newLine();
                bw.write("additional variable modification proteins=");
                bw.newLine();
            } else {
                bw.write("has additional variable modifications=False");
                bw.newLine();
                bw.write("additional variable modifications=");
                bw.newLine();
                bw.write("additional variable modification proteins=");
                bw.newLine();
            }
            bw.write("peptide mass tolerance=" + this.searchParameters.getPrecursorAccuracy());
            bw.newLine();
            bw.write("max peptide mass=" + this.andromedaParameters.getMaxPeptideMass());
            bw.newLine();
            bw.write("max combinations=" + this.andromedaParameters.getMaxCombinations());
            bw.newLine();
            if (this.searchParameters.isPrecursorAccuracyTypePpm().booleanValue()) {
                bw.write("peptide mass tolerance Unit=ppm");
            } else {
                bw.write("peptide mass tolerance Unit=Da");
            }
            bw.newLine();
            bw.write("fragment mass tolerance=" + this.searchParameters.getFragmentIonAccuracy());
            bw.newLine();
            if (this.searchParameters.getFragmentAccuracyType() == SearchParameters.MassAccuracyType.PPM) {
                bw.write("fragment mass tolerance Unit=ppm");
            } else {
                bw.write("fragment mass tolerance Unit=Da");
            }
            bw.newLine();
            bw.write("top peaks=" + this.andromedaParameters.getTopPeaks());
            bw.newLine();
            bw.write("top peaks window=" + this.andromedaParameters.getTopPeaksWindow());
            bw.newLine();
            if (digestionParameters.getCleavageParameter() == DigestionParameters.CleavageParameter.enzyme) {
                Integer missedCleavages = null;
                for (Enzyme enzyme : digestionParameters.getEnzymes()) {
                    int enzymeMissedCleavages = digestionParameters.getnMissedCleavages(enzyme.getName());
                    if (missedCleavages != null && enzymeMissedCleavages <= missedCleavages) continue;
                    missedCleavages = enzymeMissedCleavages;
                }
                bw.write("max missed cleavages=" + missedCleavages);
                bw.newLine();
            }
            bw.write("fasta file=\"" + new File(this.andromedaTempFolder, IoUtil.getFileName((File)this.fastaFile)).getAbsolutePath() + "\"");
            bw.newLine();
            bw.write("decoy mode=" + this.andromedaParameters.getDecoyMode());
            bw.newLine();
            bw.write("include contaminants=False");
            bw.newLine();
            if (this.andromedaParameters.isIncludeWater()) {
                bw.write("include water=True");
            } else {
                bw.write("include water=False");
            }
            bw.newLine();
            if (this.andromedaParameters.isIncludeAmmonia()) {
                bw.write("include ammonia=True");
            } else {
                bw.write("include ammonia=False");
            }
            bw.newLine();
            if (this.andromedaParameters.isDependentLosses()) {
                bw.write("dependent losses=True");
            } else {
                bw.write("dependent losses=False");
            }
            bw.newLine();
            bw.write("special aas=");
            bw.newLine();
            if (this.andromedaParameters.isFragmentAll()) {
                bw.write("fragment all=True");
            } else {
                bw.write("fragment all=False");
            }
            bw.newLine();
            if (this.andromedaParameters.isEmpiricalCorrection()) {
                bw.write("empirical correction=True");
            } else {
                bw.write("empirical correction=False");
            }
            bw.newLine();
            if (this.andromedaParameters.isHigherCharge()) {
                bw.write("higher charges=True");
            } else {
                bw.write("higher charges=False");
            }
            bw.newLine();
            bw.write("fragmentation type=" + this.andromedaParameters.getFragmentationMethod().name);
            bw.newLine();
            bw.write("max number of modifications=" + this.andromedaParameters.getMaxNumberOfModifications());
            bw.newLine();
            bw.write("min peptide length no enzyme=" + this.andromedaParameters.getMinPeptideLengthNoEnzyme());
            bw.newLine();
            bw.write("max peptide length no enzyme=" + this.andromedaParameters.getMaxPeptideLengthNoEnzyme());
            bw.newLine();
            if (this.andromedaParameters.isEqualIL()) {
                bw.write("equal il=True");
            } else {
                bw.write("equal il=False");
            }
            bw.newLine();
            bw.write("number of candidates=" + this.andromedaParameters.getNumberOfCandidates());
            bw.newLine();
        }
        return parameterFile;
    }

    @Override
    public String getType() {
        return "Andromeda";
    }

    @Override
    public String getCurrentlyProcessedFileName() {
        return this.spectrumFile.getName();
    }
}

