/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.processbuilders;

import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.searchgui.processbuilders.SearchGUIProcessBuilder;
import java.io.File;
import java.io.IOException;

public class MakeblastdbProcessBuilder
extends SearchGUIProcessBuilder {
    private static final String DEFALUT_MAC_FOLDER = "resources" + File.separator + "makeblastdb" + File.separator + "osx";
    private static final String DEFALUT_WINDOWS_FOLDER = "resources" + File.separator + "makeblastdb" + File.separator + "windows";
    private static final String DEFALUT_LINUX_32_BIT_FOLDER = "resources" + File.separator + "makeblastdb" + File.separator + "linux" + File.separator + "linux_32bit";
    private static final String DEFALUT_LINUX_64_BIT_FOLDER = "resources" + File.separator + "makeblastdb" + File.separator + "linux" + File.separator + "linux_64bit";
    public static final String EXECUTABLE_FILE_NAME = "makeblastdb";
    private File iDatabaseFile = null;
    private boolean isCanceled = false;

    public MakeblastdbProcessBuilder(String pathToJarFile, File aDatabaseFile, File makeblastdbLocation, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler) {
        this.waitingHandler = waitingHandler;
        this.exceptionHandler = exceptionHandler;
        File makeBlastDb = makeblastdbLocation != null ? new File(makeblastdbLocation, EXECUTABLE_FILE_NAME) : new File(pathToJarFile + File.separator + MakeblastdbProcessBuilder.getMakeblastdbFolder() + File.separator + EXECUTABLE_FILE_NAME);
        try {
            makeBlastDb.setExecutable(true);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        this.process_name_array.add(makeBlastDb.getAbsolutePath());
        this.process_name_array.add("-in");
        this.process_name_array.add(aDatabaseFile.getName());
        this.process_name_array.add("-dbtype");
        this.process_name_array.add("prot");
        System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "makeblastdb command: ");
        for (Object element : this.process_name_array) {
            System.out.print(element + " ");
        }
        System.out.println(System.getProperty("line.separator"));
        this.pb = new ProcessBuilder(this.process_name_array);
        this.pb.directory(aDatabaseFile.getAbsoluteFile().getParentFile());
        this.pb.redirectErrorStream(true);
        this.iDatabaseFile = aDatabaseFile;
    }

    public static String getMakeblastdbFolder() {
        String operating_system = System.getProperty("os.name").toLowerCase();
        if (operating_system.contains("mac os")) {
            return DEFALUT_MAC_FOLDER;
        }
        if (operating_system.contains("windows")) {
            return DEFALUT_WINDOWS_FOLDER;
        }
        String arch = System.getProperty("os.arch").toLowerCase();
        if (arch.lastIndexOf("64") != -1) {
            return DEFALUT_LINUX_64_BIT_FOLDER;
        }
        return DEFALUT_LINUX_32_BIT_FOLDER;
    }

    public boolean needsFormatting() {
        boolean result = true;
        String[] list = this.iDatabaseFile.getAbsoluteFile().getParentFile().list();
        String name = this.iDatabaseFile.getName();
        boolean phr = false;
        boolean pin = false;
        boolean psq = false;
        for (String s : list) {
            if (s.equals(name + ".phr")) {
                phr = true;
            }
            if (s.equals(name + ".pin")) {
                pin = true;
            }
            if (!s.equals(name + ".psq")) continue;
            psq = true;
        }
        if (phr && pin && psq) {
            result = false;
        }
        return result;
    }

    @Override
    public void startProcess() throws IOException {
        super.startProcess();
        if (this.isCanceled) {
            File tempFile = new File(this.iDatabaseFile.getAbsolutePath() + ".phr");
            this.deleteFile(tempFile);
            tempFile = new File(this.iDatabaseFile.getAbsolutePath() + ".pin");
            this.deleteFile(tempFile);
            tempFile = new File(this.iDatabaseFile.getAbsolutePath() + ".psq");
            this.deleteFile(tempFile);
        }
    }

    @Override
    public void endProcess() {
        this.isCanceled = true;
        super.endProcess();
    }

    private void deleteFile(File aFile) {
        int count = 0;
        boolean deleteOK = true;
        while (!aFile.delete()) {
            if (++count <= 5) continue;
            deleteOK = false;
            break;
        }
        if (!deleteOK) {
            System.err.println(" *** Failed to deleted file " + aFile.getAbsolutePath() + "! ***");
        }
    }

    @Override
    public String getType() {
        return "Database Formating";
    }

    @Override
    public String getCurrentlyProcessedFileName() {
        return this.iDatabaseFile.getName();
    }
}

