/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.processbuilders;

import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.mass_spectrometry.thermo_raw_file_parser.ThermoRawFileParserOutputFormat;
import com.compomics.util.experiment.mass_spectrometry.thermo_raw_file_parser.ThermoRawFileParserParameters;
import com.compomics.util.io.IoUtil;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.searchgui.processbuilders.SearchGUIProcessBuilder;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;

public class ThermoRawFileParserProcessBuilder
extends SearchGUIProcessBuilder {
    private File rawFile;
    private File destinationFolder;
    private File thermoRawFileParserFolder;
    private ThermoRawFileParserParameters thermoRawFileParserParameters;

    public ThermoRawFileParserProcessBuilder(File thermoRawFileParserFolder, File rawFile, File destinationFolder, ThermoRawFileParserParameters thermoRawFileParserParameters, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler) throws IOException, ClassNotFoundException {
        this.rawFile = rawFile;
        this.destinationFolder = destinationFolder;
        this.thermoRawFileParserFolder = thermoRawFileParserFolder;
        this.thermoRawFileParserParameters = thermoRawFileParserParameters;
        this.waitingHandler = waitingHandler;
        this.exceptionHandler = exceptionHandler;
        this.setUpProcessBuilder();
    }

    private void setUpProcessBuilder() throws IOException, ClassNotFoundException {
        this.process_name_array.clear();
        String operatingSystem = System.getProperty("os.name").toLowerCase();
        if (!operatingSystem.contains("windows")) {
            StringTokenizer versionTokens;
            String monoPath = "mono";
            if (operatingSystem.contains("mac os x") && (versionTokens = new StringTokenizer(System.getProperty("os.version"), ".")).countTokens() > 1) {
                int mainVersion = Integer.parseInt(versionTokens.nextToken());
                int subversion = Integer.parseInt(versionTokens.nextToken());
                if (mainVersion >= 10 && subversion >= 11) {
                    monoPath = "/Library/Frameworks/Mono.framework/Versions/Current/bin/mono";
                }
            }
            this.process_name_array.add(monoPath);
        }
        File thermoRawFileParserExecutable = new File(this.thermoRawFileParserFolder, "ThermoRawFileParser.exe");
        thermoRawFileParserExecutable.setExecutable(true);
        this.process_name_array.add(thermoRawFileParserExecutable.getAbsolutePath());
        this.process_name_array.add("-i=" + this.rawFile.getAbsolutePath());
        if (this.thermoRawFileParserParameters.getOutputFormat() == ThermoRawFileParserOutputFormat.mgf) {
            this.process_name_array.add("-b=" + new File(this.destinationFolder, IoUtil.removeExtension((String)this.rawFile.getName()) + ".mgf").getAbsolutePath());
        } else {
            this.process_name_array.add("-b=" + new File(this.destinationFolder, IoUtil.removeExtension((String)this.rawFile.getName()) + ".mzml").getAbsolutePath());
        }
        this.process_name_array.add("-f=" + this.thermoRawFileParserParameters.getOutputFormat().index);
        if (!this.thermoRawFileParserParameters.isPeackPicking()) {
            this.process_name_array.add("-p");
        }
        this.process_name_array.add("-e");
        this.process_name_array.add("-x");
        this.process_name_array.trimToSize();
        System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "ThermoRawFileParser command: ");
        for (Object current_entry : this.process_name_array) {
            System.out.print(current_entry + " ");
        }
        System.out.println(System.getProperty("line.separator"));
        this.pb = new ProcessBuilder(this.process_name_array);
        this.pb.redirectErrorStream(true);
    }

    @Override
    public void startProcess() throws IOException {
        if (!this.waitingHandler.isRunCanceled()) {
            this.waitingHandler.appendReport("Processing " + this.rawFile.getName() + " with ThermoRawFileParser.", true, true);
            this.waitingHandler.appendReportEndLine();
            super.startProcess();
        }
    }

    @Override
    public String getType() {
        return "ThermoRawFileParser";
    }

    @Override
    public String getCurrentlyProcessedFileName() {
        return this.rawFile.getName();
    }
}

