/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.fdr;

import edu.ucsd.msjava.fdr.MSGFPlusPSMSet;
import edu.ucsd.msjava.fdr.Pair;
import edu.ucsd.msjava.fdr.TSVPSMSet;
import edu.ucsd.msjava.fdr.TargetDecoyAnalysis;
import edu.ucsd.msjava.msdbsearch.CompactSuffixArray;
import edu.ucsd.msjava.msdbsearch.DatabaseMatch;
import edu.ucsd.msjava.msdbsearch.MSGFPlusMatch;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class ComputeFDR {
    public static final float FDR_REPORT_THRESHOLD = 0.1f;

    public static void main(String[] argv) throws Exception {
        File targetFile = null;
        int scoreCol = -1;
        int specFileCol = -1;
        File outputFile = null;
        boolean isGreaterBetter = false;
        boolean hasHeader = true;
        File decoyFile = null;
        String delimiter = "\t";
        int pepCol = -1;
        int specIndexCol = -1;
        boolean isConcatenated = false;
        boolean includeDecoy = false;
        int dbCol = -1;
        String decoyPrefix = null;
        float fdrThreshold = 1.0f;
        float pepFDRThreshold = 1.0f;
        ArrayList<Pair<Integer, ArrayList<String>>> reqStrList = new ArrayList<Pair<Integer, ArrayList<String>>>();
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equalsIgnoreCase("-f")) {
                if (i + 2 >= argv.length) {
                    ComputeFDR.printUsageAndExit("Invalid parameter: " + argv[i]);
                }
                if (!(targetFile = new File(argv[i + 1])).exists()) {
                    ComputeFDR.printUsageAndExit(argv[i + 1] + " doesn't exist.");
                } else if (!targetFile.isFile()) {
                    ComputeFDR.printUsageAndExit(argv[i + 1] + " is not a file.");
                }
                if (i + 3 < argv.length && !argv[i + 3].startsWith("-")) {
                    dbCol = Integer.parseInt(argv[i + 2]);
                    decoyPrefix = argv[i + 3];
                    isConcatenated = true;
                    i += 4;
                    continue;
                }
                decoyFile = new File(argv[i + 2]);
                if (!decoyFile.exists()) {
                    ComputeFDR.printUsageAndExit(argv[i + 2] + " doesn't exist.");
                } else if (!decoyFile.isFile()) {
                    ComputeFDR.printUsageAndExit(argv[i + 2] + " is not a file.");
                }
                isConcatenated = false;
                i += 3;
                continue;
            }
            if (argv[i].equalsIgnoreCase("-s")) {
                if (i + 2 >= argv.length) {
                    ComputeFDR.printUsageAndExit("Invalid parameter: " + argv[i]);
                }
                try {
                    scoreCol = Integer.parseInt(argv[i + 1]);
                }
                catch (NumberFormatException e) {
                    ComputeFDR.printUsageAndExit("Invalid scoreCol: " + argv[i + 1]);
                }
                isGreaterBetter = argv[i + 2].equalsIgnoreCase("1");
                i += 3;
                continue;
            }
            if (argv[i].equalsIgnoreCase("-o")) {
                if (i + 1 >= argv.length) {
                    ComputeFDR.printUsageAndExit("Invalid parameter: " + argv[i]);
                }
                outputFile = new File(argv[i + 1]);
                i += 2;
                continue;
            }
            if (argv[i].equalsIgnoreCase("-h")) {
                if (argv[i + 1].equalsIgnoreCase("0")) {
                    hasHeader = false;
                }
                i += 2;
                continue;
            }
            if (argv[i].equalsIgnoreCase("-decoy")) {
                if (argv[i + 1].equalsIgnoreCase("1")) {
                    includeDecoy = true;
                }
                i += 2;
                continue;
            }
            if (argv[i].equalsIgnoreCase("-decoyprefix")) {
                if (i + 1 >= argv.length) {
                    ComputeFDR.printUsageAndExit("Invalid parameter: " + argv[i]);
                }
                decoyPrefix = argv[i + 1];
                i += 2;
                continue;
            }
            if (argv[i].equalsIgnoreCase("-delim")) {
                if (i + 1 >= argv.length) {
                    ComputeFDR.printUsageAndExit("Invalid parameter: " + argv[i]);
                }
                delimiter = argv[i + 1];
                i += 2;
                continue;
            }
            if (argv[i].equalsIgnoreCase("-p")) {
                if (i + 1 >= argv.length) {
                    ComputeFDR.printUsageAndExit("Invalid parameter: " + argv[i]);
                }
                try {
                    pepCol = Integer.parseInt(argv[i + 1]);
                }
                catch (NumberFormatException e) {
                    ComputeFDR.printUsageAndExit("Invalid pepCol: " + argv[i + 1]);
                }
                i += 2;
                continue;
            }
            if (argv[i].equalsIgnoreCase("-n")) {
                if (i + 1 >= argv.length) {
                    ComputeFDR.printUsageAndExit("Invalid parameter: " + argv[i]);
                }
                try {
                    specIndexCol = Integer.parseInt(argv[i + 1]);
                }
                catch (NumberFormatException e) {
                    ComputeFDR.printUsageAndExit("Invalid pepCol: " + argv[i + 1]);
                }
                i += 2;
                continue;
            }
            if (argv[i].equalsIgnoreCase("-i")) {
                if (i + 1 >= argv.length) {
                    ComputeFDR.printUsageAndExit("Invalid parameter: " + argv[i]);
                }
                try {
                    specFileCol = Integer.parseInt(argv[i + 1]);
                }
                catch (NumberFormatException e) {
                    ComputeFDR.printUsageAndExit("Invalid pepCol: " + argv[i + 1]);
                }
                i += 2;
                continue;
            }
            if (argv[i].equalsIgnoreCase("-m")) {
                int matchCol = -1;
                if (i + 2 >= argv.length) {
                    ComputeFDR.printUsageAndExit("Invalid parameter: " + argv[i]);
                }
                try {
                    matchCol = Integer.parseInt(argv[i + 1]);
                }
                catch (NumberFormatException e) {
                    ComputeFDR.printUsageAndExit("Invalid matchCol: " + argv[i + 1]);
                }
                String[] token = argv[i + 2].split(",");
                ArrayList<String> reqStrOrList = new ArrayList<String>();
                for (String s : token) {
                    reqStrOrList.add(s);
                }
                reqStrList.add(new Pair(matchCol, reqStrOrList));
                i += 3;
                continue;
            }
            if (argv[i].equalsIgnoreCase("-fdr")) {
                if (i + 1 >= argv.length) {
                    ComputeFDR.printUsageAndExit("Invalid parameter: " + argv[i]);
                }
                try {
                    fdrThreshold = Float.parseFloat(argv[i + 1]);
                }
                catch (NumberFormatException e) {
                    ComputeFDR.printUsageAndExit("Invalid pepCol: " + argv[i + 1]);
                }
                i += 2;
                continue;
            }
            if (argv[i].equalsIgnoreCase("-pepfdr")) {
                if (i + 1 >= argv.length) {
                    ComputeFDR.printUsageAndExit("Invalid parameter: " + argv[i]);
                }
                try {
                    pepFDRThreshold = Float.parseFloat(argv[i + 1]);
                }
                catch (NumberFormatException e) {
                    ComputeFDR.printUsageAndExit("Invalid pepCol: " + argv[i + 1]);
                }
                i += 2;
                continue;
            }
            ComputeFDR.printUsageAndExit("Invalid parameter");
        }
        if (targetFile == null) {
            ComputeFDR.printUsageAndExit("Target is missing!");
        }
        if (scoreCol < 0) {
            ComputeFDR.printUsageAndExit("scoreCol is missing or invalid!");
        }
        if (pepCol < 0) {
            ComputeFDR.printUsageAndExit("pepCol is missing or invalid!");
        }
        if (specIndexCol < 0) {
            ComputeFDR.printUsageAndExit("specIndexCol is missing or invalid!");
        }
        ComputeFDR.computeFDR(targetFile, decoyFile, scoreCol, isGreaterBetter, delimiter, specFileCol, specIndexCol, pepCol, reqStrList, isConcatenated, includeDecoy, hasHeader, dbCol, decoyPrefix, fdrThreshold, pepFDRThreshold, outputFile);
    }

    public static void printUsageAndExit(String message) {
        System.err.println(message);
        System.out.print("Usage: java -cp MSGFDB.jar fdr.ComputeFDR\n\t -f resultFileName protCol decoyPrefix or -f targetFileName decoyFileName\n\t -i specFileCol (SpecFile column number)\n\t -n specIndexCol (specIndex column number)\n\t -p pepCol (peptide column number)\n\t -s scoreCol 0/1 (0: smaller better, 1: greater better)\n\t [-o outputFileName (default: stdout)]\n\t [-delim delimiter] (default: \\t)\n\t [-m colNum keyword (the column 'colNum' must contain 'keyword'. If 'keyword' is delimited by ',' (e.g. A,B,C), then at least one must be matched.)]\n\t [-h 0/1] (0: no header, 1: header (default))\n\t [-fdr fdrThreshold]\n\t [-pepfdr pepFDRThreshold]\n\t [-decoy 0/1] (0: don't include decoy (default), 1: include decoy)\n\t [-decoyPrefix DecoyProteinPrefix] (default: XXX)\n");
        System.exit(-1);
    }

    public static void computeFDR(File targetFile, File decoyFile, int scoreCol, boolean isGreaterBetter, String delimiter, int specFileCol, int specIndexCol, int pepCol, ArrayList<Pair<Integer, ArrayList<String>>> reqStrList, boolean isConcatenated, boolean includeDecoy, boolean hasHeader, int dbCol, String decoyPrefix, float fdrThreshold, float pepFDRThreshold, File outputFile) {
        TSVPSMSet decoy;
        TSVPSMSet target;
        if (dbCol >= 0) {
            target = new TSVPSMSet(targetFile, delimiter, hasHeader, scoreCol, isGreaterBetter, specFileCol, specIndexCol, pepCol, reqStrList);
            target.decoy(dbCol, decoyPrefix, true);
            target.read();
            decoy = new TSVPSMSet(targetFile, delimiter, hasHeader, scoreCol, isGreaterBetter, specFileCol, specIndexCol, pepCol, reqStrList);
            decoy.decoy(dbCol, decoyPrefix, false);
            decoy.read();
        } else {
            target = new TSVPSMSet(targetFile, delimiter, hasHeader, scoreCol, isGreaterBetter, specFileCol, specIndexCol, pepCol, reqStrList);
            target.read();
            decoy = new TSVPSMSet(decoyFile, delimiter, hasHeader, scoreCol, isGreaterBetter, specFileCol, specIndexCol, pepCol, reqStrList);
            decoy.read();
        }
        TargetDecoyAnalysis tda = new TargetDecoyAnalysis(target, decoy);
        PrintStream out = null;
        if (outputFile != null) {
            try {
                out = new PrintStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            out = System.out;
        }
        target.writeResults(tda, out, fdrThreshold, pepFDRThreshold, true);
        if (includeDecoy) {
            decoy.writeResults(tda, out, fdrThreshold, pepFDRThreshold, false);
        }
        if (out != System.out) {
            out.close();
        }
    }

    public static void addQValues(List<MSGFPlusMatch> resultList, CompactSuffixArray sa, boolean considerBestMatchOnly, String decoyProteinPrefix) {
        MSGFPlusPSMSet target = new MSGFPlusPSMSet(resultList, false, sa, decoyProteinPrefix);
        target.setConsiderBestMatchOnly(considerBestMatchOnly);
        target.read();
        MSGFPlusPSMSet decoy = new MSGFPlusPSMSet(resultList, true, sa, decoyProteinPrefix);
        decoy.setConsiderBestMatchOnly(considerBestMatchOnly);
        decoy.read();
        TargetDecoyAnalysis tda = new TargetDecoyAnalysis(target, decoy);
        for (MSGFPlusMatch match : resultList) {
            List<DatabaseMatch> dbMatchList;
            if (considerBestMatchOnly) {
                dbMatchList = new ArrayList<DatabaseMatch>();
                dbMatchList.add(match.getBestDBMatch());
            } else {
                dbMatchList = match.getMatchList();
            }
            for (DatabaseMatch m : dbMatchList) {
                float psmQValue = tda.getPSMQValue((float)m.getSpecEValue());
                Float pepQValue = tda.getPepQValue(m.getPepSeq());
                m.setPSMQValue(psmQValue);
                m.setPepQValue(pepQValue);
            }
        }
    }
}

