/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.fdr;

import edu.ucsd.msjava.fdr.PSMSet;
import edu.ucsd.msjava.fdr.Pair;
import edu.ucsd.msjava.fdr.ScoredString;
import edu.ucsd.msjava.fdr.TargetDecoyAnalysis;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class TSVPSMSet
extends PSMSet {
    File file;
    String delimiter;
    boolean hasHeader;
    int scoreCol;
    boolean isGreaterBetter;
    int specFileCol;
    int specIndexCol;
    int pepCol;
    ArrayList<Pair<Integer, ArrayList<String>>> reqStrList;
    int dbCol;
    String decoyProteinPrefix;
    boolean isTarget;
    String header;

    public TSVPSMSet(File file, String delimiter, boolean hasHeader, int scoreCol, boolean isGreaterBetter, int specFileCol, int specIndexCol, int pepCol, ArrayList<Pair<Integer, ArrayList<String>>> reqStrList) {
        this.file = file;
        this.delimiter = delimiter;
        this.hasHeader = hasHeader;
        this.scoreCol = scoreCol;
        this.isGreaterBetter = isGreaterBetter;
        this.specFileCol = specFileCol;
        this.specIndexCol = specIndexCol;
        this.pepCol = pepCol;
        this.reqStrList = reqStrList;
        this.dbCol = -1;
        this.decoyProteinPrefix = "XXX";
    }

    public TSVPSMSet decoy(int dbCol, String decoyProteinPrefix, boolean isTarget) {
        this.dbCol = dbCol;
        this.decoyProteinPrefix = decoyProteinPrefix == null || decoyProteinPrefix.isEmpty() ? "XXX" : decoyProteinPrefix;
        this.isTarget = isTarget;
        return this;
    }

    public String getHeader() {
        return this.header;
    }

    @Override
    public boolean isGreaterBetter() {
        return this.isGreaterBetter;
    }

    @Override
    public void read() {
        this.psmList = new ArrayList();
        this.peptideScoreTable = new HashMap();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(this.file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        try {
            String s;
            if (this.hasHeader) {
                this.header = reader.readLine();
            }
            HashSet<String> specKeySet = new HashSet<String>();
            while ((s = reader.readLine()) != null) {
                String[] token;
                if (s.startsWith("#") || this.scoreCol >= (token = s.split(this.delimiter)).length || this.pepCol >= token.length) continue;
                String specFile = this.specFileCol >= 0 ? token[this.specFileCol] : "";
                String specIndex = token[this.specIndexCol];
                String specKey = specFile + ":" + specIndex;
                if (specKeySet.contains(specKey)) continue;
                specKeySet.add(specKey);
                if (this.dbCol >= 0 && (!this.isTarget ? !token[this.dbCol].startsWith(this.decoyProteinPrefix) : token[this.dbCol].startsWith(this.decoyProteinPrefix))) continue;
                if (this.reqStrList != null) {
                    boolean isMatched = true;
                    for (Pair<Integer, ArrayList<String>> pair : this.reqStrList) {
                        boolean containingReqSeq = false;
                        for (String reqStr : pair.getSecond()) {
                            if (!token[pair.getFirst()].contains(reqStr)) continue;
                            containingReqSeq = true;
                            break;
                        }
                        if (!containingReqSeq) {
                            isMatched = false;
                            break;
                        }
                        isMatched = true;
                    }
                    if (!isMatched) continue;
                }
                if (token[this.scoreCol].length() == 0 || !Character.isDigit(token[this.scoreCol].charAt(0))) continue;
                String pep = TSVPSMSet.getPeptideFromAnnotation(token[this.pepCol]);
                float score = Float.parseFloat(token[this.scoreCol]);
                this.psmList.add(new ScoredString(s, Float.valueOf(score)));
                Float prevScore = (Float)this.peptideScoreTable.get(pep);
                if (!(prevScore == null || this.isGreaterBetter && score > prevScore.floatValue()) && (this.isGreaterBetter || !(score < prevScore.floatValue()))) continue;
                this.peptideScoreTable.put(pep, Float.valueOf(score));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void writeResults(TargetDecoyAnalysis tda, PrintStream out, float fdrThreshold, float pepFDRThreshold, boolean writeHeader) {
        if (this.isGreaterBetter) {
            this.writeResults(tda, out, fdrThreshold, pepFDRThreshold, Float.MIN_VALUE, writeHeader);
        } else {
            this.writeResults(tda, out, fdrThreshold, pepFDRThreshold, Float.MAX_VALUE, writeHeader);
        }
    }

    public void writeResults(TargetDecoyAnalysis tda, PrintStream out, float fdrThreshold, float pepFDRThreshold, float scoreThreshold, boolean writeHeader) {
        if (writeHeader && this.header != null) {
            out.println(this.header + this.delimiter + "QValue" + this.delimiter + "PepQValue");
        }
        for (ScoredString ss : this.getPSMList()) {
            String[] token;
            Float pepFDR;
            float psmFDR = tda.getPSMQValue(ss.getScore());
            if (psmFDR > fdrThreshold || this.isGreaterBetter && ss.getScore() <= scoreThreshold || !this.isGreaterBetter && ss.getScore() >= scoreThreshold || (pepFDR = tda.getPepQValueFromAnnotation((token = ss.getStr().split(this.delimiter))[this.pepCol])) == null || pepFDR.floatValue() > pepFDRThreshold) continue;
            String prevResult = ss.getStr();
            if (!prevResult.endsWith(this.delimiter)) {
                prevResult = prevResult + this.delimiter;
            }
            out.println(prevResult + psmFDR + this.delimiter + pepFDR);
        }
        out.flush();
    }

    public int getNumIdentifiedPSMs(TargetDecoyAnalysis tda, float fdrThreshold) {
        int numID = 0;
        for (ScoredString ss : this.getPSMList()) {
            float psmFDR = tda.getPSMQValue(ss.getScore());
            if (psmFDR > fdrThreshold) continue;
            ++numID;
        }
        return numID;
    }

    public int getNumIdentifiedPeptides(TargetDecoyAnalysis tda, float pepFDRThreshold) {
        HashSet<String> pepSet = new HashSet<String>();
        for (ScoredString ss : this.getPSMList()) {
            String[] token = ss.getStr().split(this.delimiter);
            Float pepFDR = tda.getPepQValueFromAnnotation(token[this.pepCol]);
            if (pepFDR == null || pepFDR.floatValue() > pepFDRThreshold) continue;
            pepSet.add(TSVPSMSet.getPeptideFromAnnotation(token[this.pepCol]));
        }
        return pepSet.size();
    }

    public static String getPeptideFromAnnotation(String annotation) {
        String pep = annotation.matches("[A-Z\\-_]?\\..+\\.[A-Z\\-_]?") ? annotation.substring(annotation.indexOf(46) + 1, annotation.lastIndexOf(46)) : annotation;
        pep = pep.toUpperCase();
        return pep;
    }

    public static void main(String[] argv) throws Exception {
        File file = new File("/home/sangtaekim/Research/ToolDistribution/Test/inspect.out");
        ArrayList<Pair<Integer, ArrayList<String>>> reqStrList = new ArrayList<Pair<Integer, ArrayList<String>>>();
        ArrayList<String> charges = new ArrayList<String>();
        charges.add("1");
        charges.add("3");
        ArrayList<String> peps = new ArrayList<String>();
        peps.add("EE");
        reqStrList.add(new Pair(2, peps));
        reqStrList.add(new Pair(4, charges));
        TSVPSMSet psmSet = new TSVPSMSet(file, "\t", true, 14, true, 0, 1, 2, reqStrList);
        psmSet.read();
        psmSet.printPeptideScoreTable();
    }
}

