/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.ims;

import edu.ucsd.msjava.parser.BufferedLineReader;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class DtaToMSGFInput {
    public static void main(String[] argv) throws Exception {
        File dtaPath;
        if (argv.length != 1) {
            DtaToMSGFInput.printUsageAndExit("Invalid parameter");
        }
        if (!(dtaPath = new File(argv[0])).exists()) {
            DtaToMSGFInput.printUsageAndExit("File does not exist.");
        }
        ArrayList<File> dtaFileList = new ArrayList<File>();
        if (dtaPath.isDirectory()) {
            for (File f : dtaPath.listFiles()) {
                if (!f.getName().endsWith("_dta.txt")) continue;
                dtaFileList.add(f);
            }
        } else if (dtaPath.getName().endsWith("_dta.txt")) {
            dtaFileList.add(dtaPath);
        }
        if (dtaFileList.size() == 0) {
            DtaToMSGFInput.printUsageAndExit("No _dta.txt file!");
        }
        DtaToMSGFInput.makeMSGFInput(dtaFileList);
    }

    public static void printUsageAndExit(String message) {
        if (message != null) {
            System.out.println(message);
        }
        System.out.println("Usage: java DtaToMSGFInput DTAPath");
        System.exit(-1);
    }

    public static void makeMSGFInput(List<File> dtaFileList) throws Exception {
        for (File dtaFile : dtaFileList) {
            String dtaFilePath = dtaFile.getAbsolutePath();
            String msgfInputFilePath = dtaFilePath.substring(0, dtaFilePath.lastIndexOf("_dta.txt")) + "_msgfInput.txt";
            File msgfInputFile = new File(msgfInputFilePath);
            System.out.println(dtaFile.getName() + "->" + msgfInputFile.getName());
            DtaToMSGFInput.makeMSGFInput(dtaFile, msgfInputFile);
        }
    }

    public static void makeMSGFInput(File dtaFile, File msgfInputFile) throws Exception {
        String s;
        PrintStream msgfOut = new PrintStream(new BufferedOutputStream(new FileOutputStream(msgfInputFile)));
        String header = "#SpectrumFile\tScan#\tAnnotation\tEmpFormula\tCharge\tNET\tAbundance";
        msgfOut.println(header);
        BufferedLineReader in = new BufferedLineReader(dtaFile.getPath());
        int lineNum = 0;
        int origSpecIndex = 0;
        while ((s = in.readLine()) != null) {
            ++lineNum;
            if (!s.startsWith("===")) continue;
            ++origSpecIndex;
            String metaInfo = s.substring(s.indexOf(34) + 1, s.lastIndexOf(".dta"));
            String[] token = metaInfo.split("\\.");
            if (token.length != 6) {
                System.out.println("Syntax Error in Line " + lineNum + ": " + s);
                System.exit(-1);
            }
            String annotation = token[0].replaceAll("!", "").replaceAll("@", "+15.995").replaceAll("\\*", "+15.995");
            String formula = token[1];
            int charge = Integer.parseInt(token[2]);
            float net = Float.parseFloat(token[3] + "." + token[4]);
            int abundance = Integer.parseInt(token[5]);
            msgfOut.println(dtaFile.getName() + "\t" + origSpecIndex + "\t" + annotation + "\t" + formula + "\t" + charge + "\t" + net + "\t" + abundance);
        }
        in.close();
        msgfOut.close();
    }
}

