/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.ims;

import edu.ucsd.msjava.parser.BufferedLineReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class GetTheBestPerScan {
    public static void main(String[] argv) throws Exception {
        File tsvFile;
        if (argv.length != 1) {
            GetTheBestPerScan.printUsageAndExit("Invalid parameter.");
        }
        if (!(tsvFile = new File(argv[0])).exists()) {
            GetTheBestPerScan.printUsageAndExit("File does not exist.");
        }
        GetTheBestPerScan.getTheBest(tsvFile);
    }

    public static void printUsageAndExit(String message) {
        if (message != null) {
            System.out.println(message);
        }
        System.out.println("Usage: java GetTheBestPerScan TSVFile");
        System.exit(-1);
    }

    public static void getTheBest(File tsvFile) throws Exception {
        String s;
        BufferedLineReader in = new BufferedLineReader(tsvFile.getPath());
        String header = in.readLine();
        String[] headerToken = header.split("\t");
        int dtaIndexCol = -1;
        int specProbCol = -1;
        for (int i = 0; i < headerToken.length; ++i) {
            if (headerToken[i].equalsIgnoreCase("DtaIndex")) {
                dtaIndexCol = i;
            }
            if (!headerToken[i].equalsIgnoreCase("SpecProb")) continue;
            specProbCol = i;
        }
        if (dtaIndexCol == -1) {
            System.err.println("DtaIndex column does not exist.");
            System.exit(-1);
        }
        if (specProbCol == -1) {
            System.err.println("SpecProb column does not exist.");
            System.exit(-1);
        }
        HashMap<Integer, String> table = new HashMap<Integer, String>();
        while ((s = in.readLine()) != null) {
            String[] token = s.split("\t");
            int dtaIndex = Integer.parseInt(token[dtaIndexCol]);
            String prev = (String)table.get(dtaIndex);
            if (prev == null) {
                table.put(dtaIndex, s);
                continue;
            }
            String[] tokenPrev = prev.split("\t");
            float prevSpecProb = Float.parseFloat(tokenPrev[specProbCol]);
            float specProb = Float.parseFloat(token[specProbCol]);
            if (!(specProb < prevSpecProb)) continue;
            table.put(dtaIndex, s);
        }
        in.close();
        ArrayList indexList = new ArrayList(table.keySet());
        Collections.sort(indexList);
        System.out.println(header);
        Iterator iterator = indexList.iterator();
        while (iterator.hasNext()) {
            int dtaIndex = (Integer)iterator.next();
            System.out.println((String)table.get(dtaIndex));
        }
    }
}

