/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.ims;

import edu.ucsd.msjava.parser.BufferedLineReader;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class Summarize {
    public static void main(String[] argv) throws Exception {
        Summarize.summarize();
    }

    public static void summarize() throws Exception {
        String s;
        File dir = new File("/Users/kims336/Research/Data/IMS/5milTargetsRev/");
        File resultFile = new File(dir.getPath() + File.separator + "bestPerPeptides_Rev.tsv");
        BufferedLineReader in = new BufferedLineReader(resultFile.getPath());
        String headerLine = in.readLine();
        String[] header = headerLine.split("\t");
        int specProbCol = -1;
        for (int i = 0; i < header.length; ++i) {
            if (!header[i].equals("SpecProb")) continue;
            specProbCol = i;
        }
        if (specProbCol < 0) {
            System.out.println("No SpecProb column");
            System.exit(-1);
        }
        PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(dir.getPath() + File.separator + "goodPeptides.tsv")));
        out.println(headerLine);
        float[] threshold = new float[]{1.0E-10f, 1.0E-11f, 1.0E-12f, 1.0E-13f};
        int[] numID = new int[threshold.length];
        while ((s = in.readLine()) != null) {
            int i;
            String[] token;
            if (s.startsWith("#") || s.length() == 0 || (token = s.split("\t")).length != header.length) continue;
            float specProb = Float.parseFloat(token[specProbCol]);
            if (specProb < threshold[0]) {
                out.print(token[0]);
                for (i = 1; i < token.length; ++i) {
                    if (i == 2) {
                        out.print("\t" + token[i].replaceAll("\\+15\\.995", "@").replaceAll("C", "C!"));
                        continue;
                    }
                    out.print("\t" + token[i]);
                }
                out.println();
            }
            for (i = 0; i < threshold.length; ++i) {
                if (!(specProb < threshold[i])) continue;
                int n = i;
                numID[n] = numID[n] + 1;
            }
        }
        System.out.println("Threshold\tNumID");
        for (int i = 0; i < threshold.length; ++i) {
            System.out.println(threshold[i] + "\t" + numID[i]);
        }
        in.close();
        out.close();
    }
}

