/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.misc;

import edu.ucsd.msjava.msgf.Tolerance;
import edu.ucsd.msjava.msutil.AminoAcid;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Composition;
import edu.ucsd.msjava.msutil.CompositionFactory;
import edu.ucsd.msjava.msutil.IonType;
import edu.ucsd.msjava.msutil.Peak;
import edu.ucsd.msjava.msutil.Peptide;
import edu.ucsd.msjava.msutil.SpectraIterator;
import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.msutil.WindowFilter;
import edu.ucsd.msjava.parser.MgfSpectrumParser;
import edu.ucsd.msjava.parser.SpectrumParser;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;

public class AgilentQTOF {
    public static void main(String[] argv) throws Exception {
    }

    public static void trypsinTest() throws Exception {
        SpectraIterator itr = new SpectraIterator("/home/sangtaekim/Research/Data/HeckRevision/AnnotatedSpectra/CID_Tryp_Confident.mgf", (SpectrumParser)new MgfSpectrumParser());
        int[] numSpecs = new int[100];
        int[] numSpecsPrecedingKR = new int[100];
        int[] numSpecsEndingKR = new int[100];
        while (itr.hasNext()) {
            int charge;
            Spectrum spec = itr.next();
            int n = charge = spec.getCharge();
            numSpecs[n] = numSpecs[n] + 1;
            String annotation = spec.getAnnotationStr();
            char lastChar = annotation.charAt(annotation.length() - 1);
            if (lastChar != 'K' && lastChar != 'R') continue;
            int n2 = charge;
            numSpecsEndingKR[n2] = numSpecsEndingKR[n2] + 1;
        }
        for (int c = 2; c <= 7; ++c) {
            System.out.println(c + "\t" + (float)numSpecsEndingKR[c] / (float)numSpecs[c]);
        }
    }

    public static void testFixedLengthAAGraph() throws Exception {
        int numBits = 15;
        AminoAcidSet aaSet = AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys();
        float maxErrPPM = 0.0f;
        float avgErrPPM = 0.0f;
        int size = 0;
        for (AminoAcid aa : aaSet) {
            Composition c = aa.getComposition();
            ++size;
            float mass = c.getMass();
            String byteStr = AgilentQTOF.floatToByteStr(c.getMass(), numBits);
            float approxMass = AgilentQTOF.byteStrToFloat(byteStr);
            float errPPM = (approxMass - mass) / mass * 1000000.0f;
            if (Math.abs(errPPM) > maxErrPPM) {
                maxErrPPM = Math.abs(errPPM);
            }
            avgErrPPM += errPPM * aa.getProbability();
            System.out.println(c + "\t" + c.getMass() + "\t" + byteStr + "\t" + approxMass + "\t" + errPPM + "\t" + AgilentQTOF.round(mass, numBits));
        }
        System.out.println("MaxErr: " + maxErrPPM);
        System.out.println("AvgErr: " + avgErrPPM);
    }

    private static float round(float f, int numBits) {
        int intVal = Float.floatToIntBits(f);
        int carry = (intVal & 1 << 23 - numBits - 1) == 0 ? 0 : 1;
        int intRounded = (intVal >> 23 - numBits) + carry << 23 - numBits;
        float rounded = Float.intBitsToFloat(intRounded);
        return rounded;
    }

    private static float byteStrToFloat(String byteStr) {
        return Float.intBitsToFloat(Integer.parseInt(byteStr, 2));
    }

    private static String floatToByteStr(float f, int numBits) {
        int intValue = Float.floatToIntBits(f);
        String byteStr = Integer.toBinaryString(intValue);
        for (int i = byteStr.length(); i < 32; ++i) {
            byteStr = "0" + byteStr;
        }
        String sign = byteStr.substring(0, 1);
        String exp = byteStr.substring(1, 9);
        StringBuffer fraction = new StringBuffer(byteStr.substring(9));
        if (numBits < fraction.length()) {
            char carry = fraction.charAt(numBits);
            for (int i = fraction.length() - 1; i >= 0; --i) {
                if (i >= numBits) {
                    fraction.setCharAt(i, '0');
                    continue;
                }
                if (carry != '1') continue;
                if (fraction.charAt(i) == '1') {
                    fraction.setCharAt(i, '0');
                    continue;
                }
                fraction.setCharAt(i, '1');
                break;
            }
        }
        return sign + exp + fraction;
    }

    public static void graphTest() throws Exception {
        AminoAcidSet aaSet = AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys();
        int maxLength = 20;
        long time = System.currentTimeMillis();
        CompositionFactory allCompositions = new CompositionFactory(aaSet, null, maxLength);
        System.out.println("Composibion Building: " + (System.currentTimeMillis() - time));
        Tolerance tol = Tolerance.parseToleranceStr("30ppm");
        float maxJumpMass = 700.0f;
        String fileName = "/home/sangtaekim/Research/Data/AgilentQTOF/annotatedAgilentQTOF.mgf";
        WindowFilter filter = new WindowFilter(6, 50.0f);
        SpectraIterator itr = new SpectraIterator(fileName, (SpectrumParser)new MgfSpectrumParser());
        int numSpecs = 0;
        int sumEdges = 0;
        while (itr.hasNext()) {
            Spectrum s = itr.next();
            Spectrum spec = filter.apply(s);
            Peptide pep = spec.getAnnotation();
            if (pep.size() > maxLength || spec.getCharge() != 2) continue;
            ++numSpecs;
            int numEdges = 0;
            for (int i = 0; i < spec.size(); ++i) {
                Peak p1 = (Peak)spec.get(i);
                for (int j = i + 1; j < spec.size(); ++j) {
                    Peak p2 = (Peak)spec.get(j);
                    float diff = p2.getMass() - p1.getMass();
                    if (allCompositions.getNodes(diff, tol).size() <= 0) continue;
                    ++numEdges;
                }
            }
            sumEdges += numEdges;
            System.out.println(pep + "\t" + numEdges);
        }
        System.out.println("AvgNumEdges: " + (float)sumEdges / (float)numSpecs);
    }

    public static void ionProb() throws Exception {
        IonType[] ions = new IonType[]{IonType.Y};
        Tolerance tol = Tolerance.parseToleranceStr("30ppm");
        int numJumps = 0;
        float maxJumpMass = 500.0f;
        int maxLength = 20;
        String fileName = "/home/sangtaekim/Research/Data/AgilentQTOF/annotatedAgilentQTOF.mgf";
        WindowFilter filter = new WindowFilter(6, 50.0f);
        SpectraIterator itr = new SpectraIterator(fileName, (SpectrumParser)new MgfSpectrumParser());
        int numCleavages = 0;
        int numCleavagesWithPeaks = 0;
        int numSpecs = 0;
        int numPeaks = 0;
        int numSpecsWithSpecGraphPath = 0;
        while (itr.hasNext()) {
            Spectrum s = itr.next();
            Spectrum spec = s;
            Peptide pep = spec.getAnnotation();
            if (pep.size() > maxLength || spec.getCharge() != 2) continue;
            ++numSpecs;
            numPeaks += spec.size();
            float suffixMass = 0.0f;
            boolean specGraphHasPath = true;
            float prevSuffixMassWithPeak = 0.0f;
            int prevI = pep.size();
            for (int i = pep.size() - 1; i > 0; --i) {
                ++numCleavages;
                float prefixMass = spec.getPrecursorMass() - 18.010565f - (suffixMass += pep.get(i).getMass());
                boolean peakExists = false;
                for (IonType ion : ions) {
                    float mass = ion instanceof IonType.PrefixIon ? ion.getMz(prefixMass) : ion.getMz(suffixMass);
                    ArrayList<Peak> peakList = spec.getPeakListByMass(mass, tol);
                    if (peakList.size() <= 0) continue;
                    peakExists = true;
                    prevI = i;
                    prevSuffixMassWithPeak = suffixMass;
                    break;
                }
                if (peakExists) {
                    ++numCleavagesWithPeaks;
                    continue;
                }
                if (prevI - i <= numJumps) {
                    ++numCleavagesWithPeaks;
                }
                if (!(suffixMass - prevSuffixMassWithPeak > maxJumpMass)) continue;
                specGraphHasPath = false;
            }
            if (!specGraphHasPath) continue;
            ++numSpecsWithSpecGraphPath;
        }
        System.out.print("Ion:");
        for (IonType ion : ions) {
            System.out.print(" " + ion.getName());
        }
        System.out.println();
        System.out.println("NumSpec: " + numSpecs);
        System.out.println("RatioSpecWithSpecGraphPath: " + (float)numSpecsWithSpecGraphPath / (float)numSpecs);
        System.out.println("AverageNumPeaks: " + (float)numPeaks / (float)numSpecs);
        System.out.println("IonProb: " + (float)numCleavagesWithPeaks / (float)numCleavages);
    }

    public static void correctChargeZero() throws Exception {
        String fileName = "/home/sangtaekim/Research/Data/AgilentQTOF/annotatedAgilentQTOF.mgf";
        String outputFileName = "/home/sangtaekim/Research/Data/AgilentQTOF/annotatedAgilentQTOF_NoC0.mgf";
        PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(outputFileName)));
        SpectraIterator itr = new SpectraIterator(fileName, (SpectrumParser)new MgfSpectrumParser());
        while (itr.hasNext()) {
            Spectrum spec = itr.next();
            if (spec.getCharge() == 0) {
                Peptide pep = spec.getAnnotation();
                int charge = Math.round(pep.getParentMass() / spec.getPrecursorPeak().getMz());
                spec.setCharge(charge);
            }
            spec.outputMgf(out);
        }
        out.close();
    }

    public static void compositionDensity() throws Exception {
        AminoAcidSet aaSet = AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys();
        int maxLength = 10;
        long time = System.currentTimeMillis();
        CompositionFactory allCompositions = new CompositionFactory(aaSet, null, maxLength);
        System.out.println("Composibion Building: " + (System.currentTimeMillis() - time));
        float clusterSizePPM = 30.0f;
        int clusterIndex = 1;
        ArrayList<Composition> cluster = new ArrayList<Composition>();
        System.out.println("0\t0\t1");
        for (int i = 1; i < allCompositions.getData().length; ++i) {
            Composition comp = new Composition(allCompositions.getData()[i]);
            if (cluster.size() == 0) {
                cluster.add(comp);
                continue;
            }
            float firstCompMass = ((Composition)cluster.get(0)).getMass();
            float massDiffPPM = (comp.getMass() - firstCompMass) / firstCompMass * 1000000.0f;
            if (massDiffPPM < clusterSizePPM) {
                cluster.add(comp);
                continue;
            }
            float avgMass = (((Composition)cluster.get(0)).getMass() + ((Composition)cluster.get(cluster.size() - 1)).getMass()) / 2.0f;
            System.out.println(clusterIndex + "\t" + avgMass + "\t" + cluster.size() + "\t" + i);
            ++clusterIndex;
            cluster.clear();
        }
    }
}

