/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.misc;

import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.CompositionFactory;
import edu.ucsd.msjava.parser.BufferedLineReader;

public class CompGraphPaper {
    public static void main(String[] argv) throws Exception {
        CompGraphPaper.sizeAllPeptides();
    }

    public static void sizeAllPeptides() throws Exception {
        float num = 0.0f;
        for (int i = 1; i <= 20; ++i) {
            num = (float)((double)num + Math.pow(20.0, i));
            System.out.println(i + "\t" + num);
        }
    }

    public static void sizeCompGraph() throws Exception {
        AminoAcidSet aaSet = AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys();
        for (int i = 1; i <= 20; ++i) {
            CompositionFactory factory = new CompositionFactory(aaSet, null, i);
            System.out.println(i + "\t" + factory.size());
        }
    }

    public static void processErrorSimulResults(String tolStr) throws Exception {
        String s;
        String fileName = System.getProperty("user.home") + "/Research/Data/SwedCAD/diffErr.txt";
        fileName = System.getProperty("user.home") + "/Research/Data/SwedCAD/swedFedMSGF.txt";
        BufferedLineReader in = new BufferedLineReader(fileName);
        float[] specProbThreshold = new float[]{1.0E-8f, 1.0E-9f, 1.0E-10f, 1.0E-11f, 1.0E-12f, 1.0E-13f};
        int[] numIdentifiedSpec = new int[specProbThreshold.length];
        boolean process = false;
        int numProcessedSpecs = 0;
        int numCorrectDeNovo = 0;
        while ((s = in.readLine()) != null) {
            int rawScore;
            String peptide;
            String[] token;
            if (s.startsWith("#")) {
                if (s.equalsIgnoreCase("#" + tolStr)) {
                    process = true;
                } else if (process) break;
            }
            if (!process || (token = s.split("\t")).length != 8 || (peptide = token[1]).length() < 7 || peptide.length() > 20) continue;
            ++numProcessedSpecs;
            int msgfScore = Integer.parseInt(token[3]);
            if (msgfScore == (rawScore = Integer.parseInt(token[4]))) {
                ++numCorrectDeNovo;
            }
            float specProb = Float.parseFloat(token[5]);
            for (int i = 0; i < specProbThreshold.length; ++i) {
                if (!(specProb <= specProbThreshold[i])) continue;
                int n = i;
                numIdentifiedSpec[n] = numIdentifiedSpec[n] + 1;
            }
        }
        System.out.println("NumSpectra\t" + numProcessedSpecs);
        System.out.println("DeNovo\t" + numCorrectDeNovo + "\t" + (float)numCorrectDeNovo / (float)numProcessedSpecs);
        System.out.println("NumId");
        for (int i = 0; i < specProbThreshold.length; ++i) {
            System.out.println(specProbThreshold[i] + "\t" + numIdentifiedSpec[i]);
        }
    }
}

