/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.misc;

import edu.ucsd.msjava.parser.MascotParser;
import edu.ucsd.msjava.parser.PSM;
import edu.ucsd.msjava.parser.PSMList;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashSet;

public class DatToTxt {
    public static void main(String[] argv) throws Exception {
        File datFile;
        if (argv.length != 2 && argv.length != 3) {
            DatToTxt.printUsageAndExit("Invalid parameters");
        }
        if (!(datFile = new File(argv[0])).isFile()) {
            DatToTxt.printUsageAndExit(argv[0] + " is not a file.");
        }
        File txtFile = new File(argv[1]);
        boolean isDecoy = false;
        if (argv.length == 3 && argv[2].equalsIgnoreCase("1")) {
            isDecoy = true;
        }
        DatToTxt.datToTxt(datFile, txtFile, isDecoy);
    }

    public static void printUsageAndExit(String message) {
        System.err.println(message);
        System.out.println("usage: java -Xmx3000M DatToTxt datFileName outputFileName [0/1] (0: target, 1:decoy)");
        System.exit(-1);
    }

    public static void datToTxt(File datFile, File txtFile, boolean isDecoy) throws Exception {
        PrintStream out = txtFile == null ? System.out : new PrintStream(new BufferedOutputStream(new FileOutputStream(txtFile)));
        out.println("#Title\tCharge\tAnnotation\tMascotScore\tProtein");
        HashSet<String> titleSet = new HashSet<String>();
        PSMList<PSM> psmList = MascotParser.parseFromDat(datFile.getPath(), isDecoy);
        for (PSM psm : psmList) {
            if (titleSet.contains(psm.getTitle())) continue;
            titleSet.add(psm.getTitle());
            out.print(psm.getTitle() + "\t" + psm.getCharge() + "\t" + psm.getPrecedingResidue() + "." + psm.getPeptideStr() + "." + psm.getSucceedingResidue());
            out.print("\t" + psm.getRawScore() + "\t" + psm.getProtein());
            out.println();
        }
        out.close();
    }
}

