/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.misc;

import edu.ucsd.msjava.msgf.Tolerance;
import edu.ucsd.msjava.msutil.ActivationMethod;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.IonType;
import edu.ucsd.msjava.msutil.Peak;
import edu.ucsd.msjava.msutil.Peptide;
import edu.ucsd.msjava.msutil.SpectraIterator;
import edu.ucsd.msjava.msutil.SpectraMap;
import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.msutil.SpectrumAccessorBySpecIndex;
import edu.ucsd.msjava.msutil.SpectrumAnnotator;
import edu.ucsd.msjava.parser.BufferedLineReader;
import edu.ucsd.msjava.parser.MgfSpectrumParser;
import edu.ucsd.msjava.parser.MzXMLSpectraIterator;
import edu.ucsd.msjava.parser.MzXMLSpectraMap;
import edu.ucsd.msjava.parser.MzXMLToMgfConverter;
import edu.ucsd.msjava.parser.SpectrumParser;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class HeckWhole {
    private static Hashtable<String, Float[]> mascotThresholds;
    private static Hashtable<String, Float[]> msgfThresholds;

    public static void main(String[] argv) throws Exception {
        HeckWhole.countEnzymeCleavage("ETD", "Tryp");
    }

    public static void splitMascotResults() throws Exception {
        String[] enzymes;
        String dir = System.getProperty("user.home") + "/Research/Data/HeckWhole/ResultsShabaz";
        String[] methods = new String[]{"ETD", "CID"};
        for (String enzyme : enzymes = new String[]{"Tryp", "LysN"}) {
            for (String method : methods) {
                String s;
                BufferedLineReader in = new BufferedLineReader(dir + "/" + enzyme + "_" + method + ".txt");
                PrintStream outTarget = new PrintStream(new BufferedOutputStream(new FileOutputStream(dir + "/" + enzyme + "_" + method + "_GygiTarget.txt")));
                PrintStream outDecoy = new PrintStream(new BufferedOutputStream(new FileOutputStream(dir + "/" + enzyme + "_" + method + "_GygiDecoy.txt")));
                String prevTitle = "";
                while ((s = in.readLine()) != null) {
                    if (s.startsWith("#")) continue;
                    String[] token = s.split("\t");
                    assert (token.length == 5);
                    String title = token[0];
                    if (title.equalsIgnoreCase(prevTitle)) continue;
                    prevTitle = title;
                    String protein = token[4];
                    PrintStream out = protein.contains("IPI:REV") ? outDecoy : outTarget;
                    out.println(s);
                }
                outTarget.close();
                outDecoy.close();
            }
        }
    }

    public static void precursorOFF() throws Exception {
        String[] methods = new String[]{"ETD", "CID"};
        String[] enzymes = new String[]{"Tryp", "LysN"};
        int[] charges = new int[]{2, 3};
        int[] chargeReduces = new int[]{0, 1};
        for (String method : methods) {
            for (String enzyme : enzymes) {
                for (int charge : charges) {
                    for (int chargeReduce : chargeReduces) {
                        HeckWhole.precursorOFF(method, enzyme, charge, chargeReduce);
                    }
                }
            }
        }
    }

    public static void precursorOFF(String method, String enzyme, int charge, int chargeReduce) throws Exception {
        if (charge - chargeReduce < 2) {
            return;
        }
        String fileName = System.getProperty("user.home") + "/Research/Data/HeckWhole/AnnotatedSpectra/annotatedHeckWhole_" + method + "_" + enzyme + ".mgf";
        SpectraIterator itr = new SpectraIterator(fileName, (SpectrumParser)new MgfSpectrumParser());
        int[] hist = new int[401];
        int numSpectra = 0;
        while (itr.hasNext()) {
            Spectrum spec = itr.next();
            if (spec.getCharge() != charge) continue;
            ++numSpectra;
            spec.setRanksOfPeaks();
            float precursorMz = spec.getPrecursorPeak().getMz();
            float neutralParentMass = (precursorMz - 1.008665f) * (float)spec.getCharge();
            float mass = (neutralParentMass + (float)(charge - chargeReduce) * 1.008665f) / (float)(charge - chargeReduce);
            for (Peak p : spec) {
                int binNum;
                float offset;
                if (p.getRank() > 20 || !((offset = p.getMz() - mass) > -100.0f) || !(offset < 100.0f)) continue;
                int n = binNum = Math.round(offset / 0.5f) + 200;
                hist[n] = hist[n] + 1;
            }
        }
        System.out.println(method + enzyme);
        System.out.println("#Spectra\t" + numSpectra);
        System.out.println("Charge\t" + charge);
        System.out.println("ConsideredCharge\t" + (charge - chargeReduce));
        System.out.println("Offset\t#Peaks(within rank 20)");
        for (int i = 1; i < hist.length - 1; ++i) {
            System.out.format("%.1f\t%f\n", Float.valueOf(-100.0f + 0.5f * (float)i), Float.valueOf((float)hist[i] / (float)numSpectra));
        }
        System.out.println();
    }

    public static void deNovoPerformance() throws Exception {
        String[] methods = new String[]{"Sum"};
        String[] enzyme = new String[]{"Tryp", "LysN"};
        int[] charges = new int[]{2, 3};
        for (String m : methods) {
            for (String e : enzyme) {
                for (int c : charges) {
                    HeckWhole.deNovoPerformance(m, e, c);
                }
            }
        }
    }

    public static void deNovoPerformance(String method, String enzyme, int charge) throws Exception {
        String fileName = System.getProperty("user.home") + "/Research/Data/HeckWhole/AnnotatedSpectra/annotatedHeckWhole_" + method + "_" + enzyme + ".mgf";
        boolean isSum = false;
        if (method.equals("Sum")) {
            isSum = true;
            fileName = System.getProperty("user.home") + "/Research/Data/HeckWhole/AnnotatedSpectra/annotatedHeckWholeSum_CID_" + enzyme + ".mgf";
        }
        SpectraIterator itr = new SpectraIterator(fileName, (SpectrumParser)new MgfSpectrumParser());
        int numSpecs = 0;
        int numCorrDeNovo = 0;
        while (itr.hasNext()) {
            int peptideScore;
            Spectrum spec = itr.next();
            if (spec.getCharge() != charge) continue;
            ++numSpecs;
            String title = spec.getTitle();
            String[] token = title.split(":");
            int msgfScore = !isSum ? Integer.parseInt(token[3]) : Integer.parseInt(token[4]);
            if (msgfScore != (peptideScore = !isSum ? Integer.parseInt(token[4]) : Integer.parseInt(token[5]))) continue;
            ++numCorrDeNovo;
        }
        System.out.println(method + enzyme + "\t" + charge + "\t" + numSpecs + "\t" + numCorrDeNovo + "\t" + (float)numCorrDeNovo / (float)numSpecs);
    }

    public static void vennDiagramMascotMSGF() throws Exception {
        System.out.println("FileName,ScanNum,Peptide,MascotScore,MSGFPValue");
        String[] enzyme = new String[]{"Tryp", "LysN"};
        String[] methods = new String[]{"CID", "ETD"};
        int[] charges = new int[]{2, 3};
        for (String e : enzyme) {
            for (String m : methods) {
                for (int c : charges) {
                    HeckWhole.vennDiagramMascotMSGF(e, m, c);
                }
            }
        }
    }

    public static void vennDiagramMascotMSGF(String enzyme, String method, int charge) throws Exception {
        int c;
        String s;
        String db = "Target";
        String mascotFileName = System.getProperty("user.home") + "/Research/Data/HeckWhole/ResultsShabaz/" + enzyme + "_" + method + "_" + db + ".txt";
        Hashtable<String, String> mascotResults = new Hashtable<String, String>();
        Hashtable<String, Float> mascotScores = new Hashtable<String, Float>();
        BufferedLineReader in = new BufferedLineReader(mascotFileName);
        int prevScanNum = -1;
        while ((s = in.readLine()) != null) {
            int scanNum;
            String[] token;
            if (!s.startsWith("Elution") || (token = s.split("\t")).length != 5 || (scanNum = Integer.parseInt(token[0].substring(token[0].lastIndexOf(58) + 2))) == prevScanNum) continue;
            prevScanNum = scanNum;
            int indexFileNum = token[0].lastIndexOf(".raw") - 6;
            int fileNum = Integer.parseInt(token[0].substring(indexFileNum, indexFileNum + 2));
            float score = Float.parseFloat(token[3]);
            mascotScores.put(fileNum + ":" + scanNum, Float.valueOf(score));
            c = Integer.parseInt(token[1]);
            if (c != charge) continue;
            if (score <= mascotThresholds.get(method + enzyme)[c - 2].floatValue()) continue;
            String pep = token[2].substring(token[2].indexOf(46) + 1, token[2].lastIndexOf(46));
            mascotResults.put(fileNum + ":" + scanNum, pep);
        }
        HashSet<String> mascotPepSet = new HashSet<String>();
        for (String pep : mascotResults.values()) {
            StringBuffer seq = new StringBuffer();
            for (int i = 0; i < pep.length(); ++i) {
                c = pep.charAt(i);
                if (c == 81) {
                    seq.append('K');
                    continue;
                }
                if (c == 73) {
                    seq.append('L');
                    continue;
                }
                seq.append((char)c);
            }
            mascotPepSet.add(seq.toString());
        }
        Hashtable<String, String> msgfResults = new Hashtable<String, String>();
        Hashtable<String, Float> msgfScores = new Hashtable<String, Float>();
        File dir = new File(System.getProperty("user.home") + "/Research/Data/HeckWhole/Results0209");
        for (File f : dir.listFiles()) {
            if (!f.getName().endsWith("_" + db + ".txt") || !f.getName().contains(method) || !f.getName().contains(enzyme)) continue;
            prevScanNum = -1;
            in = new BufferedLineReader(f.getPath());
            while ((s = in.readLine()) != null) {
                String[] token = s.split("\t");
                int scanNum = Integer.parseInt(token[1]);
                if (scanNum == prevScanNum) continue;
                prevScanNum = scanNum;
                int fileNum = Integer.parseInt(f.getName().substring(f.getName().lastIndexOf("_" + db) - 2, f.getName().lastIndexOf("_" + db)));
                int c2 = Integer.parseInt(token[4]);
                if (c2 != charge) continue;
                String pep = token[5].substring(token[5].indexOf(46) + 1, token[5].lastIndexOf(46));
                float specProb = Float.parseFloat(token[9]);
                float threshold = msgfThresholds.get(method + enzyme)[c2 - 2].floatValue();
                msgfScores.put(fileNum + ":" + scanNum, Float.valueOf(specProb));
                if (!(specProb < threshold)) continue;
                msgfResults.put(fileNum + ":" + scanNum, pep);
            }
        }
        HashSet<String> msgfPepSet = new HashSet<String>();
        for (String pep : msgfResults.values()) {
            StringBuffer seq = new StringBuffer();
            for (int i = 0; i < pep.length(); ++i) {
                char c3 = pep.charAt(i);
                if (c3 == 'Q') {
                    seq.append('K');
                    continue;
                }
                if (c3 == 'I') {
                    seq.append('L');
                    continue;
                }
                seq.append(c3);
            }
            msgfPepSet.add(seq.toString());
        }
        HeckWhole.printVennDiagram(mascotPepSet, msgfPepSet);
        System.out.println();
    }

    private static void printSet1Exclusive(Hashtable<String, String> set1, Hashtable<String, String> set2, String rawFileName, Hashtable<String, Float> mascotScores, Hashtable<String, Float> msgfScores) {
        for (String s : set1.keySet()) {
            if (set2.get(s) != null) continue;
            String fileNum = s.split(":")[0];
            String scanNum = s.split(":")[1];
            Float score1 = mascotScores.get(s);
            Float score2 = msgfScores.get(s);
            System.out.println(rawFileName + fileNum + ".RAW," + scanNum + "," + set1.get(s) + "," + score1 + "," + score2);
        }
    }

    private static void printVennDiagram(Hashtable<String, String> set1, Hashtable<String, String> set2) {
        int set1Only = 0;
        int set2Only = 0;
        int intersection = 0;
        int conflict = 0;
        for (String s : set1.keySet()) {
            if (set2.get(s) != null) {
                ++intersection;
                String pep1 = set1.get(s);
                String pep2 = set2.get(s);
                boolean match = true;
                if (pep1.length() == pep2.length()) {
                    for (int i = 0; i < pep1.length(); ++i) {
                        char c2;
                        char c1 = pep1.charAt(i);
                        if (c1 == (c2 = pep2.charAt(i)) || c1 == 'Q' && c2 == 'K' || c1 == 'I' && c2 == 'L' || c1 == 'K' && c2 == 'Q' || c1 == 'L' && c2 == 'I') continue;
                        match = false;
                        break;
                    }
                } else {
                    match = false;
                }
                if (match) continue;
                ++conflict;
                continue;
            }
            ++set1Only;
        }
        set2Only = set2.size() - intersection;
        System.out.print(set1Only + "\t" + set2Only + "\t" + intersection + "\t" + conflict);
    }

    private static void printVennDiagram(Set<String> set1, Set<String> set2) {
        int set1Only = 0;
        int set2Only = 0;
        int intersection = 0;
        for (String s : set1) {
            if (set2.contains(s)) {
                ++intersection;
                continue;
            }
            ++set1Only;
        }
        set2Only = set2.size() - intersection;
        System.out.print(set1Only + "\t" + set2Only + "\t" + intersection);
    }

    public static void test() throws Exception {
        String method = "ETDTryp";
        String database = "_Target.txt";
        int charge = 2;
        File dir = new File(System.getProperty("user.home") + "/Research/Data/HeckWhole/Results0203");
        HashSet<String> pepset = new HashSet<String>();
        for (File f : dir.listFiles()) {
            String s;
            if (!f.getName().endsWith(database) || !f.getName().contains(method)) continue;
            int prevScanNum = -1;
            BufferedLineReader in = new BufferedLineReader(f.getPath());
            while ((s = in.readLine()) != null) {
                float threshold;
                String[] token = s.split("\t");
                int scanNum = Integer.parseInt(token[1]);
                if (scanNum == prevScanNum) continue;
                prevScanNum = scanNum;
                int c = Integer.parseInt(token[4]);
                if (c != charge) continue;
                String pep = token[5].substring(token[5].indexOf(46) + 1, token[5].lastIndexOf(46));
                float specProb = Float.parseFloat(token[9]);
                if (!(specProb <= (threshold = msgfThresholds.get(method)[c - 2].floatValue()))) continue;
                pepset.add(pep);
            }
        }
        System.out.println(method + "\t" + charge + "\t" + pepset.size());
    }

    /*
     * WARNING - void declaration
     */
    public static void vennDiagram() throws Exception {
        void var26_45;
        int charge = -1;
        String enzyme = "Tryp";
        Hashtable<String, String> cidIDTarget = new Hashtable<String, String>();
        Hashtable<String, String> cidIDDecoy = new Hashtable<String, String>();
        File dir = new File(System.getProperty("user.home") + "/Research/Data/HeckRevision/MSGFDB0720_AAFreq");
        HashSet<String> cid = new HashSet<String>();
        HashSet<String> etd = new HashSet<String>();
        for (File f : dir.listFiles()) {
            float specProb;
            String pep;
            int c;
            String[] token;
            int scanNum;
            String s;
            int prevScanNum;
            BufferedLineReader in;
            if (f.getName().endsWith("_0.txt") && f.getName().contains(enzyme) && f.getName().contains("CID")) {
                in = new BufferedLineReader(f.getPath());
                prevScanNum = -1;
                while ((s = in.readLine()) != null) {
                    if (s.startsWith("#") || (scanNum = Integer.parseInt((token = s.split("\t"))[1])) == prevScanNum) continue;
                    prevScanNum = scanNum;
                    c = Integer.parseInt(token[4]);
                    if (c > 4) {
                        c = 4;
                    }
                    if (charge > 0 && c != charge) continue;
                    pep = token[5].substring(token[5].indexOf(46) + 1, token[5].lastIndexOf(46)) + ":" + c;
                    specProb = Float.parseFloat(token[10]);
                    StringBuilder stringBuilder = new StringBuilder();
                    if (!(specProb < msgfThresholds.get(stringBuilder.append("CID").append(enzyme).toString())[c - 2].floatValue())) continue;
                    cid.add(pep);
                    cidIDTarget.put(token[0] + ":" + token[1], pep);
                }
                continue;
            }
            if (!f.getName().endsWith("_1.txt") || !f.getName().contains(enzyme) || !f.getName().contains("CID")) continue;
            in = new BufferedLineReader(f.getPath());
            prevScanNum = -1;
            while ((s = in.readLine()) != null) {
                if (s.startsWith("#") || (scanNum = Integer.parseInt((token = s.split("\t"))[1])) == prevScanNum) continue;
                prevScanNum = scanNum;
                c = Integer.parseInt(token[4]);
                if (c > 4) {
                    c = 4;
                }
                if (charge > 0 && c != charge) continue;
                pep = token[5].substring(token[5].indexOf(46) + 1, token[5].lastIndexOf(46)) + ":" + c;
                specProb = Float.parseFloat(token[10]);
                StringBuilder stringBuilder = new StringBuilder();
                if (!(specProb < msgfThresholds.get(stringBuilder.append("CID").append(enzyme).toString())[c - 2].floatValue())) continue;
                cidIDDecoy.put(token[0] + ":" + token[1], pep);
            }
        }
        int numCIDOnlyTarget = 0;
        HashSet<String> cidOnlyTarget = new HashSet<String>();
        int numCIDOnlyDecoy = 0;
        HashSet<String> cidOnlyDecoy = new HashSet<String>();
        int numETDOnlyTarget = 0;
        HashSet<String> etdOnlyTarget = new HashSet<String>();
        int numETDOnlyDecoy = 0;
        HashSet<String> etdOnlyDecoy = new HashSet<String>();
        int numBothTarget = 0;
        HashSet<String> bothTarget = new HashSet<String>();
        int numBothDecoy = 0;
        HashSet<String> conflictTarget = new HashSet<String>();
        HashSet<String> bothDecoy = new HashSet<String>();
        HashSet<String> conflictDecoy = new HashSet<String>();
        int numConflictTarget = 0;
        int numConflictDecoy = 0;
        for (File file : dir.listFiles()) {
            String cidPep;
            float specProb;
            String pep;
            int c;
            String[] token;
            int scanNum;
            String s;
            int prevScanNum;
            BufferedLineReader in;
            if (file.getName().endsWith("_0.txt") && file.getName().contains(enzyme) && file.getName().contains("ETD")) {
                in = new BufferedLineReader(file.getPath());
                prevScanNum = -1;
                while ((s = in.readLine()) != null) {
                    if (s.startsWith("#") || (scanNum = Integer.parseInt((token = s.split("\t"))[1])) == prevScanNum) continue;
                    prevScanNum = scanNum;
                    c = Integer.parseInt(token[4]);
                    if (c > 4) {
                        c = 4;
                    }
                    if (charge > 0 && c != charge) continue;
                    pep = token[5].substring(token[5].indexOf(46) + 1, token[5].lastIndexOf(46)) + ":" + c;
                    specProb = Float.parseFloat(token[10]);
                    StringBuilder stringBuilder = new StringBuilder();
                    if (!(specProb < msgfThresholds.get(stringBuilder.append("ETD").append(enzyme).toString())[c - 2].floatValue())) continue;
                    etd.add(pep);
                    cidPep = (String)cidIDTarget.get(token[0] + ":" + (scanNum - 1));
                    if (cidPep == null) {
                        ++numETDOnlyTarget;
                        etdOnlyTarget.add(pep);
                        continue;
                    }
                    if (cidPep.equalsIgnoreCase(pep)) {
                        ++numBothTarget;
                        bothTarget.add(pep);
                    } else {
                        ++numConflictTarget;
                        conflictTarget.add(cidPep + ":" + pep);
                    }
                    cidIDTarget.remove(token[0] + ":" + (scanNum - 1));
                }
                continue;
            }
            if (!file.getName().endsWith("_1.txt") || !file.getName().contains(enzyme) || !file.getName().contains("ETD")) continue;
            in = new BufferedLineReader(file.getPath());
            prevScanNum = -1;
            while ((s = in.readLine()) != null) {
                if (s.startsWith("#") || (scanNum = Integer.parseInt((token = s.split("\t"))[1])) == prevScanNum) continue;
                prevScanNum = scanNum;
                c = Integer.parseInt(token[4]);
                if (c > 4) {
                    c = 4;
                }
                if (charge > 0 && c != charge) continue;
                pep = token[5].substring(token[5].indexOf(46) + 1, token[5].lastIndexOf(46)) + ":" + c;
                specProb = Float.parseFloat(token[10]);
                StringBuilder stringBuilder = new StringBuilder();
                if (!(specProb < msgfThresholds.get(stringBuilder.append("ETD").append(enzyme).toString())[c - 2].floatValue())) continue;
                cidPep = (String)cidIDDecoy.get(token[0] + ":" + (scanNum - 1));
                if (cidPep == null) {
                    ++numETDOnlyDecoy;
                    etdOnlyDecoy.add(pep);
                    continue;
                }
                if (cidPep.equalsIgnoreCase(pep)) {
                    ++numBothDecoy;
                    bothDecoy.add(pep);
                } else {
                    ++numConflictDecoy;
                    conflictDecoy.add(cidPep + ":" + pep);
                }
                cidIDDecoy.remove(token[0] + ":" + (scanNum - 1));
            }
        }
        numCIDOnlyTarget = cidIDTarget.size();
        for (String pep : cidIDTarget.values()) {
            cidOnlyTarget.add(pep);
        }
        numCIDOnlyDecoy = cidIDDecoy.size();
        for (String pep : cidIDDecoy.values()) {
            cidOnlyDecoy.add(pep);
        }
        int numPepCIDOnlyTarget = cidOnlyTarget.size();
        for (String pep : cidOnlyTarget) {
            if (!bothTarget.contains(pep)) continue;
            --numPepCIDOnlyTarget;
        }
        int numPepETDOnlyTarget = etdOnlyTarget.size();
        for (String string : etdOnlyTarget) {
            if (!bothTarget.contains(string)) continue;
            --numPepETDOnlyTarget;
        }
        int numPepCIDOnlyDecoy = cidOnlyDecoy.size();
        for (String pep : cidOnlyDecoy) {
            if (!bothDecoy.contains(pep)) continue;
            --numPepCIDOnlyDecoy;
        }
        int n = etdOnlyDecoy.size();
        for (String pep : etdOnlyDecoy) {
            if (!bothDecoy.contains(pep)) continue;
            --var26_45;
        }
        System.out.println(enzyme);
        System.out.println("*****Target");
        System.out.println("NumCIDOnly: " + numCIDOnlyTarget + "\t" + numPepCIDOnlyTarget);
        System.out.println("NumETDOnly: " + numETDOnlyTarget + "\t" + numPepETDOnlyTarget);
        System.out.println("NumIntersection: " + (numBothTarget + numConflictTarget) + "\t" + bothTarget.size());
        System.out.println("NumConflict: " + numConflictTarget + "\t" + conflictTarget.size());
        System.out.println("*****Decoy");
        System.out.println("NumCIDOnly: " + numCIDOnlyDecoy + "\t" + numPepCIDOnlyDecoy);
        System.out.println("NumETDOnly: " + numETDOnlyDecoy + "\t" + (int)var26_45);
        System.out.println("NumIntersection: " + (numBothDecoy + numConflictDecoy) + "\t" + bothDecoy.size());
        System.out.println("NumConflict: " + numConflictDecoy + "\t" + conflictDecoy.size());
        System.out.println(cid.size() + "\t" + etd.size());
    }

    public static void extractGoodSpectraFromSum() throws Exception {
        String[] enzyme;
        for (String e : enzyme = new String[]{"Tryp", "LysN"}) {
            HeckWhole.extractGoodSpectraFromSum(e, System.getProperty("user.home") + "/Research/Data/HeckWhole/AnnotatedSpectra/annotatedHeckWholeSum_CID_" + e + ".mgf", System.getProperty("user.home") + "/Research/Data/HeckWhole/AnnotatedSpectra/annotatedHeckWholeSum_ETD_" + e + ".mgf");
        }
    }

    public static void rankOnePeakTest() throws Exception {
        String fileName = System.getProperty("user.home") + "/Research/Data/HeckWhole/AnnotatedSpectra/annotatedHeckWhole_ETD_Tryp.mgf";
        int charge = 2;
        Tolerance tolerance = new Tolerance(0.5f);
        IonType[] ionType = new IonType[]{IonType.A, IonType.B, IonType.C, IonType.Y, IonType.Z, IonType.getIonType("b2"), IonType.getIonType("c2"), IonType.getIonType("y2"), IonType.getIonType("z2"), IonType.getIonType("c+H"), IonType.getIonType("z+H"), IonType.getIonType("c-H"), IonType.getIonType("z-H"), IonType.getIonType("b+H"), IonType.getIonType("y+H"), IonType.getIonType("b-H"), IonType.getIonType("y-H")};
        SpectraIterator itr = new SpectraIterator(fileName, (SpectrumParser)new MgfSpectrumParser());
        while (itr.hasNext()) {
            Spectrum spec = itr.next();
            if (spec.getCharge() != charge) continue;
            System.out.println("*****" + spec.getAnnotationStr() + "\t" + spec.getCharge());
            spec.setActivationMethod(ActivationMethod.ETD);
            spec.setRanksOfPeaks();
            Peak rankOnePeak = null;
            for (Peak p : spec) {
                if (p.getRank() != 1) continue;
                rankOnePeak = p;
            }
            boolean isExplained = false;
            spec.setRanksOfPeaks();
            Spectrum newSpec = spec.getCloneWithoutPeakList();
            newSpec.add(rankOnePeak);
            SpectrumAnnotator annotator = new SpectrumAnnotator(newSpec, spec.getAnnotation());
            for (IonType ion : ionType) {
                if (annotator.getPeakListOfIon(ion, tolerance).size() <= 0) continue;
                System.out.println(ion.getName());
                isExplained = true;
                break;
            }
            if (isExplained) continue;
            for (int c = 1; c <= spec.getCharge(); ++c) {
                float mass = (spec.getPrecursorMass() + (float)c * 1.008665f) / (float)c;
                System.out.println("NE " + c + " " + (rankOnePeak.getMz() - mass) + " " + rankOnePeak.getMz() + " " + mass);
            }
        }
    }

    public static void precursorTest() throws Exception {
        String fileName = System.getProperty("user.home") + "/Research/Data/HeckWhole/AnnotatedSpectra/annotatedHeckWhole_ETD_LysN.mgf";
        int charge = 3;
        Tolerance tolerance = new Tolerance(0.3f);
        float[] offsets = new float[]{0.0f, 1.0033548f, 2.003241f, -18.010565f, -36.02113f, -17.026548f, -34.053097f};
        SpectraIterator itr = new SpectraIterator(fileName, (SpectrumParser)new MgfSpectrumParser());
        while (itr.hasNext()) {
            int startCharge;
            Spectrum spec = itr.next();
            spec.setRanksOfPeaks();
            if (spec.getCharge() != charge) continue;
            System.out.println(spec.getAnnotationStr() + "\t" + spec.getCharge());
            float precursorMz = spec.getPrecursorPeak().getMz();
            float neutralParentMass = (precursorMz - 1.008665f) * (float)spec.getCharge();
            for (int c = startCharge = 2; c <= spec.getCharge(); ++c) {
                for (float off : offsets) {
                    float mass = (neutralParentMass + (float)c * 1.008665f + off) / (float)c;
                    for (Peak p : spec.getPeakListByMass(mass, tolerance)) {
                        if (p.getRank() > 10) continue;
                        System.out.println(c + "\t" + off + "\t" + p.getRank());
                        p.setIntensity(0.0f);
                        spec.setRanksOfPeaks();
                    }
                }
            }
        }
    }

    public static void countNumSpectra() throws Exception {
        File dir = new File("/home/sangtaekim/Research/Data/HeckWhole/Spectra");
        int[][] numSpec = new int[2][100];
        for (File f : dir.listFiles()) {
            if (!f.getName().endsWith(".mzXML") && !f.getName().endsWith(".mgf")) continue;
            int frag = 0;
            if (f.getName().contains("LysN")) {
                frag = 1;
            }
            Iterator<Spectrum> itr = null;
            itr = f.getName().endsWith(".mzXML") ? new MzXMLSpectraIterator(f.getPath()) : new SpectraIterator(f.getPath(), (SpectrumParser)new MgfSpectrumParser());
            int prevScanNum = -1;
            float prevPrecursorMz = 0.0f;
            while (itr.hasNext()) {
                Spectrum spec = itr.next();
                if (spec.getScanNum() == prevScanNum + 1 && Math.abs(prevPrecursorMz - spec.getPrecursorPeak().getMz()) < 0.01f) {
                    int[] nArray = numSpec[frag];
                    int n = spec.getCharge();
                    nArray[n] = nArray[n] + 1;
                    continue;
                }
                prevScanNum = spec.getScanNum();
                prevPrecursorMz = spec.getPrecursorPeak().getMz();
            }
        }
        for (int i = 0; i <= 1; ++i) {
            String method = i == 0 ? "Trypsin" : "LysN";
            System.out.println(method);
            for (int j = 1; j < 100; ++j) {
                if (numSpec[i][j] <= 0) continue;
                System.out.println(j + "\t" + numSpec[i][j]);
            }
        }
        System.out.println("Done");
    }

    public static void convertMzXMLIntoMgf() throws Exception {
        String[] enzymes;
        String dirName = System.getProperty("user.home") + "/Research/Data/HeckWhole/Spectra";
        File dir = new File(dirName);
        ActivationMethod[] methods = new ActivationMethod[]{ActivationMethod.CID, ActivationMethod.ETD};
        for (String enzyme : enzymes = new String[]{"Tryp", "LysN"}) {
            for (ActivationMethod method : methods) {
                for (File f : dir.listFiles()) {
                    if (!f.getName().contains(enzyme) || !f.getName().endsWith(".mzXML")) continue;
                    System.out.print(f.getName() + " " + method + " " + enzyme + "...");
                    String mgfFileName = f.getParent() + File.separator + f.getName().substring(0, f.getName().lastIndexOf(46)) + "_" + method + ".mgf";
                    MzXMLToMgfConverter.convert(f, new File(mgfFileName), 0, 10000, method, 2, 2);
                }
            }
        }
    }

    public static void extractGoodSpectra() throws Exception {
        String[] methods = new String[]{"CID", "ETD"};
        String[] enzymes = new String[]{"Tryp", "LysN"};
        for (String method : methods) {
            for (String enzyme : enzymes) {
                HeckWhole.extractGoodSpectra(method, enzyme, System.getProperty("user.home") + "/Research/Data/HeckRevision/AnnotatedSpectra/" + method + "_" + enzyme + "_Confident.mgf");
            }
        }
        System.out.println("Done");
    }

    public static void countEnzymeCleavage(String method, String enzyme) throws Exception {
        File dir = new File(System.getProperty("user.home") + "/Research/Data/HeckRevision");
        File resDir = new File(dir.getPath() + "/MSGFDB0720_AAFreq");
        String metID = method + enzyme;
        int numID = 0;
        int numPrecedingKR = 0;
        int numEndingKR = 0;
        for (File f : resDir.listFiles()) {
            String s;
            if (!f.getName().endsWith("_0.txt") || !f.getName().contains(metID)) continue;
            BufferedLineReader in = new BufferedLineReader(f.getPath());
            int prevScanNum = -1;
            while ((s = in.readLine()) != null) {
                char lastAA;
                float specProb;
                int scanNum;
                if (s.startsWith("#")) continue;
                String[] token = s.split("\t");
                if (token.length != 11) assert (false);
                if (!token[2].equalsIgnoreCase(method) || (scanNum = Integer.parseInt(token[1])) == prevScanNum) continue;
                prevScanNum = scanNum;
                int charge = Integer.parseInt(token[4]);
                int chargeIndex = charge - 2;
                if (chargeIndex > 2) {
                    chargeIndex = 2;
                }
                if ((specProb = Float.parseFloat(token[10])) >= msgfThresholds.get(metID)[chargeIndex].floatValue()) continue;
                String annotation = token[5];
                ++numID;
                if (annotation.charAt(0) == 'K' || annotation.charAt(0) == 'R') {
                    ++numPrecedingKR;
                }
                if ((lastAA = annotation.charAt(annotation.lastIndexOf(46) - 1)) != 'K' && lastAA != 'R') continue;
                ++numEndingKR;
            }
        }
        System.out.println(numID + "\t" + (float)numPrecedingKR / (float)numID + "\t" + (float)numEndingKR / (float)numID);
    }

    public static void extractGoodSpectra(String method, String enzyme, String outFileName) throws Exception {
        System.out.println(method + enzyme + " " + outFileName);
        File dir = new File(System.getProperty("user.home") + "/Research/Data/HeckRevision");
        File resDir = new File(dir.getPath() + "/MSGFDB0720_AAFreq");
        File specDir = new File(System.getProperty("user.home") + "/Research/Data/HeckWhole/Spectra");
        String metID = method + enzyme;
        Hashtable<String, MzXMLSpectraMap> specTable = new Hashtable<String, MzXMLSpectraMap>();
        for (File f : specDir.listFiles()) {
            if (!f.getName().contains(enzyme) || !f.getName().endsWith("mzXML")) continue;
            specTable.put(f.getName(), new MzXMLSpectraMap(f.getPath()));
        }
        Hashtable<String, Float> pepScoreTable = new Hashtable<String, Float>();
        Hashtable<String, String> pepSpecTable = new Hashtable<String, String>();
        for (File f : resDir.listFiles()) {
            String s;
            if (!f.getName().endsWith("_0.txt") || !f.getName().contains(metID)) continue;
            BufferedLineReader in = new BufferedLineReader(f.getPath());
            int prevScanNum = -1;
            while ((s = in.readLine()) != null) {
                String peptide;
                Float prevBestScore;
                float specProb;
                int scanNum;
                if (s.startsWith("#")) continue;
                String[] token = s.split("\t");
                if (token.length != 11) assert (false);
                if (!token[2].equalsIgnoreCase(method) || (scanNum = Integer.parseInt(token[1])) == prevScanNum) continue;
                prevScanNum = scanNum;
                int charge = Integer.parseInt(token[4]);
                int chargeIndex = charge - 2;
                if (chargeIndex > 2) {
                    chargeIndex = 2;
                }
                if ((specProb = Float.parseFloat(token[10])) >= msgfThresholds.get(metID)[chargeIndex].floatValue() || (prevBestScore = (Float)pepScoreTable.get((peptide = token[5].substring(token[5].indexOf(46) + 1, token[5].lastIndexOf(46))) + "|" + chargeIndex)) != null && !(specProb < prevBestScore.floatValue())) continue;
                pepScoreTable.put(peptide + "|" + chargeIndex, Float.valueOf(specProb));
                pepSpecTable.put(peptide + "|" + chargeIndex, token[0] + ":" + token[1] + ":" + token[7] + ":" + token[8]);
            }
        }
        PrintStream mgfOut = new PrintStream(new BufferedOutputStream(new FileOutputStream(outFileName)));
        ArrayList pepSet = new ArrayList(pepSpecTable.keySet());
        for (String pep : pepSet) {
            String specInfo = (String)pepSpecTable.get(pep);
            String[] token = specInfo.split(":");
            assert (token.length == 4) : specInfo;
            String fileName = token[0];
            int scanNum = Integer.parseInt(token[1]);
            int msgfScore = Integer.parseInt(token[2]);
            int peptideScore = (int)Float.parseFloat(token[3]);
            SpectrumAccessorBySpecIndex map = (SpectrumAccessorBySpecIndex)specTable.get(fileName);
            assert (map != null);
            Spectrum spec = map.getSpectrumBySpecIndex(scanNum);
            assert (spec != null);
            Float specProb = (Float)pepScoreTable.get(pep);
            assert (specProb != null);
            spec.setTitle(fileName + ":" + scanNum + ":" + specProb + ":" + msgfScore + ":" + peptideScore);
            String pepSeq = pep.substring(0, pep.lastIndexOf(124));
            spec.setAnnotation(new Peptide(pepSeq, AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys()));
            spec.outputMgf(mgfOut);
        }
        mgfOut.flush();
        mgfOut.close();
    }

    public static void extractGoodSpectraFromMascot(String method, String enzyme, String outFileName) throws Exception {
        File dir = new File(System.getProperty("user.home") + "/Research/Data/HeckWhole/");
        File resDir = new File(dir.getPath() + "/ResultsShabaz");
        File specDir = new File(dir.getPath() + "/Spectra");
        String metID = method + enzyme;
        Hashtable<String, SpectrumAccessorBySpecIndex> specTable = new Hashtable<String, SpectrumAccessorBySpecIndex>();
        for (File f : specDir.listFiles()) {
            if (!f.getName().contains(enzyme)) continue;
            if (f.getName().endsWith("mzXML")) {
                specTable.put(f.getName(), new MzXMLSpectraMap(f.getPath()));
                continue;
            }
            if (!f.getName().endsWith("mgf")) continue;
            specTable.put(f.getName(), new SpectraMap(f.getPath(), new MgfSpectrumParser()));
        }
        Hashtable<String, Float> pepScoreTable = new Hashtable<String, Float>();
        Hashtable<String, String> pepSpecTable = new Hashtable<String, String>();
        for (File f : resDir.listFiles()) {
            String s;
            if (!f.getName().endsWith("_Target.txt") || !f.getName().contains(method) || !f.getName().contains(enzyme)) continue;
            BufferedLineReader in = new BufferedLineReader(f.getPath());
            String prevScanNum = "";
            while ((s = in.readLine()) != null) {
                String peptide;
                Float prevBestScore;
                float mascotScore;
                if (s.startsWith("#")) continue;
                String[] token = s.split("\t");
                if (token.length != 5) assert (false);
                String scanNum = token[0];
                if (scanNum.equalsIgnoreCase(prevScanNum)) continue;
                prevScanNum = scanNum;
                int charge = Integer.parseInt(token[1]);
                if (charge > 4) {
                    charge = 4;
                }
                if ((mascotScore = Float.parseFloat(token[9])) >= mascotThresholds.get(metID)[charge - 2].floatValue() || (prevBestScore = (Float)pepScoreTable.get((peptide = token[2].substring(token[2].indexOf(46) + 1, token[2].lastIndexOf(46))) + "|" + token[1])) != null && !(mascotScore < prevBestScore.floatValue())) continue;
                pepScoreTable.put(peptide + "|" + token[1], Float.valueOf(mascotScore));
                pepSpecTable.put(peptide + "|" + token[1], token[0]);
            }
        }
        PrintStream mgfOut = new PrintStream(new BufferedOutputStream(new FileOutputStream(outFileName)));
        ArrayList pepSet = new ArrayList(pepSpecTable.keySet());
        for (String pep : pepSet) {
            String specInfo = (String)pepSpecTable.get(pep);
            String fileName = specInfo.substring(specInfo.indexOf("_nm_") + 4, specInfo.lastIndexOf("raw") - 5);
            int scanNum = Integer.parseInt(specInfo.substring(specInfo.lastIndexOf("ScanNumber:") + 12));
            SpectrumAccessorBySpecIndex map = (SpectrumAccessorBySpecIndex)specTable.get(fileName);
            assert (map != null);
            Spectrum spec = map.getSpectrumBySpecIndex(scanNum);
            assert (spec != null);
            Float mascotScore = (Float)pepScoreTable.get(pep);
            assert (mascotScore != null);
            spec.setTitle(specInfo + ":" + mascotScore);
            String pepSeq = pep.substring(0, pep.lastIndexOf(124));
            spec.setAnnotation(new Peptide(pepSeq, AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys()));
            spec.outputMgf(mgfOut);
        }
        mgfOut.flush();
        mgfOut.close();
    }

    public static void extractGoodSpectraFromSum(String enzyme, String cidOutFileName, String etdOutFileName) throws Exception {
        String[] token;
        File dir = new File(System.getProperty("user.home") + "/Research/Data/HeckWhole");
        File resDir = new File(dir.getPath() + "/Results0209");
        File specDir = new File(dir.getPath() + "/Spectra");
        Hashtable<String, SpectrumAccessorBySpecIndex> specTable = new Hashtable<String, SpectrumAccessorBySpecIndex>();
        for (File f : specDir.listFiles()) {
            if (f.getName().endsWith("mzXML")) {
                specTable.put(f.getName(), new MzXMLSpectraMap(f.getPath()));
                continue;
            }
            if (!f.getName().endsWith("mgf")) continue;
            specTable.put(f.getName(), new SpectraMap(f.getPath(), new MgfSpectrumParser()));
        }
        Hashtable<String, Float> pepScoreTable = new Hashtable<String, Float>();
        Hashtable<String, String> pepSpecTable = new Hashtable<String, String>();
        for (File f : resDir.listFiles()) {
            String s;
            if (!f.getName().contains("Sum") || !f.getName().contains(enzyme) || !f.getName().endsWith("_Target.txt")) continue;
            BufferedLineReader in = new BufferedLineReader(f.getPath());
            String prevScanNum = "";
            while ((s = in.readLine()) != null) {
                String scanNum;
                int charge;
                if (s.startsWith("#")) continue;
                token = s.split("\t");
                if (token.length != 10) assert (false);
                if (!token[2].equalsIgnoreCase("CID/ETD") || (charge = Integer.parseInt(token[4])) != 2 && charge != 3 || (scanNum = token[1]).equalsIgnoreCase(prevScanNum)) continue;
                prevScanNum = scanNum;
                float specProb = Float.parseFloat(token[9]);
                if (specProb >= msgfThresholds.get("Sum" + enzyme)[charge - 2].floatValue()) continue;
                String peptide = token[5];
                Float prevBestScore = (Float)pepScoreTable.get((peptide = peptide.substring(peptide.indexOf(46) + 1, peptide.lastIndexOf(46))) + "|" + token[4]);
                if (prevBestScore != null && !(specProb < prevBestScore.floatValue())) continue;
                pepScoreTable.put(peptide + "|" + token[4], Float.valueOf(specProb));
                pepSpecTable.put(peptide + "|" + token[4], token[0] + ":" + token[1] + ":" + token[7] + ":" + token[8]);
            }
        }
        PrintStream cidOut = new PrintStream(new BufferedOutputStream(new FileOutputStream(cidOutFileName)));
        PrintStream etdOut = new PrintStream(new BufferedOutputStream(new FileOutputStream(etdOutFileName)));
        ArrayList pepSet = new ArrayList(pepSpecTable.keySet());
        boolean num = false;
        for (String pep : pepSet) {
            String specInfo = (String)pepSpecTable.get(pep);
            token = specInfo.split(":");
            assert (token.length == 4) : specInfo;
            String fileName = token[0];
            int scanNumCID = Integer.parseInt(token[1].substring(0, token[1].indexOf(45)));
            int scanNumETD = scanNumCID + 1;
            int msgfScore = Integer.parseInt(token[2]);
            int peptideScore = (int)Float.parseFloat(token[3]);
            SpectrumAccessorBySpecIndex map = (SpectrumAccessorBySpecIndex)specTable.get(fileName);
            assert (map != null);
            Spectrum specCID = map.getSpectrumBySpecIndex(scanNumCID);
            Spectrum specETD = map.getSpectrumBySpecIndex(scanNumETD);
            assert (specCID != null && specETD != null);
            Float specProb = (Float)pepScoreTable.get(pep);
            assert (specProb != null);
            specCID.setTitle(fileName + ":CID:" + scanNumCID + ":" + specProb + ":" + msgfScore + ":" + peptideScore);
            specETD.setTitle(fileName + ":ETD:" + scanNumETD + ":" + specProb + ":" + msgfScore + ":" + peptideScore);
            String pepSeq = pep.substring(0, pep.lastIndexOf(124));
            Peptide annotation = new Peptide(pepSeq, AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys());
            specCID.setAnnotation(annotation);
            specETD.setAnnotation(annotation);
            specCID.outputMgf(cidOut);
            specETD.outputMgf(etdOut);
        }
        cidOut.flush();
        cidOut.close();
        etdOut.flush();
        etdOut.close();
        System.out.println("Done: " + enzyme + " " + cidOutFileName + " " + etdOutFileName);
    }

    static {
        Float[] mascotThresholdCIDTryp = new Float[]{Float.valueOf(37.09f), Float.valueOf(23.37f), Float.valueOf(24.18f)};
        Float[] mascotThresholdETDTryp = new Float[]{Float.valueOf(46.69f), Float.valueOf(75.14f), Float.valueOf(44.2f)};
        Float[] mascotThresholdCIDLysN = new Float[]{Float.valueOf(33.93f), Float.valueOf(22.35f), Float.valueOf(23.01f)};
        Float[] mascotThresholdETDLysN = new Float[]{Float.valueOf(35.8f), Float.valueOf(30.68f), Float.valueOf(22.71f)};
        mascotThresholds = new Hashtable();
        mascotThresholds.put("CIDTryp", mascotThresholdCIDTryp);
        mascotThresholds.put("ETDTryp", mascotThresholdETDTryp);
        mascotThresholds.put("CIDLysN", mascotThresholdCIDLysN);
        mascotThresholds.put("ETDLysN", mascotThresholdETDLysN);
        Float[] thresholdCIDTryp = new Float[]{Float.valueOf(1.216313E-10f), Float.valueOf(8.098124E-11f), Float.valueOf(2.1928117E-11f)};
        Float[] thresholdETDTryp = new Float[]{Float.valueOf(8.2302345E-11f), Float.valueOf(1.6922793E-12f), Float.valueOf(3.0688185E-13f)};
        Float[] thresholdSumTryp = new Float[]{Float.valueOf(1.2440679E-10f), Float.valueOf(4.8907045E-11f), Float.valueOf(1.927252E-11f)};
        Float[] thresholdCIDLysN = new Float[]{Float.valueOf(8.042938E-11f), Float.valueOf(4.9014993E-11f), Float.valueOf(9.152313E-13f)};
        Float[] thresholdETDLysN = new Float[]{Float.valueOf(5.6160354E-11f), Float.valueOf(4.0307476E-11f), Float.valueOf(1.5572712E-11f)};
        Float[] thresholdSumLysN = new Float[]{Float.valueOf(6.9574575E-11f), Float.valueOf(5.872495E-11f), Float.valueOf(1.467543E-11f)};
        msgfThresholds = new Hashtable();
        msgfThresholds.put("CIDTryp", thresholdCIDTryp);
        msgfThresholds.put("ETDTryp", thresholdETDTryp);
        msgfThresholds.put("SumTryp", thresholdSumTryp);
        msgfThresholds.put("CIDLysN", thresholdCIDLysN);
        msgfThresholds.put("ETDLysN", thresholdETDLysN);
        msgfThresholds.put("SumLysN", thresholdSumLysN);
    }
}

