/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.misc;

import edu.ucsd.msjava.msutil.SpectraIterator;
import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.parser.BufferedLineReader;
import edu.ucsd.msjava.parser.MgfSpectrumParser;
import edu.ucsd.msjava.parser.MzXMLSpectraIterator;
import edu.ucsd.msjava.parser.SpectrumParser;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;

public class IPRGStudy {
    public static void main(String[] argv) throws Exception {
        IPRGStudy.mergeHeckAndiPRGSpectra();
    }

    public static void mergeHeckAndiPRGSpectra() throws Exception {
        Spectrum spec;
        String heckSpecName = System.getProperty("user.home") + "/Research/Data/HeckRevision/AnnotatedSpectra/ETD_Tryp_Confident.mgf";
        String iprgSpecName = System.getProperty("user.home") + "/Research/Data/ABRF/2011/allFrxns/annotatedABRFETD.mgf";
        String outputFileName = System.getProperty("user.home") + "/Research/Data/ABRF/2011/allFrxns/annotatedABRFETDWithHeckCharge2.mgf";
        PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(outputFileName)));
        SpectraIterator itr = new SpectraIterator(heckSpecName, (SpectrumParser)new MgfSpectrumParser());
        while (itr.hasNext()) {
            spec = itr.next();
            String pepStr = spec.getAnnotationStr();
            if (!pepStr.endsWith("K")) continue;
            spec.outputMgf(out);
        }
        itr = new SpectraIterator(iprgSpecName, (SpectrumParser)new MgfSpectrumParser());
        while (itr.hasNext()) {
            spec = itr.next();
            spec.outputMgf(out);
        }
        out.flush();
        out.close();
        System.out.println("Done");
    }

    public static void convertIntoIPRGReport() throws Exception {
        HashMap<Character, String> ptmMap = new HashMap<Character, String>();
        ptmMap.put(Character.valueOf('m'), "Oxidation");
        ptmMap.put(Character.valueOf('k'), "Acetylation");
        IPRGStudy.convertIntoIPRGReport("/home/sangtaekim/Research/Data/ABRF/StudyFiles/MSGFDB_1209_30ppm_OxAcetyl.txt", ptmMap, "/home/sangtaekim/Research/Data/ABRF/StudyFiles/FinalReport_OxAcetyl.txt", false);
    }

    public static void convertIntoIPRGReport(String msgfOutput, HashMap<Character, String> ptmMap, String iPRGOutput, boolean nTerm) throws Exception {
        String s;
        PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(iPRGOutput)));
        BufferedLineReader in = new BufferedLineReader(msgfOutput);
        in.readLine();
        out.println("Scan number\tPrecursor m/z\tMass error (ppm)\tPrecursor charge\tPeptide Sequence\tModifications\tProtein Accession(s)\tSpectral Probability\tBetter than 1% FDR threshod?");
        while ((s = in.readLine()) != null) {
            String[] token = s.split("\t");
            if (token.length < 11) continue;
            int scanNum = Integer.parseInt(token[1]);
            float precursorMz = Float.parseFloat(token[3]);
            int charge = Integer.parseInt(token[5]);
            float precursorError = Float.parseFloat(token[4]) / (float)charge;
            String annotation = token[6];
            String pepStr = annotation.substring(annotation.indexOf(46) + 1, annotation.lastIndexOf(46));
            StringBuffer modifications = new StringBuffer();
            boolean isPTMOK = true;
            for (int i = 0; i < pepStr.length(); ++i) {
                char residue = pepStr.charAt(i);
                if (!Character.isLowerCase(residue)) continue;
                if (nTerm && residue != 'm' && i != 0) {
                    isPTMOK = false;
                    break;
                }
                String ptm = ptmMap.get(Character.valueOf(residue));
                modifications.append(i + 1 + "," + Character.toUpperCase(residue) + "," + ptm + ";");
            }
            if (!isPTMOK) continue;
            String prot = token[7];
            float specProb = Float.parseFloat(token[10]);
            out.println(scanNum + "\t" + precursorMz + "\t" + precursorError + "\t" + charge + "\t" + pepStr + "\t" + modifications.toString() + "\t" + prot + "\t" + specProb);
        }
        in.close();
        out.close();
        System.out.println("Done");
    }

    public static void generateIPRGReport() throws Exception {
        String mergedResults = System.getProperty("user.home") + "/Research/Data/ABRF/StudyFiles/FinalReport_Merged.txt";
        File temp1 = File.createTempFile("temp", "merge");
        temp1.deleteOnExit();
        IPRGStudy.mergeSearchResults(System.getProperty("user.home") + "/Research/Data/ABRF/StudyFiles/FinalReport_Nomod.txt", System.getProperty("user.home") + "/Research/Data/ABRF/StudyFiles/FinalReport_OxDeamd.txt", temp1.getPath());
        File temp2 = File.createTempFile("temp", "merge");
        temp2.deleteOnExit();
        IPRGStudy.mergeSearchResults(temp1.getPath(), System.getProperty("user.home") + "/Research/Data/ABRF/StudyFiles/FinalReport_OxPyroglu.txt", temp2.getPath());
        IPRGStudy.mergeSearchResults(temp2.getPath(), System.getProperty("user.home") + "/Research/Data/ABRF/StudyFiles/FinalReport_OxAcetyl.txt", mergedResults);
    }

    public static void mergeSearchResults(String targetResults, String decoyResults, String mergedResults) throws Exception {
        String title;
        String[] token;
        String s;
        int specProbColumn = 7;
        int keyColumn = 0;
        PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(mergedResults)));
        HashMap<String, String> targetMap = new HashMap<String, String>();
        BufferedLineReader in = new BufferedLineReader(targetResults);
        in.readLine();
        while ((s = in.readLine()) != null) {
            token = s.split("\t");
            if (token.length < keyColumn || token.length < specProbColumn) continue;
            title = token[keyColumn];
            targetMap.put(title, s);
        }
        in.close();
        in = new BufferedLineReader(decoyResults);
        out.println(in.readLine());
        while ((s = in.readLine()) != null) {
            float decoySpecProb;
            token = s.split("\t");
            if (token.length < keyColumn || token.length < specProbColumn) continue;
            title = token[keyColumn];
            String targetResult = (String)targetMap.get(title);
            if (targetResult == null) {
                out.println(s);
                continue;
            }
            float targetSpecProb = Float.parseFloat(targetResult.split("\t")[specProbColumn]);
            if (targetSpecProb <= (decoySpecProb = Float.parseFloat(token[specProbColumn]))) {
                out.println(targetResult);
                continue;
            }
            if (!(targetSpecProb > decoySpecProb)) continue;
            out.println(s);
        }
        in.close();
        out.close();
        System.out.println("Done");
    }

    public static void enzymeCleavageTest() throws Exception {
        String s;
        String fileName = System.getProperty("user.home") + "/Research/Data/ABRF/StudyFiles/MSGFDB_1209_30ppm_Merged_FDR01.txt";
        BufferedLineReader in = new BufferedLineReader(fileName);
        in.readLine();
        int[] numSpecs = new int[100];
        int[] numSpecsPreceedingK = new int[100];
        int[] numSpecsEndingK = new int[100];
        int numAllSpecs = 0;
        int numAllSpecsPreceedingK = 0;
        int numAllSpecsEndingK = 0;
        while ((s = in.readLine()) != null) {
            int charge;
            String[] token = s.split("\t");
            String annotationStr = token[6];
            int n = charge = Integer.parseInt(token[5]);
            numSpecs[n] = numSpecs[n] + 1;
            ++numAllSpecs;
            if (annotationStr.charAt(0) == 'K') {
                int n2 = charge;
                numSpecsPreceedingK[n2] = numSpecsPreceedingK[n2] + 1;
                ++numAllSpecsPreceedingK;
            }
            if (annotationStr.charAt(annotationStr.lastIndexOf(46) - 1) != 'K') continue;
            int n3 = charge;
            numSpecsEndingK[n3] = numSpecsEndingK[n3] + 1;
            ++numAllSpecsEndingK;
        }
        for (int c = 2; c <= 10; ++c) {
            System.out.println(c + "\t" + numSpecs[c] + "\t" + (float)numSpecsPreceedingK[c] / (float)numSpecs[c] + "\t" + (float)numSpecsEndingK[c] / (float)numSpecs[c]);
        }
        System.out.println("All\t" + numAllSpecs + "\t" + (float)numAllSpecsPreceedingK / (float)numAllSpecs + "\t" + (float)numAllSpecsEndingK / (float)numAllSpecs);
    }

    public static void count() throws Exception {
        String[] token;
        String s;
        String fileName1 = System.getProperty("user.home") + "/Research/Data/ABRF/StudyFiles/ModOnly.txt";
        String fileName2 = System.getProperty("user.home") + "/Research/Data/ABRF/StudyFiles/NomodOnly.txt";
        HashSet<String> scanNumSet = new HashSet<String>();
        BufferedLineReader in = new BufferedLineReader(fileName1);
        in.readLine();
        while ((s = in.readLine()) != null) {
            token = s.split("\t");
            scanNumSet.add(token[1]);
        }
        in = new BufferedLineReader(fileName2);
        in.readLine();
        while ((s = in.readLine()) != null) {
            token = s.split("\t");
            scanNumSet.add(token[1]);
        }
        System.out.println(scanNumSet.size());
    }

    public static void extractModResults() throws Exception {
        String s;
        String fileName = System.getProperty("user.home") + "/Research/Data/ABRF/StudyFiles/MSGFDB_1207_30ppm_Mod.txt";
        BufferedLineReader in = new BufferedLineReader(fileName);
        System.out.println(in.readLine());
        while ((s = in.readLine()) != null) {
            String pepStr;
            String[] token = s.split("\t");
            if (token.length < 6 || (pepStr = token[6].substring(token[6].indexOf(46) + 1, token[6].lastIndexOf(46))).toUpperCase().equals(pepStr)) continue;
            System.out.println(s);
        }
        in.close();
    }

    public static void areAllSpectraProcessed() throws Exception {
        String s;
        String fileName = "/home/sangtaekim/Research/Data/ABRF/StudyFiles/MSGFDB_1101_PMErr_20ppm_Deamd.txt";
        fileName = "/home/sangtaekim/Developments/MS_Java/bin/msgfdb_highPMtol_reversed.raw.1.txt";
        String specFileName = "/home/sangtaekim/Research/Data/ABRF/StudyFiles/D100930_yeast_SCX10S_rak_ft8E_pc_01.mzXML";
        specFileName = "/home/sangtaekim/Research/ToolDistribution/MSGFDBTest/ABRF_Ab_HC_DTT_NIPIA_ArgC_37C_On_102909.mzXML";
        BufferedLineReader in = new BufferedLineReader(fileName);
        in.readLine();
        HashSet<Integer> scanNumSet = new HashSet<Integer>();
        while ((s = in.readLine()) != null) {
            String[] token = s.split("\t");
            int scanNum = Integer.parseInt(token[1]);
            scanNumSet.add(scanNum);
        }
        System.out.println("NumProcessedSpecs\t" + scanNumSet.size());
        MzXMLSpectraIterator itr = new MzXMLSpectraIterator(specFileName);
        while (itr.hasNext()) {
            Spectrum spec = itr.next();
            int scanNum = spec.getScanNum();
            if (scanNumSet.contains(scanNum)) continue;
            System.out.println("Missing\t" + scanNum);
        }
    }
}

