/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.misc;

import edu.ucsd.msjava.msutil.DBFileFormat;
import edu.ucsd.msjava.params.FileParameter;
import edu.ucsd.msjava.params.IntParameter;
import edu.ucsd.msjava.params.ParamManager;
import edu.ucsd.msjava.parser.BufferedLineReader;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class MakePrefixDB {
    public static final int VERSION = 7711;
    public static final String DATE = "05/03/2012";

    public static void main(String[] argv) throws Exception {
        ParamManager paramManager = new ParamManager("MakePrefixDB", String.valueOf(7711), DATE, "java -Xmx2000M -cp MSGFDB.jar misc.MakePrefixDB");
        FileParameter inputDBParam = new FileParameter("i", "DatabaseFile", "Input fasta file (*.fa, *.fasta)");
        inputDBParam.addFileFormat(DBFileFormat.FASTA);
        inputDBParam.fileMustExist();
        inputDBParam.mustBeAFile();
        paramManager.addParameter(inputDBParam);
        FileParameter outputDBParam = new FileParameter("o", "DatabaseFile", "Input fasta file (*.fa, *.fasta)");
        outputDBParam.addFileFormat(DBFileFormat.FASTA);
        outputDBParam.fileMustNotExist();
        paramManager.addParameter(outputDBParam);
        IntParameter prefixLengthParam = new IntParameter("l", "PrefixLength", "Prefix length, Default: 30");
        prefixLengthParam.minValue(1);
        prefixLengthParam.defaultValue(30);
        paramManager.addParameter(prefixLengthParam);
        if (argv.length == 0) {
            paramManager.printUsageInfo();
            return;
        }
        String errMessage = paramManager.parseParams(argv);
        if (errMessage != null) {
            System.err.println("[Error] " + errMessage);
            System.out.println();
            paramManager.printUsageInfo();
            return;
        }
        long time = System.currentTimeMillis();
        paramManager.printToolInfo();
        String errorMessage = MakePrefixDB.convert(paramManager);
        if (errorMessage != null) {
            System.err.println("[Error] " + errorMessage);
            System.out.println();
        } else {
            System.out.format("MakePrefixDB complete (total elapsed time: %.2f sec)\n", Float.valueOf((float)(System.currentTimeMillis() - time) / 1000.0f));
        }
    }

    public static String convert(ParamManager paramManager) throws Exception {
        String s;
        File inputDBFile = paramManager.getFile("i");
        File outputDBFile = paramManager.getFile("o");
        int prefixLength = paramManager.getIntValue("l");
        BufferedLineReader in = new BufferedLineReader(inputDBFile.getPath());
        PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(outputDBFile)));
        int remaining = 0;
        while ((s = in.readLine()) != null) {
            if (s.startsWith(">")) {
                out.println(s);
                remaining = prefixLength;
                continue;
            }
            if (remaining <= 0) continue;
            if (s.length() >= remaining) {
                out.println(s.substring(0, remaining));
                remaining = 0;
                continue;
            }
            out.println(s);
            remaining -= s.length();
        }
        in.close();
        out.close();
        return null;
    }
}

