/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.misc;

import edu.ucsd.msjava.parser.BufferedLineReader;
import java.util.HashMap;

public class MergeTargetDecoyFiles {
    public static void main(String[] argv) throws Exception {
        boolean isMascot = false;
        if (argv.length != 2 && argv.length != 3) {
            MergeTargetDecoyFiles.printUsageAndExit();
        }
        if (argv.length == 3 && argv[2].equals("1")) {
            isMascot = true;
        }
        if (!isMascot) {
            MergeTargetDecoyFiles.mergeSearchResults(argv[0], argv[1]);
        } else {
            MergeTargetDecoyFiles.mergeMascotSearchResults(argv[0], argv[1]);
        }
    }

    public static void printUsageAndExit() {
        System.out.println("usage: java MergeTargetDecoyFiles targetFile decoyFile [0/1] (0: MSGFDB, 1: Mascot)");
        System.exit(-1);
    }

    public static void mergeSearchResults(String targetResults, String decoyResults) throws Exception {
        String s;
        HashMap<String, String> targetMap = new HashMap<String, String>();
        BufferedLineReader in = new BufferedLineReader(targetResults);
        int specProbCol = -1;
        int specFileCol = -1;
        int specIndexCol = -1;
        String headerStr = in.readLine();
        String[] header = headerStr.split("\t");
        for (int i = 0; i < header.length; ++i) {
            if (header[i].equalsIgnoreCase("SpecProb")) {
                specProbCol = i;
                continue;
            }
            if (header[i].contains("SpecFile") || header[i].contains("SpectrumFile")) {
                specFileCol = i;
                continue;
            }
            if (!header[i].contains("SpecIndex")) continue;
            specIndexCol = i;
        }
        while ((s = in.readLine()) != null) {
            String key;
            String[] token = s.split("\t");
            if (token.length < specFileCol || token.length < specProbCol || token.length < specIndexCol || targetMap.get(key = token[specFileCol] + ":" + token[specIndexCol]) != null) continue;
            targetMap.put(key, s);
        }
        in.close();
        in = new BufferedLineReader(decoyResults);
        System.out.println(in.readLine());
        int prevScanNum = -1;
        while ((s = in.readLine()) != null) {
            float decoySpecProb;
            int scanNum;
            String[] token = s.split("\t");
            if (token.length < specFileCol || token.length < specProbCol || token.length < specIndexCol || (scanNum = Integer.parseInt(token[specIndexCol])) == prevScanNum) continue;
            prevScanNum = scanNum;
            String key = token[specFileCol] + ":" + token[specIndexCol];
            String targetResult = (String)targetMap.get(key);
            String decoyResult = s;
            if (targetResult == null) {
                System.out.println(decoyResult);
                continue;
            }
            float targetSpecProb = Float.parseFloat(targetResult.split("\t")[specProbCol]);
            if (targetSpecProb <= (decoySpecProb = Float.parseFloat(token[specProbCol]))) {
                System.out.println(targetResult);
                continue;
            }
            if (!(targetSpecProb > decoySpecProb)) continue;
            System.out.println(decoyResult);
        }
        in.close();
    }

    public static void mergeMascotSearchResults(String targetResults, String decoyResults) throws Exception {
        String title;
        String s;
        HashMap<String, String> resultMap = new HashMap<String, String>();
        BufferedLineReader in = new BufferedLineReader(targetResults);
        int scoreCol = -1;
        int titleCol = -1;
        String headerStr = in.readLine();
        String[] header = headerStr.split("\t");
        for (int i = 0; i < header.length; ++i) {
            if (header[i].equalsIgnoreCase("MascotScore")) {
                scoreCol = i;
                continue;
            }
            if (!header[i].contains("Title")) continue;
            titleCol = i;
        }
        while ((s = in.readLine()) != null) {
            String[] token = s.split("\t");
            if (token.length < titleCol || token.length < scoreCol || resultMap.get(title = token[titleCol]) != null) continue;
            resultMap.put(title, s);
        }
        in.close();
        in = new BufferedLineReader(decoyResults);
        System.out.println(in.readLine());
        while ((s = in.readLine()) != null) {
            String[] token = s.split("\t");
            if (token.length < titleCol || token.length < scoreCol) continue;
            title = token[titleCol];
            String prevResult = (String)resultMap.get(title);
            if (prevResult == null) {
                resultMap.put(title, s);
                continue;
            }
            float prevScore = Float.parseFloat(prevResult.split("\t")[scoreCol]);
            float curScore = Float.parseFloat(token[scoreCol]);
            if (!(curScore > prevScore)) continue;
            resultMap.put(title, s);
        }
        for (String result : resultMap.values()) {
            System.out.println(result);
        }
        in.close();
    }
}

