/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.misc;

import edu.ucsd.msjava.misc.FileFilter;
import edu.ucsd.msjava.msutil.ActivationMethod;
import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.parser.MzXMLSpectraIterator;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class MzXMLToMgf {
    public static void main(String[] argv) {
        String ext;
        File mzXMLFile = null;
        File mgfFile = null;
        ActivationMethod activationMethod = null;
        if (argv.length != 2 && argv.length != 3) {
            MzXMLToMgf.printUsageAndExit("Invalid parameters");
        }
        if (!(mzXMLFile = new File(argv[0])).exists()) {
            MzXMLToMgf.printUsageAndExit(argv[0] + " doesn't exist!");
        }
        if (!(mzXMLFile.isDirectory() || (ext = mzXMLFile.getName().substring(mzXMLFile.getName().lastIndexOf(46) + 1)).equalsIgnoreCase("mzxml") || ext.equalsIgnoreCase("mzml"))) {
            MzXMLToMgf.printUsageAndExit(argv[0] + " must be *.mzXML!");
        }
        if (!(ext = (mgfFile = new File(argv[1])).getName().substring(mgfFile.getName().lastIndexOf(46) + 1)).equalsIgnoreCase("mgf")) {
            MzXMLToMgf.printUsageAndExit(argv[1] + " must be *.mgf!");
        }
        if (argv.length == 3 && (activationMethod = ActivationMethod.get(argv[2])) == null) {
            MzXMLToMgf.printUsageAndExit("Cannot recognize activaion method " + argv[2]);
        }
        MzXMLToMgf.convert(mzXMLFile, mgfFile, activationMethod);
    }

    public static void printUsageAndExit(String message) {
        System.err.println(message);
        System.out.println("usage: MzXMLToMgf mzXML(*.mzXML or directory) mgfFile(*.mgf) [activationMethod]");
        System.exit(-1);
    }

    public static void convert(File mzXMLFile, File mgfFile, ActivationMethod activationMethod) {
        PrintStream out = null;
        try {
            out = new PrintStream(new BufferedOutputStream(new FileOutputStream(mgfFile)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        File[] mzXMLFileList = mzXMLFile.isDirectory() ? mzXMLFile.listFiles(new FileFilter.FileExtFilter("mzXML")) : new File[]{mzXMLFile};
        int numSpecs = 0;
        for (File f : mzXMLFileList) {
            MzXMLSpectraIterator itr = new MzXMLSpectraIterator(f.getPath());
            while (itr.hasNext()) {
                Spectrum spec = itr.next();
                spec.setTitle(f.getName() + ":" + spec.getScanNum());
                if (spec.getActivationMethod() != null && activationMethod != null && spec.getActivationMethod() != activationMethod) continue;
                if (numSpecs > 0) {
                    out.println();
                }
                spec.outputMgf(out);
                ++numSpecs;
            }
        }
        if (out != null) {
            out.close();
        }
        System.out.println(numSpecs + " converted.");
    }
}

