/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.misc;

import edu.ucsd.msjava.msgf.Histogram;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Peptide;
import edu.ucsd.msjava.msutil.SpectraMap;
import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.msutil.SpectrumAccessorBySpecIndex;
import edu.ucsd.msjava.parser.BufferedLineReader;
import edu.ucsd.msjava.parser.InsPecTPSM;
import edu.ucsd.msjava.parser.InsPecTParser;
import edu.ucsd.msjava.parser.MgfSpectrumParser;
import edu.ucsd.msjava.parser.MzXMLSpectraMap;
import edu.ucsd.msjava.parser.PSMList;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashMap;

public class PhosAnalysis {
    public static void main(String[] argv) throws Exception {
        PhosAnalysis.compareMSGFDBAndInsPecT();
    }

    public static void compareMSGFDBAndInsPecT() throws Exception {
        String inspectResultFile = "/home/sangtaekim/Test/JunePhospho/Inspect/finalResult/dee75f91bf354b62aed3fc3436645826";
        String msgfdbResultFile = "/home/sangtaekim/Test/JunePhospho/MSGFDB/finalResult/5ab63ac652d840f58ab9e598cf796975";
        PhosAnalysis.countIDByNumPhospho(inspectResultFile);
        PhosAnalysis.countIDByNumPhospho(msgfdbResultFile);
    }

    public static void countIDByNumPhospho(String fileName) throws Exception {
        String s;
        System.out.println(fileName);
        int idCol = -1;
        BufferedLineReader in = new BufferedLineReader(fileName);
        String header = in.readLine();
        String[] field = header.split("\t");
        Histogram<Integer> hist = new Histogram<Integer>();
        for (int i = 0; i < field.length; ++i) {
            if (!field[i].equals("Peptide") && !field[i].equals("Annotation")) continue;
            idCol = i;
        }
        int numID = 0;
        while ((s = in.readLine()) != null) {
            String annotation;
            String[] token = s.split("\t");
            if (token.length <= idCol || !(annotation = token[idCol]).contains("phos") && !annotation.contains("79.9")) continue;
            int numPhospho = 0;
            for (int i = 0; i < annotation.length(); ++i) {
                String substr = annotation.substring(i);
                if (!substr.startsWith("phos") && !substr.startsWith("+79.966")) continue;
                ++numPhospho;
            }
            hist.add(numPhospho);
            if (numPhospho <= 0) continue;
            ++numID;
        }
        System.out.println("NumID: " + numID);
        hist.printSorted();
    }

    public static void countIDByMSLevel(String fileName) throws Exception {
        String s;
        System.out.println(fileName);
        File specDir = new File("/home/sangtaekim/Test/JunePhospho/Inspect/spectrum");
        int specFileCol = -1;
        int specIndexCol = -1;
        int idCol = -1;
        BufferedLineReader in = new BufferedLineReader(fileName);
        String header = in.readLine();
        String[] field = header.split("\t");
        Histogram<String> hist = new Histogram<String>();
        for (int i = 0; i < field.length; ++i) {
            if (field[i].equals("#SpecFile") || field[i].equals("#SpectrumFile")) {
                specFileCol = i;
                continue;
            }
            if (field[i].equals("SpecIndex") || field[i].equals("Scan#")) {
                specIndexCol = i;
                continue;
            }
            if (!field[i].equals("Peptide") && !field[i].equals("Annotation")) continue;
            idCol = i;
        }
        HashMap<String, SpectrumAccessorBySpecIndex> specAccessorMap = new HashMap<String, SpectrumAccessorBySpecIndex>();
        int numID = 0;
        while ((s = in.readLine()) != null) {
            String[] token = s.split("\t");
            if (token.length <= specFileCol || token.length <= specIndexCol || token.length <= idCol) continue;
            String specFileName = token[specFileCol];
            specFileName = new File(specFileName).getName();
            int specIndex = Integer.parseInt(token[specIndexCol]);
            String annotation = token[idCol];
            if (!annotation.contains("phos") && !annotation.contains("79.9")) continue;
            SpectrumAccessorBySpecIndex specMap = (SpectrumAccessorBySpecIndex)specAccessorMap.get(specFileName);
            if (specMap == null) {
                String ext = specFileName.substring(specFileName.lastIndexOf(46));
                if (ext.equalsIgnoreCase(".mzXML")) {
                    specMap = new MzXMLSpectraMap(specDir.getPath() + File.separator + specFileName);
                } else if (ext.equalsIgnoreCase(".mgf")) {
                    specMap = new SpectraMap(specDir.getPath() + File.separator + specFileName, new MgfSpectrumParser());
                } else {
                    System.out.println("Unrecognized spectrum format: " + specFileName);
                    System.exit(-1);
                }
                specAccessorMap.put(specFileName, specMap);
            }
            Spectrum spec = specMap.getSpectrumBySpecIndex(specIndex);
            hist.add(specFileName);
            ++numID;
        }
        System.out.println("NumID: " + numID);
        hist.printSorted();
    }

    public static void makeAnnotatedMgf() throws Exception {
        File dir = new File(System.getProperty("user.home") + "/Research/Data/Phospho");
        File resultDir = new File(dir.getPath() + "/inspect");
        File specRootDir = new File(dir.getPath() + "/spectra");
        File annotatedSpectra = new File(dir.getPath() + "/annotatedPhospho.mgf");
        PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(annotatedSpectra)));
        AminoAcidSet baseAASet = AminoAcidSet.getStandardAminoAcidSetWithFixedCarboxymethylatedCys();
        int numSpec = 0;
        for (File f : resultDir.listFiles()) {
            if (!f.getName().endsWith(".txt")) continue;
            System.out.println(f.getName());
            InsPecTParser parser = new InsPecTParser(baseAASet);
            parser.parse(f.getPath());
            PSMList<InsPecTPSM> psmList = parser.getPSMList();
            if (psmList == null || psmList.size() == 0) continue;
            InsPecTPSM firstPSM = (InsPecTPSM)psmList.get(0);
            String specFileName = firstPSM.getSpecFileName();
            String specSubDirName = specFileName.substring(0, specFileName.lastIndexOf(45));
            File specDir = new File(specRootDir.getPath() + "/" + specSubDirName);
            assert (specDir.exists() && specDir.isDirectory()) : specDir.getName() + " is missing or not a directory!";
            File specFile = new File(specDir.getPath() + "/" + specFileName);
            assert (specFile.exists()) : specFile.getName() + " does not exist!";
            MzXMLSpectraMap map = new MzXMLSpectraMap(specFile.getPath());
            for (InsPecTPSM psm : psmList) {
                String pepString;
                Peptide pep;
                if (psm.getProbScore() > 0.01f || !(pep = psm.getPeptide()).isModified() || !(pepString = pep.toString()).contains("s") && !pepString.contains("t")) continue;
                Spectrum spec = map.getSpectrumBySpecIndex(psm.getScanNum());
                spec.setCharge(psm.getCharge());
                float expPM = spec.getPrecursorMass();
                float theoPM = pep.getParentMass();
                float massDiff = expPM - theoPM;
                if (Math.abs(massDiff) > 5.0f) {
                    System.out.println("Error! mass mismatch: " + psm.getSpecFileName() + "\t" + psm.getScanNum() + "\t" + pep + "\t" + expPM + "!=" + theoPM);
                    spec.setCharge(psm.getCharge());
                    continue;
                }
                ++numSpec;
                spec.setAnnotation(pep);
                spec.outputMgf(out);
            }
        }
        out.close();
    }
}

