/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msdbsearch;

import edu.ucsd.msjava.msdbsearch.CompactSuffixArray;
import edu.ucsd.msjava.msdbsearch.DBScanner;
import edu.ucsd.msjava.msdbsearch.LibraryScanner;
import edu.ucsd.msjava.msdbsearch.ScoredSpectraMap;
import edu.ucsd.msjava.msgf.MSGFDBResultGenerator;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Enzyme;
import java.util.List;

public class ConcurrentMSGFDB {

    public static class RunMSGFDBLib
    implements Runnable {
        private final ScoredSpectraMap specScanner;
        private final LibraryScanner scanner;
        private final String specFileName;
        private final List<MSGFDBResultGenerator.DBMatch> gen;
        private final String libraryFileName;

        public RunMSGFDBLib(ScoredSpectraMap specScanner, int numPeptidesPerSpec, List<MSGFDBResultGenerator.DBMatch> gen, String specFileName, String libraryFileName) {
            this.specScanner = specScanner;
            this.scanner = new LibraryScanner(specScanner, numPeptidesPerSpec);
            this.specFileName = specFileName;
            this.gen = gen;
            this.libraryFileName = libraryFileName;
        }

        @Override
        public void run() {
            String threadName = Thread.currentThread().getName();
            long time = System.currentTimeMillis();
            if (this.specScanner.getPepMassSpecKeyMap().size() == 0) {
                this.specScanner.makePepMassSpecKeyMap();
            }
            System.out.println(threadName + ": Preprocessing spectra...");
            this.specScanner.preProcessSpectra();
            System.out.print(threadName + ": Preprocessing spectra finished ");
            System.out.format("(elapsed time: %.2f sec)\n", Float.valueOf((System.currentTimeMillis() - time) / 1000L));
            time = System.currentTimeMillis();
            System.out.println(threadName + ": Library search...");
            this.scanner.setThreadName(threadName);
            this.scanner.libSearch(this.libraryFileName, true);
            System.out.print(threadName + ": Library search finished ");
            System.out.format("(elapsed time: %.2f sec)\n", Float.valueOf((System.currentTimeMillis() - time) / 1000L));
            time = System.currentTimeMillis();
            System.out.println(threadName + ": Computing spectral probabilities...");
            this.scanner.computeSpecProb();
            System.out.print(threadName + ": Computing spectral probabilities finished ");
            System.out.format("(elapsed time: %.2f sec)\n", Float.valueOf((System.currentTimeMillis() - time) / 1000L));
            this.scanner.addLibSearchResults(this.gen, this.specFileName);
        }
    }

    public static class RunMSGFDB
    implements Runnable {
        private final ScoredSpectraMap specScanner;
        private final DBScanner scanner;
        private final int numberOfAllowableNonEnzymaticTermini;
        private final int searchMode;
        private final boolean storeScoreDist;
        private final String specFileName;
        private final List<MSGFDBResultGenerator.DBMatch> gen;
        private final boolean replicateMergedResults;

        public RunMSGFDB(ScoredSpectraMap specScanner, CompactSuffixArray sa, Enzyme enzyme, AminoAcidSet aaSet, int numPeptidesPerSpec, int minPeptideLength, int maxPeptideLength, int numberOfAllowableNonEnzymaticTermini, boolean storeScoreDist, List<MSGFDBResultGenerator.DBMatch> gen, String specFileName, boolean replicateMergedResults) {
            this.specScanner = specScanner;
            this.scanner = new DBScanner(specScanner, sa, enzyme, aaSet, numPeptidesPerSpec, minPeptideLength, maxPeptideLength, 128, 0, false, -1);
            this.numberOfAllowableNonEnzymaticTermini = numberOfAllowableNonEnzymaticTermini;
            this.storeScoreDist = storeScoreDist;
            this.specFileName = specFileName;
            this.gen = gen;
            this.replicateMergedResults = replicateMergedResults;
            int searchMode = 0;
            searchMode = enzyme == null || enzyme.getResidues() == null ? 1 : (enzyme.isCTerm() ? (!aaSet.containsModification() ? 2 : 0) : 3);
            this.searchMode = searchMode;
        }

        @Override
        public void run() {
            String threadName = Thread.currentThread().getName();
            long time = System.currentTimeMillis();
            if (this.specScanner.getPepMassSpecKeyMap().size() == 0) {
                this.specScanner.makePepMassSpecKeyMap();
            }
            System.out.println(threadName + ": Preprocessing spectra...");
            this.specScanner.preProcessSpectra();
            System.out.print(threadName + ": Preprocessing spectra finished ");
            System.out.format("(elapsed time: %.2f sec)\n", Float.valueOf((System.currentTimeMillis() - time) / 1000L));
            time = System.currentTimeMillis();
            System.out.println(threadName + ": Database search...");
            this.scanner.setThreadName(threadName);
            if (this.searchMode == 1) {
                this.scanner.dbSearchNoEnzyme(true);
            } else if (this.searchMode == 2) {
                this.scanner.dbSearchCTermEnzymeNoMod(this.numberOfAllowableNonEnzymaticTermini, true);
            } else if (this.searchMode == 3) {
                this.scanner.dbSearchNTermEnzyme(this.numberOfAllowableNonEnzymaticTermini, true);
            } else {
                this.scanner.dbSearchCTermEnzyme(this.numberOfAllowableNonEnzymaticTermini, true);
            }
            System.out.print(threadName + ": Database search finished ");
            System.out.format("(elapsed time: %.2f sec)\n", Float.valueOf((System.currentTimeMillis() - time) / 1000L));
            time = System.currentTimeMillis();
            System.out.println(threadName + ": Computing spectral probabilities...");
            this.scanner.computeSpecEValue(this.storeScoreDist);
            System.out.print(threadName + ": Computing spectral probabilities finished ");
            System.out.format("(elapsed time: %.2f sec)\n", Float.valueOf((System.currentTimeMillis() - time) / 1000L));
            this.scanner.addDBSearchResults(this.gen, this.specFileName, this.replicateMergedResults);
        }
    }

    public static class ComputeSpecProb
    implements Runnable {
        private final DBScanner scanner;
        private final int fromIndex;
        private final int toIndex;
        private final boolean storeScoreDist;

        public ComputeSpecProb(DBScanner scanner, boolean storeScoreDist, int fromIndex, int toIndex) {
            this.scanner = scanner;
            this.fromIndex = fromIndex;
            this.toIndex = toIndex;
            this.storeScoreDist = storeScoreDist;
        }

        @Override
        public void run() {
            this.scanner.computeSpecEValue(this.storeScoreDist, this.fromIndex, this.toIndex);
        }
    }

    public static class RunDBSearch
    implements Runnable {
        private final DBScanner scanner;
        private final int numberOfAllowableNonEnzymaticTermini;
        private final int fromIndex;
        private final int toIndex;
        private final int searchMode;

        public RunDBSearch(DBScanner scanner, int numberOfAllowableNonEnzymaticTermini, int searchMode, int fromIndex, int toIndex) {
            this.scanner = scanner;
            this.numberOfAllowableNonEnzymaticTermini = numberOfAllowableNonEnzymaticTermini;
            this.fromIndex = fromIndex;
            this.toIndex = toIndex;
            this.searchMode = searchMode;
        }

        @Override
        public void run() {
            if (this.searchMode == 1) {
                this.scanner.dbSearch(2, this.fromIndex, this.toIndex, true);
            } else if (this.searchMode == 2) {
                this.scanner.dbSearch(this.numberOfAllowableNonEnzymaticTermini, this.fromIndex, this.toIndex, true);
            } else if (this.searchMode == 3) {
                this.scanner.dbSearch(this.numberOfAllowableNonEnzymaticTermini, this.fromIndex, this.toIndex, true);
            } else {
                this.scanner.dbSearch(this.numberOfAllowableNonEnzymaticTermini, this.fromIndex, this.toIndex, true);
            }
        }
    }

    public static class PreProcessSpectra
    implements Runnable {
        private final ScoredSpectraMap specMap;
        private final int fromIndex;
        private final int toIndex;

        public PreProcessSpectra(ScoredSpectraMap specMap, int fromIndex, int toIndex) {
            this.specMap = specMap;
            this.fromIndex = fromIndex;
            this.toIndex = toIndex;
        }

        @Override
        public void run() {
            this.specMap.preProcessSpectra(this.fromIndex, this.toIndex);
        }
    }
}

