/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msdbsearch;

import edu.ucsd.msjava.misc.ProgressData;
import edu.ucsd.msjava.misc.ProgressReporter;
import edu.ucsd.msjava.msdbsearch.CompactSuffixArray;
import edu.ucsd.msjava.msdbsearch.DBScanner;
import edu.ucsd.msjava.msdbsearch.MSGFPlusMatch;
import edu.ucsd.msjava.msdbsearch.ScoredSpectraMap;
import edu.ucsd.msjava.msdbsearch.SearchParams;
import java.io.PrintStream;
import java.util.List;
import org.apache.commons.io.output.NullOutputStream;

public class ConcurrentMSGFPlus {

    public static class RunMSGFPlus
    implements Runnable,
    ProgressReporter {
        private final ScoredSpectraMap specScanner;
        private final DBScanner scanner;
        SearchParams params;
        List<MSGFPlusMatch> resultList;
        private final int taskNum;
        private ProgressData progress;

        @Override
        public void setProgressData(ProgressData data) {
            this.progress = data;
        }

        @Override
        public ProgressData getProgressData() {
            return this.progress;
        }

        public RunMSGFPlus(ScoredSpectraMap specScanner, CompactSuffixArray sa, SearchParams params, List<MSGFPlusMatch> resultList, int taskNum) {
            this.specScanner = specScanner;
            this.params = params;
            this.scanner = new DBScanner(specScanner, sa, params.getEnzyme(), params.getAASet(), params.getNumMatchesPerSpec(), params.getMinPeptideLength(), params.getMaxPeptideLength(), params.getMaxNumVariantsPerPeptide(), params.getMinDeNovoScore(), params.ignoreMetCleavage(), params.getMaxMissedCleavages());
            this.resultList = resultList;
            this.taskNum = taskNum;
            this.progress = null;
        }

        @Override
        public void run() {
            if (this.progress == null) {
                this.progress = new ProgressData();
            }
            PrintStream output = this.params.getVerbose() ? System.out : new PrintStream(new NullOutputStream());
            this.progress.stepRange(5.0);
            String threadName = Thread.currentThread().getName();
            output.println(threadName + ": Starting task " + this.taskNum);
            this.specScanner.setProgressObj(new ProgressData(this.progress));
            long startTimePreprocess = System.currentTimeMillis();
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (this.specScanner.getPepMassSpecKeyMap().size() == 0) {
                this.specScanner.makePepMassSpecKeyMap();
            }
            output.println(threadName + ": Preprocessing spectra...");
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            this.specScanner.preProcessSpectra();
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            output.print(threadName + ": Preprocessing spectra finished ");
            output.format("(elapsed time: %.2f sec)\n", Float.valueOf((System.currentTimeMillis() - startTimePreprocess) / 1000L));
            this.specScanner.getProgressObj().setParentProgressObj(null);
            this.progress.report(5.0);
            this.progress.stepRange(80.0);
            this.scanner.setProgressObj(new ProgressData(this.progress));
            long startTimeDbSearch = System.currentTimeMillis();
            output.println(threadName + ": Database search...");
            this.scanner.setThreadName(threadName);
            this.scanner.setPrintStream(output);
            int ntt = this.params.getNumTolerableTermini();
            if (this.params.getEnzyme() == null) {
                ntt = 0;
            }
            int nnet = 2 - ntt;
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            this.scanner.dbSearch(nnet);
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            output.print(threadName + ": Database search finished ");
            output.format("(elapsed time: %.2f sec)\n", Float.valueOf((System.currentTimeMillis() - startTimeDbSearch) / 1000L));
            this.progress.stepRange(95.0);
            long startTimeComputeEvalue = System.currentTimeMillis();
            output.println(threadName + ": Computing spectral E-values...");
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            this.scanner.computeSpecEValue(false);
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            output.print(threadName + ": Computing spectral E-values finished ");
            output.format("(elapsed time: %.2f sec)\n", Float.valueOf((System.currentTimeMillis() - startTimeComputeEvalue) / 1000L));
            this.scanner.getProgressObj().setParentProgressObj(null);
            this.progress.stepRange(100.0);
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            this.scanner.generateSpecIndexDBMatchMap();
            this.progress.report(30.0);
            if (this.params.outputAdditionalFeatures()) {
                this.scanner.addAdditionalFeatures();
            }
            this.progress.report(60.0);
            this.scanner.addResultsToList(this.resultList);
            this.progress.report(100.0);
            output.println(threadName + ": Task " + this.taskNum + " completed.");
        }
    }
}

