/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msdbsearch;

import edu.ucsd.msjava.msdbsearch.Match;
import edu.ucsd.msjava.msutil.ActivationMethod;
import java.util.SortedSet;
import java.util.TreeSet;

public class DatabaseMatch
extends Match {
    private int index;
    private byte length;
    private boolean isProteinNTerm;
    private boolean isProteinCTerm;
    private boolean isNTermMetCleaved = false;
    private Float psmQValue = null;
    private Float pepQValue = null;
    private SortedSet<Integer> indices;

    public DatabaseMatch(int index, byte length, int score, float peptideMass, int nominalPeptideMass, int charge, String pepSeq, ActivationMethod[] actMethodArr) {
        super(score, peptideMass, nominalPeptideMass, charge, pepSeq, actMethodArr);
        this.index = index;
        this.length = length;
        this.isProteinNTerm = false;
        this.isProteinCTerm = false;
    }

    public DatabaseMatch setProteinNTerm(boolean isProteinNTerm) {
        this.isProteinNTerm = isProteinNTerm;
        return this;
    }

    public DatabaseMatch setProteinCTerm(boolean isProteinCTerm) {
        this.isProteinCTerm = isProteinCTerm;
        return this;
    }

    public DatabaseMatch setNTermMetCleaved(boolean isNTermMetCleaved) {
        this.isNTermMetCleaved = isNTermMetCleaved;
        return this;
    }

    public boolean isNTermMetCleaved() {
        return this.isNTermMetCleaved;
    }

    public void setPSMQValue(float psmQValue) {
        this.psmQValue = Float.valueOf(psmQValue);
    }

    public Float getPSMQValue() {
        return this.psmQValue;
    }

    public void setPepQValue(Float pepQValue) {
        this.pepQValue = pepQValue;
    }

    public Float getPepQValue() {
        return this.pepQValue;
    }

    public void addIndex(int index) {
        if (this.indices == null) {
            this.indices = new TreeSet<Integer>();
            this.indices.add(this.index);
        }
        this.indices.add(index);
    }

    public SortedSet<Integer> getIndices() {
        if (this.indices == null) {
            TreeSet<Integer> temp = new TreeSet<Integer>();
            temp.add(this.index);
            return temp;
        }
        return this.indices;
    }

    public int getIndex() {
        return this.index;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isProteinNTerm() {
        return this.isProteinNTerm;
    }

    public boolean isProteinCTerm() {
        return this.isProteinCTerm;
    }

    public int hashCode() {
        return this.index * this.length;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DatabaseMatch) {
            DatabaseMatch other = (DatabaseMatch)obj;
            if (this.index == other.index && this.length == other.length) {
                return true;
            }
        }
        return false;
    }
}

