/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msdbsearch;

import edu.ucsd.msjava.parser.BufferedLineReader;
import edu.ucsd.msjava.suffixarray.SuffixArray;
import edu.ucsd.msjava.suffixarray.SuffixArraySequence;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;

public class FilterDatabase {
    public static void main(String[] argv) throws Exception {
        File dbFile = null;
        File resultFile = null;
        int pepColumn = -1;
        String delimiter = "\t";
        for (int i = 0; i < argv.length; i += 2) {
            if (!argv[i].startsWith("-") || i + 1 >= argv.length) {
                FilterDatabase.printUsageAndExit("Invalid parameters");
                continue;
            }
            if (argv[i].equalsIgnoreCase("-d")) {
                dbFile = new File(argv[i + 1]);
                if (dbFile.exists()) continue;
                FilterDatabase.printUsageAndExit(argv[i + 1] + " doesn't exist");
                continue;
            }
            if (argv[i].equalsIgnoreCase("-r")) {
                resultFile = new File(argv[i + 1]);
                if (resultFile.exists()) continue;
                FilterDatabase.printUsageAndExit(argv[i + 1] + " doesn't exist");
                continue;
            }
            if (argv[i].equalsIgnoreCase("-p")) {
                pepColumn = Integer.parseInt(argv[i + 1]);
                continue;
            }
            if (!argv[i].equalsIgnoreCase("-delim")) continue;
            delimiter = argv[i + 1];
        }
        if (dbFile == null || !dbFile.exists()) {
            FilterDatabase.printUsageAndExit("Invalid dbFile!");
        }
        if (resultFile == null || !resultFile.exists()) {
            FilterDatabase.printUsageAndExit("Invalid resultFile!");
        }
        if (pepColumn < 0) {
            FilterDatabase.printUsageAndExit("Invalid pepColumn!");
        }
        FilterDatabase.filterDatabase(dbFile, resultFile, pepColumn, delimiter);
    }

    public static void printUsageAndExit(String message) {
        System.out.println(message);
        System.out.println("usage: java FilterDatabase\n\t-d database(*.fasta)\n\t-r searchResult\n\t-p pepColumn\n\t[-delim delimiter] (default: \\t)");
        System.exit(-1);
    }

    public static void filterDatabase(File dbFile, File resultFile, int pepColumn, String delimiter) throws Exception {
        String s;
        SuffixArraySequence sequence = new SuffixArraySequence(dbFile.getPath());
        SuffixArray sa = new SuffixArray(sequence);
        HashSet<String> matchedEntrySet = new HashSet<String>();
        BufferedLineReader in = new BufferedLineReader(resultFile.getPath());
        in.readLine();
        while ((s = in.readLine()) != null) {
            String annotation;
            String[] token = s.split(delimiter);
            if (token.length < pepColumn) continue;
            String pepStr = annotation = token[pepColumn];
            if (annotation.matches("[A-Z]\\.[A-Z]+\\.[A-Z]")) {
                pepStr = annotation.substring(annotation.indexOf(46) + 1, annotation.lastIndexOf(46));
            }
            ArrayList<String> matchedEntries = sa.getAllMatchingAnnotations(pepStr);
            ArrayList<String> matchedProtSeq = sa.getAllMatchingEntries(pepStr);
            for (int i = 0; i < matchedEntries.size(); ++i) {
                String entry = matchedEntries.get(i);
                if (matchedEntrySet.contains(entry)) continue;
                matchedEntrySet.add(entry);
                System.out.println(">" + entry);
                System.out.println(matchedProtSeq.get(i));
            }
        }
    }
}

