/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msdbsearch;

import edu.ucsd.msjava.msdbsearch.CandidatePeptideGrid;
import edu.ucsd.msjava.msdbsearch.CompactFastaSequence;
import edu.ucsd.msjava.msdbsearch.CompactSuffixArray;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Enzyme;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class PeptideEnumerator {
    private static final int MIN_PEPTIDE_LENGTH = 6;
    private static final int MAX_PEPTIDE_LENGTH = 30;
    private static final int MAX_NUM_MODS = 0;
    private static final int MAX_NUM_MISSED_CLEAVAGES = 2;
    private static final int NTT = 1;

    public static void main(String[] argv) throws Exception {
        File fastaFile;
        if (argv.length != 2) {
            PeptideEnumerator.printUsageAndExit("Wrong parameter!");
        }
        if (!(fastaFile = new File(argv[0])).exists()) {
            PeptideEnumerator.printUsageAndExit("File does not exist!");
        }
        if (fastaFile.isDirectory()) {
            PeptideEnumerator.printUsageAndExit("File must not be a directory!");
        }
        if (!fastaFile.getName().endsWith(".fasta") && !fastaFile.getName().endsWith(".fa")) {
            PeptideEnumerator.printUsageAndExit("Not a fasta file!");
        }
        File outputFile = new File(argv[1]);
        String decoyProteinPrefix = argv.length > 2 ? argv[2] : "XXX";
        PeptideEnumerator.enumerate(fastaFile, outputFile, decoyProteinPrefix);
    }

    public static void printUsageAndExit(String message) {
        if (message != null) {
            System.out.println(message);
        }
        System.out.println("Usage: java -Xmx3500M -cp MSGFPlus.jar edu.ucsd.msjava.msdbsearch.PeptideEnumerator FastaFile(*.fasta or *.fa) OutputFile [DecoyPrefix]");
        System.exit(-1);
    }

    public static void enumerate(File fastaFile, File outputFile, String decoyProteinPrefix) throws Exception {
        CompactFastaSequence fastaSequence = new CompactFastaSequence(fastaFile.getPath());
        fastaSequence.setDecoyProteinPrefix(decoyProteinPrefix);
        CompactSuffixArray sa = new CompactSuffixArray(fastaSequence, 30);
        PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
        DataInputStream indices = new DataInputStream(new BufferedInputStream(new FileInputStream(sa.getIndexFile())));
        indices.skip(8L);
        DataInputStream nlcps = new DataInputStream(new BufferedInputStream(new FileInputStream(sa.getNeighboringLcpFile())));
        nlcps.skip(8L);
        CompactFastaSequence sequence = sa.getSequence();
        int i = 2147482647;
        int size = sa.getSize();
        AminoAcidSet aaSet = AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys();
        Enzyme enzyme = Enzyme.TRYPSIN;
        CandidatePeptideGrid candidatePepGrid = new CandidatePeptideGrid(aaSet, enzyme, 30, 128, -1);
        int[] numMissedCleavages = new int[31];
        int nnet = 0;
        block0: for (int bufferIndex = 0; bufferIndex < size; ++bufferIndex) {
            char residue;
            int index = indices.readInt();
            byte lcp = nlcps.readByte();
            if (lcp >= i + 1) continue;
            if (lcp == 0) {
                char precedingAA = sequence.getCharAt(index);
                if (precedingAA != '_' && !enzyme.isCleavable(precedingAA)) {
                    i = 0;
                    nnet = 1;
                    if (nnet > 1) {
                        continue;
                    }
                } else {
                    nnet = 0;
                }
            }
            if (lcp == 0) {
                i = 1;
            } else if (lcp < i + 1) {
                i = lcp;
            }
            while (i < 31 && index + i < size - 1 && candidatePepGrid.addResidue(i, residue = sequence.getCharAt(index + i))) {
                numMissedCleavages[i] = enzyme.isCleavable(residue) ? numMissedCleavages[i - 1] + 1 : numMissedCleavages[i - 1];
                if (numMissedCleavages[i] > 3) continue block0;
                if (i < 6) {
                    if (numMissedCleavages[i] == 3) {
                        continue block0;
                    }
                } else {
                    char next = sequence.getCharAt(index + i + 1);
                    if (enzyme.isCleavable(residue) || next == '_' || nnet + 1 <= 1) {
                        for (int j = 0; j < candidatePepGrid.size(); ++j) {
                            char pre = sequence.getCharAt(index);
                            String pepSeq = candidatePepGrid.getPeptideSeq(j);
                            float peptideMass = candidatePepGrid.getPeptideMass(j) + 18.010565f;
                            out.println(pre + "." + pepSeq);
                        }
                        if (numMissedCleavages[i] == 3) continue block0;
                    }
                }
                ++i;
            }
        }
        indices.close();
        nlcps.close();
        out.close();
        System.out.println("Done");
    }
}

