/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msdbsearch;

import edu.ucsd.msjava.suffixarray.SuffixArray;
import edu.ucsd.msjava.suffixarray.SuffixArraySequence;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class SuffixArrayForMSGFDB
extends SuffixArray {
    private int[] numDisinctPeptides;

    public SuffixArrayForMSGFDB(SuffixArraySequence sequence) {
        super(sequence);
    }

    public SuffixArrayForMSGFDB(SuffixArraySequence sequence, int minPeptideLength, int maxPeptideLength) {
        super(sequence);
        this.numDisinctPeptides = new int[maxPeptideLength + 2];
        for (int length = minPeptideLength; length <= maxPeptideLength + 1; ++length) {
            this.numDisinctPeptides[length] = this.getNumDistinctSeq(length);
        }
    }

    public IntBuffer getIndices() {
        return this.indices;
    }

    public ByteBuffer getNeighboringLcps() {
        return this.neighboringLcps;
    }

    public SuffixArraySequence getSequence() {
        return this.sequence;
    }

    public int getNumDistinctPeptides(int length) {
        if (this.numDisinctPeptides != null) {
            return this.numDisinctPeptides[length];
        }
        return this.getNumDistinctSeq(length);
    }

    @Override
    protected int readSuffixArrayFile(String suffixFile) {
        try {
            long totalBytesSkipped;
            long bytesSkipped;
            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(suffixFile)));
            this.size = in.readInt();
            int id = in.readInt();
            int[] indexArr = new int[this.size];
            for (int i = 0; i < indexArr.length; ++i) {
                indexArr[i] = in.readInt();
            }
            this.indices = IntBuffer.wrap(indexArr).asReadOnlyBuffer();
            int sizeOfLcps = this.size;
            for (totalBytesSkipped = 0L; totalBytesSkipped < (long)(2 * sizeOfLcps); totalBytesSkipped += bytesSkipped) {
                bytesSkipped = in.skip((long)(2 * sizeOfLcps) - totalBytesSkipped);
                if (bytesSkipped != 0L) continue;
                System.out.println("Error while reading suffix array: " + totalBytesSkipped + "!=" + 2 * sizeOfLcps);
                System.exit(-1);
            }
            if (totalBytesSkipped != (long)(2 * sizeOfLcps)) {
                System.out.println("Error while reading suffix array: " + totalBytesSkipped + "!=" + 2 * sizeOfLcps);
                System.exit(-1);
            }
            byte[] neighboringLcpArr = new byte[sizeOfLcps];
            in.read(neighboringLcpArr);
            this.neighboringLcps = ByteBuffer.wrap(neighboringLcpArr).asReadOnlyBuffer();
            in.close();
            return id;
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
            return 0;
        }
    }

    private int getNumDistinctSeq(int length) {
        int numDistinctSeq = 0;
        while (this.neighboringLcps.hasRemaining()) {
            byte lcp = this.neighboringLcps.get();
            if (lcp >= length) continue;
            ++numDistinctSeq;
        }
        this.neighboringLcps.rewind();
        this.indices.rewind();
        return numDistinctSeq++;
    }
}

