/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msdictionary;

import edu.ucsd.msjava.parser.BufferedLineReader;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;

public class GenomeSplitter {
    private final String fileName;
    private Hashtable<String, Long> lengthTable;
    private long sum;
    private long[] subsetSize;
    private StringHashSet[] subsetAnnotation;

    public GenomeSplitter(String fileName) {
        this.fileName = fileName;
    }

    public long getSum() {
        return this.sum;
    }

    public long[] getSubsetSizeArr() {
        return this.subsetSize;
    }

    private GenomeSplitter scan() {
        String s;
        BufferedLineReader reader = null;
        try {
            reader = new BufferedLineReader(this.fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.lengthTable = new Hashtable();
        long sum = 0L;
        String annotation = null;
        long chrSize = 0L;
        while ((s = reader.readLine()) != null) {
            if (s.length() == 0) continue;
            if (s.startsWith(">")) {
                if (annotation != null) {
                    this.lengthTable.put(annotation, chrSize);
                    sum += chrSize;
                }
                annotation = s.substring(1);
                chrSize = 0L;
                continue;
            }
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c != 'A' && c != 'T' && c != 'C' && c != 'G') continue;
                ++chrSize;
            }
        }
        if (annotation != null) {
            this.lengthTable.put(annotation, chrSize);
            sum += chrSize;
        }
        this.sum = sum;
        return this;
    }

    public GenomeSplitter split(int numSubsets) {
        if (this.lengthTable == null) {
            return this;
        }
        this.subsetAnnotation = new StringHashSet[numSubsets];
        long lengthOfSubset = this.sum / (long)numSubsets;
        float allowedError = 0.1f;
        ArrayList<String> annotationList = new ArrayList<String>(this.lengthTable.keySet());
        this.subsetSize = new long[numSubsets];
        int[] subsetBoundaries = new int[numSubsets];
        boolean success = false;
        block0: while (!success) {
            Collections.shuffle(annotationList);
            int subsetIndex = 0;
            long size = 0L;
            long sizeSoFar = 0L;
            for (int i = 0; i < annotationList.size(); ++i) {
                if (subsetIndex == numSubsets - 1) {
                    long remainingSize = this.sum - sizeSoFar;
                    if (remainingSize < (long)((float)lengthOfSubset * (1.0f - allowedError)) || remainingSize > (long)((float)lengthOfSubset * (1.0f + allowedError))) continue block0;
                    this.subsetSize[numSubsets - 1] = remainingSize;
                    subsetBoundaries[numSubsets - 1] = annotationList.size() - 1;
                    success = true;
                    continue block0;
                }
                String annotation = annotationList.get(i);
                long len = this.lengthTable.get(annotation);
                if (size + len < (long)((int)((float)lengthOfSubset * (1.0f - allowedError)))) {
                    size += len;
                    continue;
                }
                if (size + len < (long)((float)lengthOfSubset * (1.0f - allowedError)) || size + len > (long)((float)lengthOfSubset * (1.0f + allowedError))) continue block0;
                this.subsetSize[subsetIndex] = size + len;
                subsetBoundaries[subsetIndex] = i;
                sizeSoFar += size + len;
                ++subsetIndex;
                size = 0L;
            }
        }
        int startIndex = 0;
        for (int i = 0; i < this.subsetSize.length; ++i) {
            this.subsetAnnotation[i] = new StringHashSet();
            for (int j = startIndex; j <= subsetBoundaries[i]; ++j) {
                this.subsetAnnotation[i].add(annotationList.get(j));
            }
            startIndex = subsetBoundaries[i] + 1;
        }
        return this;
    }

    public void save(String prefix) {
        String s;
        if (this.subsetAnnotation == null) {
            return;
        }
        BufferedLineReader reader = null;
        try {
            reader = new BufferedLineReader(this.fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PrintStream[] out = new PrintStream[this.subsetAnnotation.length];
        for (int i = 0; i < out.length; ++i) {
            try {
                out[i] = new PrintStream(new BufferedOutputStream(new FileOutputStream(prefix + i + ".fasta")));
                continue;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        PrintStream curOut = null;
        while ((s = reader.readLine()) != null) {
            if (s.length() == 0) continue;
            if (s.startsWith(">")) {
                curOut = null;
                String annotation = s.substring(1);
                int index = -1;
                for (StringHashSet hash : this.subsetAnnotation) {
                    ++index;
                    if (!hash.contains(annotation)) continue;
                    curOut = out[index];
                }
            }
            curOut.println(s);
        }
        for (PrintStream o : out) {
            o.close();
        }
    }

    public void printLengthDistribution() {
        if (this.lengthTable == null) {
            return;
        }
        ArrayList<String> annotationList = new ArrayList<String>(this.lengthTable.keySet());
        Collections.sort(annotationList);
        for (String annotation : annotationList) {
            System.out.println(annotation + "\t" + this.lengthTable.get(annotation));
        }
    }

    public static void main(String[] argv) {
        if (argv.length != 2) {
            GenomeSplitter.printUsage();
            System.exit(0);
        } else {
            String source = argv[0];
            if (!source.contains(".fa")) {
                System.out.println("Source is not the fasta format.");
                System.exit(0);
            }
            String targetPrefix = source.substring(0, source.lastIndexOf(46) + 1);
            int numSubsets = Integer.parseInt(argv[1]);
            GenomeSplitter splitter = new GenomeSplitter(argv[0]);
            splitter.scan().split(numSubsets).save(targetPrefix);
            System.out.println("Total unmasked length: " + splitter.getSum());
            int subsetIndex = -1;
            for (long s : splitter.getSubsetSizeArr()) {
                System.out.println("Subset " + ++subsetIndex + ": " + s);
            }
            System.out.println("Done");
        }
    }

    public static void printUsage() {
        System.out.println("usage: java -Xmx(HeapSize) GenomeSplitter source(fasta) #files\n(Example: java GenomeSplitter test.fasta 4)");
    }

    private static class StringHashSet
    extends HashSet<String> {
        private static final long serialVersionUID = 1L;

        private StringHashSet() {
        }
    }
}

