/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msdictionary;

import edu.ucsd.msjava.msgf.AminoAcidGraph;
import edu.ucsd.msjava.msgf.GeneratingFunction;
import edu.ucsd.msjava.msgf.NominalMass;
import edu.ucsd.msjava.msgf.NominalMassFactory;
import edu.ucsd.msjava.msgf.ToolLauncher;
import edu.ucsd.msjava.msscorer.NewAdditiveScorer;
import edu.ucsd.msjava.msscorer.NewScoredSpectrum;
import edu.ucsd.msjava.msscorer.NewScorerFactory;
import edu.ucsd.msjava.msutil.ActivationMethod;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Enzyme;
import edu.ucsd.msjava.msutil.Peptide;
import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.suffixarray.SuffixArray;
import java.util.ArrayList;
import java.util.Iterator;

public class MSDicLauncher
extends ToolLauncher {
    private final SuffixArray sa;
    private float numRecs = 1000000.0f;
    private boolean isNumInclusive = false;

    public MSDicLauncher(Iterator<Spectrum> specIterator, NewAdditiveScorer scorer, SuffixArray sa) {
        super(specIterator, scorer);
        this.sa = sa;
    }

    public MSDicLauncher(Iterator<Spectrum> specIterator, NewAdditiveScorer scorer) {
        this(specIterator, scorer, null);
    }

    public MSDicLauncher numRecs(float numRecs) {
        this.numRecs = numRecs;
        return this;
    }

    public MSDicLauncher setNumInclusive() {
        this.isNumInclusive = true;
        return this;
    }

    @Deprecated
    public void runMSDictionary() {
        int numSpecs = 0;
        int numProcessed = 0;
        AminoAcidSet aaSet = AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys();
        Enzyme enzyme = Enzyme.TRYPSIN;
        int maxLength = 30;
        boolean dataStructure = false;
        if (this.sa != null) {
            this.out.println("Title\tScanNum\tPeptide\tProtein\tPrecursorMass\tCharge\tMSGFScore\tPeptideScore\tSpecProb");
        }
        NominalMassFactory factory = new NominalMassFactory(aaSet, enzyme, maxLength);
        while (this.specIterator.hasNext()) {
            ArrayList<String> dictionary;
            Spectrum spec = (Spectrum)this.specIterator.next();
            ++numSpecs;
            int charge = spec.getCharge();
            if (charge == 0) {
                spec.setCharge(2);
            }
            if (spec.getPrecursorMass() > this.maxParentMass || spec.getPrecursorMass() < this.minParentMass) continue;
            GeneratingFunction<NominalMass> gf = null;
            GeneratingFunction<NominalMass> gfWellCleaved = null;
            if (!dataStructure) {
                NewScoredSpectrum<NominalMass> scoredSpec = NewScorerFactory.get(ActivationMethod.CID, Enzyme.TRYPSIN).getScoredSpectrum(spec);
                AminoAcidGraph graph = new AminoAcidGraph(factory, spec.getPrecursorMass(), scoredSpec);
                gf = new GeneratingFunction<NominalMass>(graph);
                gfWellCleaved = new GeneratingFunction<NominalMass>(graph).enzyme(Enzyme.TRYPSIN);
                gfWellCleaved.doNotBacktrack().doNotCalcNumber();
            }
            ++numProcessed;
            gf.computeGeneratingFunction();
            if (gf.getMaxScore() <= this.msgfScoreThreshold || (dictionary = gf.getReconstructions(this.specProb, this.numRecs, this.isNumInclusive, this.sa)).size() == 0) continue;
            if (this.sa == null) {
                String title = spec.getTitle();
                if (title == null) {
                    title = "Spec:" + spec.getSpecIndex();
                }
                this.out.println("#" + spec.getTitle() + "\t" + spec.getSpecIndex() + "\t" + spec.getPrecursorPeak().getMz() + "\t" + charge + "\t" + (gf.getMaxScore() - 1));
                for (String s : dictionary) {
                    Peptide p = new Peptide(s, aaSet);
                    int score = gf.getGraph().getScore(p);
                    this.out.println(s + "\t" + score + "\t" + gf.getSpectralProbability(score));
                }
                continue;
            }
            for (String s : dictionary) {
                ArrayList<String> matchedPeptides = this.sa.getAllMatchedStrings(s);
                ArrayList<String> matchedProteinAnnotations = this.sa.getAllMatchingAnnotations(s);
                assert (matchedPeptides.size() == matchedProteinAnnotations.size());
                for (int i = 0; i < matchedPeptides.size(); ++i) {
                    Peptide pep = new Peptide(s, aaSet);
                    int peptideScore = gf.getGraph().getScore(pep);
                    if (this.trypticOnly && !Enzyme.TRYPSIN.isCleaved(pep)) continue;
                    double specProb = gf.getSpectralProbability(peptideScore);
                    String id = matchedPeptides.get(i);
                    this.out.println(spec.getTitle() + "\t" + spec.getSpecIndex() + "\t" + id + "\t" + matchedProteinAnnotations.get(i) + "\t" + spec.getPrecursorPeak().getMz() + "\t" + spec.getCharge() + "\t" + (gf.getMaxScore() - 1) + "\t" + peptideScore + "\t" + specProb);
                }
            }
        }
        this.out.close();
    }
}

