/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msdictionary;

import edu.ucsd.msjava.parser.BufferedLineReader;
import edu.ucsd.msjava.suffixarray.SuffixArray;
import edu.ucsd.msjava.suffixarray.SuffixArraySequence;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;

public class ProteinLocator {
    public static void main(String[] argv) {
        ProteinLocator.processNitinMSDicResult();
    }

    public static void processNitinMSDicResult() {
        String s;
        String fileName = System.getProperty("user.home") + "/Research/Data/NitinSignalPep/msDic_11_6_1800_20.txt";
        BufferedLineReader in = null;
        try {
            in = new BufferedLineReader(fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        HashSet<String> pepSet = new HashSet<String>();
        while ((s = in.readLine()) != null) {
            String[] token = s.split("\t");
            if (token.length != 9 || !token[0].startsWith("null")) continue;
            pepSet.add(token[2].substring(token[2].indexOf(46) + 1, token[2].lastIndexOf(46)));
        }
        Hashtable<String, ArrayList<String>> table = new Hashtable<String, ArrayList<String>>();
        File dir = new File(System.getProperty("user.home") + "/Research/Data/HumanGenome/translated");
        assert (dir.isDirectory());
        for (File f : dir.listFiles()) {
            if (!f.getName().endsWith("fasta")) continue;
            SuffixArray sa = new SuffixArray(new SuffixArraySequence(f.getPath(), "A:C:D:E:F:G:H:IL:K:M:N:P:Q:R:S:T:V:W:Y"));
            for (String pep : pepSet) {
                ArrayList matches = (ArrayList)table.get(pep);
                if (matches == null) {
                    table.put(pep, sa.getAllMatchedStrings(pep, 20));
                    continue;
                }
                matches.addAll(sa.getAllMatchedStrings(pep, 20));
            }
            sa = null;
        }
        try {
            in = new BufferedLineReader(fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        while ((s = in.readLine()) != null) {
            String[] token = s.split("\t");
            if (token.length == 9 && token[0].startsWith("null")) {
                String pep = token[2].substring(token[2].indexOf(46) + 1, token[2].lastIndexOf(46));
                ArrayList matches = (ArrayList)table.get(pep);
                for (String m : matches) {
                    System.out.print(token[0]);
                    for (int i = 1; i < token.length; ++i) {
                        if (i != 2) {
                            System.out.print("\t" + token[i]);
                            continue;
                        }
                        System.out.print("\t" + m);
                    }
                    System.out.println();
                }
                continue;
            }
            System.out.println(s);
        }
    }
}

