/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msgf;

import edu.ucsd.msjava.msgf.DeNovoGraph;
import edu.ucsd.msjava.msgf.Tolerance;
import edu.ucsd.msjava.msutil.AminoAcid;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Enzyme;
import edu.ucsd.msjava.msutil.Matter;
import edu.ucsd.msjava.msutil.Peptide;
import edu.ucsd.msjava.msutil.Sequence;
import java.util.ArrayList;
import java.util.Collection;

public interface DeNovoNodeFactory<T extends Matter> {
    public AminoAcidSet getAASet();

    public T getZero();

    public ArrayList<T> getNodes(float var1, Tolerance var2);

    public T getNode(float var1);

    public T getComplementNode(T var1, T var2);

    public ArrayList<T> getLinkedNodeList(Collection<T> var1);

    public ArrayList<DeNovoGraph.Edge<T>> getEdges(T var1);

    public DeNovoGraph.Edge<T> getEdge(T var1, T var2);

    public Sequence<T> toCumulativeSequence(boolean var1, Peptide var2);

    public T getPreviousNode(T var1, AminoAcid var2);

    public T getNextNode(T var1, AminoAcid var2);

    public int size();

    public boolean contains(T var1);

    public boolean isReverse();

    public Enzyme getEnzyme();
}

