/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msgf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;

public class Histogram<T extends Comparable<T>>
extends Hashtable<T, Integer> {
    private static final long serialVersionUID = 1L;
    private T minKey = null;
    private T maxKey = null;
    private int size;

    public void add(T t) {
        if (this.get(t) == null) {
            this.put(t, 1);
        } else {
            this.put(t, this.get(t) + 1);
        }
        if (this.minKey == null || this.minKey.compareTo(t) > 0) {
            this.minKey = t;
        }
        if (this.maxKey == null || this.maxKey.compareTo(t) < 0) {
            this.maxKey = t;
        }
        ++this.size;
    }

    public void setMinKey(T minKey) {
        this.minKey = minKey;
    }

    public void setMaxKey(T maxKey) {
        this.maxKey = maxKey;
    }

    public T minKey() {
        return this.minKey;
    }

    public T maxKey() {
        return this.maxKey;
    }

    public int totalCount() {
        return this.size;
    }

    @Override
    public Integer get(Object key) {
        Integer num = (Integer)super.get(key);
        if (num == null) {
            return 0;
        }
        return num;
    }

    public void printSorted() {
        ArrayList keyList = new ArrayList(this.keySet());
        Collections.sort(keyList);
        for (Comparable key : keyList) {
            System.out.println(key + "\t" + this.get(key));
        }
    }

    public void printSortedRatio() {
        int totalCount = this.totalCount();
        ArrayList keyList = new ArrayList(this.keySet());
        Collections.sort(keyList);
        for (Comparable key : keyList) {
            System.out.println(key + "\t" + this.get(key) + "\t" + (float)this.get(key).intValue() / (float)totalCount);
        }
    }
}

