/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msgf;

import edu.ucsd.msjava.msgf.Histogram;

public class IntHistogram
extends Histogram<Integer> {
    private static final long serialVersionUID = 1L;

    public float[] getSmoothedHist(int keySize) {
        float[] smoothedHist = new float[keySize * 2 + 1];
        for (int i = -keySize; i <= keySize; ++i) {
            int windowSize = Math.abs(i) <= 3 ? 0 : (int)(Math.log(Math.abs(i)) / Math.log(2.0)) - 1;
            int numUsedEntries = 0;
            int sum = 0;
            for (int j = i - windowSize; j <= i + windowSize; ++j) {
                if (j > keySize || j < -keySize) continue;
                ++numUsedEntries;
                sum += this.get(j).intValue();
            }
            while (sum == 0) {
                if (++windowSize > keySize) {
                    sum = 1;
                    numUsedEntries = 2 * keySize + 1;
                    break;
                }
                if (i - windowSize >= -keySize) {
                    sum += this.get(i - windowSize).intValue();
                    ++numUsedEntries;
                }
                if (i + windowSize > keySize) continue;
                sum += this.get(i + windowSize).intValue();
                ++numUsedEntries;
            }
            smoothedHist[i + keySize] = (float)sum / (float)numUsedEntries;
        }
        return smoothedHist;
    }
}

