/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msgf;

import edu.ucsd.msjava.msgf.ScoreDist;
import java.io.PrintStream;
import java.util.List;

public class MSGFDBResultGenerator {
    private static final int NUM_SPECS_TO_USE_SIMPLE_ETDA_FORMULA = 30000;
    private static final long serialVersionUID = 1L;
    private String header;
    private List<DBMatch> resultList;

    public MSGFDBResultGenerator(String header, List<DBMatch> resultList) {
        this.header = header;
        this.resultList = resultList;
    }

    public void computeEFDR() {
        double cumulativePValue = 0.0;
        boolean useComplicatedFormula = true;
        if (this.resultList.size() >= 30000) {
            useComplicatedFormula = false;
        }
        for (int i = 0; i < this.resultList.size(); ++i) {
            double specProb = this.resultList.get(i).getSpecProb();
            double pValue = this.resultList.get(i).getPValue();
            double eTD = (double)(i + 1) - (cumulativePValue += pValue);
            double eDD = cumulativePValue;
            if (useComplicatedFormula) {
                for (int j = i + 1; j < this.resultList.size(); ++j) {
                    eDD += this.resultList.get(j).getEDD(specProb);
                }
            } else {
                eDD += pValue * (double)(this.resultList.size() - (i + 1));
            }
            this.resultList.get(i).setEFDR(Math.min(eDD / eTD, 1.0));
        }
    }

    public void writeResults(PrintStream out, boolean printEFDR, boolean outputForPercolator) {
        if (outputForPercolator) {
            out.println(this.header + "\tExpIonCur\tNTermIonCur\tCTermIonCur\tMS2IonCur\tMS1IonCur\tIsoWinEff");
        } else if (printEFDR) {
            out.println(this.header + "\tEFDR");
        } else {
            out.println(this.header);
        }
        for (DBMatch m : this.resultList) {
            if (outputForPercolator) continue;
            if (printEFDR) {
                double eFDR = m.getEFDR();
                String eFDRStr = eFDR < 1.1754943508222875E-38 ? String.valueOf(eFDR) : String.valueOf((float)eFDR);
                out.println(m.getResultStr() + "\t" + eFDRStr);
                continue;
            }
            out.println(m.getResultStr());
        }
    }

    public static class DBMatch
    implements Comparable<DBMatch> {
        private double specProb;
        private double pValue;
        private int numPeptides;
        private String resultStr;
        private double[] cumScoreDist;
        private double eFDR;
        int curIndex;

        public DBMatch(double specProb, int numPeptides, String resultStr, ScoreDist scoreDist) {
            this.specProb = specProb;
            this.pValue = DBMatch.getPValue(specProb, numPeptides);
            this.numPeptides = numPeptides;
            this.resultStr = resultStr;
            if (scoreDist != null && scoreDist.isProbSet()) {
                this.cumScoreDist = new double[scoreDist.getMaxScore() - scoreDist.getMinScore() + 1];
                this.cumScoreDist[0] = 0.0;
                int index = 1;
                for (int t = scoreDist.getMaxScore() - 1; t >= scoreDist.getMinScore(); --t) {
                    this.cumScoreDist[index] = this.cumScoreDist[index - 1] + scoreDist.getProbability(t);
                    ++index;
                }
            }
            this.curIndex = 0;
        }

        public static double getPValue(double specProb, int numPeptides) {
            double probCorr = 1.0 - specProb;
            double pValue = probCorr < 1.0 ? 1.0 - Math.pow(probCorr, numPeptides) : specProb * (double)numPeptides;
            return pValue;
        }

        public static double getEValue(double specProb, int numPeptides) {
            return specProb * (double)numPeptides;
        }

        public void setEFDR(double eFDR) {
            this.eFDR = eFDR;
        }

        public double getEFDR() {
            return this.eFDR;
        }

        public double getEDD(double specProbThreshold) {
            double probEqualOrBetterTargetPep = specProbThreshold >= this.specProb ? this.specProb : this.getSpectralProbability(specProbThreshold);
            double pValue = DBMatch.getPValue(probEqualOrBetterTargetPep, this.numPeptides);
            return pValue;
        }

        public double getSpectralProbability(double specProbThreshold) {
            while (this.curIndex < this.cumScoreDist.length - 1 && this.cumScoreDist[this.curIndex + 1] <= specProbThreshold) {
                ++this.curIndex;
            }
            return this.cumScoreDist[this.curIndex];
        }

        public double getSpecProb() {
            return this.specProb;
        }

        public double getPValue() {
            return this.pValue;
        }

        public String getResultStr() {
            return this.resultStr;
        }

        @Override
        public int compareTo(DBMatch arg0) {
            if (this.specProb < arg0.specProb) {
                return -1;
            }
            if (this.specProb > arg0.specProb) {
                return 1;
            }
            return 0;
        }
    }
}

