/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msgf;

import edu.ucsd.msjava.msgf.Tolerance;
import edu.ucsd.msjava.msutil.Mass;
import edu.ucsd.msjava.msutil.Matter;
import java.util.ArrayList;

public class MassListComparator<T extends Matter> {
    ArrayList<T> massList1;
    ArrayList<T> massList2;

    public MassListComparator(ArrayList<T> massList1, ArrayList<T> massList2) {
        this.massList1 = massList1;
        this.massList2 = massList2;
    }

    public MatchedPair[] getMatchedList(Tolerance tolerance) {
        int i1 = 0;
        int i2 = 0;
        ArrayList<MatchedPair<Matter>> matches = new ArrayList<MatchedPair<Matter>>();
        while (i1 < this.massList1.size() && i2 < this.massList2.size()) {
            float tol;
            float m1 = ((Matter)this.massList1.get(i1)).getMass();
            float m2 = ((Matter)this.massList2.get(i2)).getMass();
            if (m2 <= m1 - (tol = tolerance.getToleranceAsDa(m1))) {
                ++i2;
                continue;
            }
            if (m2 < m1 + tol) {
                matches.add(new MatchedPair<Matter>((Matter)this.massList1.get(i1), (Matter)this.massList1.get(i2)));
                if (i1 == this.massList1.size() - 1) {
                    ++i2;
                    continue;
                }
                if (i2 == this.massList2.size() - 1) {
                    ++i1;
                    continue;
                }
                if (((Matter)this.massList1.get(i1 + 1)).getMass() < ((Matter)this.massList2.get(i2 + 1)).getMass()) {
                    ++i1;
                    continue;
                }
                ++i2;
                continue;
            }
            ++i1;
        }
        return matches.toArray(new MatchedPair[0]);
    }

    public static void main(String[] argv) {
        float[] data1 = new float[]{40.0f, 40.1f, 40.2f, 50.0f};
        float[] data2 = new float[]{39.7f, 40.05f, 40.6f};
        ArrayList<Mass> list1 = new ArrayList<Mass>();
        ArrayList<Mass> list2 = new ArrayList<Mass>();
        for (float f : data1) {
            list1.add(new Mass(f));
        }
        for (float f : data2) {
            list2.add(new Mass(f));
        }
        MassListComparator comparator = new MassListComparator(list1, list2);
        for (MatchedPair pair : comparator.getMatchedList(new Tolerance(0.5f))) {
            System.out.println(((Mass)pair.m1).getMass() + "\t" + ((Mass)pair.m2).getMass());
        }
    }

    public static class MatchedPair<T extends Matter> {
        T m1;
        T m2;

        public MatchedPair(T m1, T m2) {
            this.m1 = m1;
            this.m2 = m2;
        }

        public T getMass1() {
            return this.m1;
        }

        public T getMass2() {
            return this.m2;
        }
    }
}

