/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msgf;

import edu.ucsd.msjava.msgf.NominalMass;
import edu.ucsd.msjava.msgf.NominalMassFactory;
import edu.ucsd.msjava.msgf.ProfilePeak;
import edu.ucsd.msjava.msutil.AminoAcid;
import edu.ucsd.msjava.msutil.Composition;
import edu.ucsd.msjava.msutil.Matter;
import edu.ucsd.msjava.msutil.Peptide;
import edu.ucsd.msjava.msutil.Sequence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;

public class Profile<T extends Matter>
extends ArrayList<ProfilePeak<T>> {
    private static final long serialVersionUID = 1L;

    public Sequence<T> getNodesWithProbEqualOrHigherThan(float threshold) {
        Sequence seq = new Sequence();
        for (ProfilePeak p : this) {
            if (!(p.getProbability() >= threshold)) continue;
            seq.add(p.getNode());
        }
        return seq;
    }

    public static Profile<Composition> getCompositionProfile(ArrayList<Peptide> dictionary, boolean prefix) {
        Hashtable<Composition, Integer> hist = new Hashtable<Composition, Integer>();
        for (Peptide peptide : dictionary) {
            Composition composition = new Composition(0);
            for (int i = 0; i < peptide.size(); ++i) {
                AminoAcid aa = prefix ? peptide.get(i) : peptide.get(peptide.size() - 1 - i);
                Integer occ = (Integer)hist.get(composition = composition.getAddition(aa.getComposition()));
                if (occ == null) {
                    hist.put(composition, 1);
                    continue;
                }
                hist.put(composition, occ + 1);
            }
        }
        Profile<Composition> profile = new Profile<Composition>();
        for (Composition c : hist.keySet()) {
            profile.add(new ProfilePeak<Composition>(c, (float)((Integer)hist.get(c)).intValue() / (float)dictionary.size()));
        }
        Collections.sort(profile);
        return profile;
    }

    public Profile<NominalMass> toNominalMasses() {
        Profile<NominalMass> nominalMassProfile = new Profile<NominalMass>();
        Hashtable<Integer, Float> summedProfile = new Hashtable<Integer, Float>();
        for (ProfilePeak p : this) {
            int mass = ((Matter)p.getNode()).getNominalMass();
            float prob = p.getProbability();
            Float prevProb = (Float)summedProfile.get(mass);
            if (prevProb == null) {
                summedProfile.put(mass, Float.valueOf(prob));
                continue;
            }
            summedProfile.put(mass, Float.valueOf(prevProb.floatValue() + prob));
        }
        for (Integer mass : summedProfile.keySet()) {
            float prob = ((Float)summedProfile.get(mass)).floatValue();
            nominalMassProfile.add(new ProfilePeak<NominalMass>(NominalMassFactory.getInstanceFor(mass.intValue()), prob));
        }
        Collections.sort(nominalMassProfile);
        return nominalMassProfile;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (ProfilePeak p : this) {
            buf.append(((Matter)p.getNode()).getMass() + "\t" + p.getProbability() + "\n");
        }
        return buf.toString();
    }

    public Hashtable<T, Float> getHashtable() {
        Hashtable hashtable = new Hashtable();
        for (ProfilePeak peak : this) {
            hashtable.put(peak.getNode(), Float.valueOf(peak.getProbability()));
        }
        return hashtable;
    }

    public float getSumProbabilities() {
        float sumProb = 0.0f;
        for (ProfilePeak peak : this) {
            sumProb += peak.getProbability();
        }
        return sumProb;
    }

    public float getEuclideanDistance() {
        float dist = 0.0f;
        for (ProfilePeak peak : this) {
            dist += peak.getProbability() * peak.getProbability();
        }
        return (float)Math.sqrt(dist);
    }

    public Profile<T> getSubtraction(Profile<T> prof) {
        Profile<T> subtraction = new Profile<T>();
        Hashtable<T, Float> table = prof.getHashtable();
        for (ProfilePeak profilePeak : prof) {
            Float prob = table.get(profilePeak.getNode());
            if (prob == null) {
                table.put(profilePeak.getNode(), Float.valueOf(profilePeak.getProbability()));
                continue;
            }
            table.put(profilePeak.getNode(), Float.valueOf(prob.floatValue() - profilePeak.getProbability()));
        }
        for (Map.Entry entry : table.entrySet()) {
            subtraction.add(new ProfilePeak<Matter>((Matter)entry.getKey(), ((Float)entry.getValue()).floatValue()));
        }
        Collections.sort(subtraction);
        return subtraction;
    }

    public static <T extends Matter> float getDotProduct(Profile<T> prof1, Profile<T> prof2) {
        float dotProduct = 0.0f;
        Hashtable<T, Float> table1 = prof1.getHashtable();
        for (ProfilePeak profilePeak : prof2) {
            Float prob = table1.get(profilePeak.getNode());
            if (prob == null) continue;
            dotProduct += prob.floatValue() * profilePeak.getProbability();
        }
        return dotProduct;
    }

    public static <T extends Matter> float getCosine(Profile<T> prof1, Profile<T> prof2) {
        return Profile.getDotProduct(prof1, prof2) / (prof1.getEuclideanDistance() * prof2.getEuclideanDistance());
    }
}

