/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msgf;

import edu.ucsd.msjava.msgf.BacktrackPointer;
import edu.ucsd.msjava.msgf.DeNovoGraph;
import edu.ucsd.msjava.msgf.GeneratingFunction;
import edu.ucsd.msjava.msgf.NominalMass;
import edu.ucsd.msjava.msgf.Profile;
import edu.ucsd.msjava.msgf.ProfilePeak;
import edu.ucsd.msjava.msgf.ScoreDist;
import edu.ucsd.msjava.msgf.ScoreDistFactory;
import edu.ucsd.msjava.msutil.Matter;
import edu.ucsd.msjava.msutil.Sequence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class ProfileGF<T extends Matter> {
    private final GeneratingFunction<T> gf;
    private HashMap<T, ScoreDist> bwdTable = null;
    private double sizeDictionary = 0.0;
    private Profile<T> profile = null;

    public ProfileGF(GeneratingFunction<T> gf) {
        this.gf = gf;
    }

    public HashMap<T, ScoreDist> getBwdTable() {
        return this.bwdTable;
    }

    public Sequence<NominalMass> getGappedPeptideWithNominalMasses(float scoreAbove, float profileThreshold) {
        if (this.bwdTable == null) {
            return null;
        }
        ProfileGF<T> templateProfileGF = new ProfileGF<T>(this.gf);
        Profile<NominalMass> templateProf = templateProfileGF.computeProfileOfScoreAboveTop(scoreAbove).getSpectralProfile().toNominalMasses();
        Sequence<NominalMass> template = templateProf.getNodesWithProbEqualOrHigherThan(0.99999f);
        Sequence<NominalMass> mask = this.getSpectralProfile().toNominalMasses().getNodesWithProbEqualOrHigherThan(profileThreshold);
        Sequence<NominalMass> gappedPeptide = Sequence.getIntersection(template, mask);
        return gappedPeptide;
    }

    public Sequence<T> getGappedPeptide(float templateFraction, float specProb, float profileThreshold) {
        if (this.bwdTable == null) {
            return null;
        }
        ProfileGF<T> templateProfile = new ProfileGF<T>(this.gf);
        Sequence<T> template = templateProfile.computeProfileOfScoreAboveTop(templateFraction).getSpectralProfile().getNodesWithProbEqualOrHigherThan(0.99f);
        Sequence<T> mask = this.computeProfile(specProb).getSpectralProfile().getNodesWithProbEqualOrHigherThan(profileThreshold);
        Sequence<T> gappedPeptide = Sequence.getIntersection(template, mask);
        return gappedPeptide;
    }

    public Profile<T> getSpectralProfile() {
        if (this.profile != null) {
            return this.profile;
        }
        if (this.gf.getFwdTable() == null || this.bwdTable == null) {
            return null;
        }
        Profile profile = new Profile();
        for (Matter m : this.bwdTable.keySet()) {
            ScoreDist fwdDist = this.gf.getFwdTable().get(m);
            ScoreDist bwdDist = this.bwdTable.get(m);
            if (fwdDist == null || bwdDist == null) continue;
            int minScore = bwdDist.getMinScore();
            int maxScore = bwdDist.getMaxScore();
            float sumNumbers = 0.0f;
            for (int t = minScore; t < maxScore; ++t) {
                double mult = bwdDist.getNumberRecs(t);
                if (mult == 0.0) continue;
                sumNumbers = (float)((double)sumNumbers + fwdDist.getNumberRecs(t) * mult);
            }
            if (!(sumNumbers > 0.0f)) continue;
            profile.add(new ProfilePeak<Matter>(m, sumNumbers / (float)this.sizeDictionary));
        }
        Collections.sort(profile);
        this.profile = profile;
        return this.profile;
    }

    public ProfileGF<T> computeProfileOfScoreAboveTop(float fraction) {
        int thresholdScore = Math.round((float)(this.gf.getMaxScore() - 1) * fraction);
        return this.computeProfile(thresholdScore);
    }

    public ProfileGF<T> computeProfileOfTopScoringPeptides() {
        int thresholdScore = this.gf.getMaxScore() - 1;
        return this.computeProfile(thresholdScore);
    }

    public ProfileGF<T> computeProfile(float specProb) {
        int thresholdScore = this.gf.getThresholdScore(specProb) + 1;
        if (thresholdScore >= this.gf.getMaxScore()) {
            thresholdScore = this.gf.getMaxScore() - 1;
        }
        return this.computeProfile(thresholdScore);
    }

    public ProfileGF<T> computeProfile(int thresholdScore) {
        Matter curNode;
        int i;
        this.sizeDictionary = this.gf.getNumEqualOrBetterPeptides(thresholdScore);
        HashMap<Matter, ScoreDist> bwdTable = new HashMap<Matter, ScoreDist>();
        ScoreDistFactory factory = new ScoreDistFactory(true, false);
        ArrayList<T> sinkList = this.gf.getGraph().getSinkList();
        for (Matter curNode2 : sinkList) {
            ScoreDist sinkFwd = this.gf.getFwdTable().get(curNode2);
            if (sinkFwd == null || sinkFwd.getMaxScore() <= thresholdScore) continue;
            ScoreDist bwdDist = factory.getInstance(thresholdScore, sinkFwd.getMaxScore());
            for (int t = thresholdScore; t < bwdDist.getMaxScore(); ++t) {
                bwdDist.setNumber(t, 1.0);
            }
            bwdTable.put(curNode2, bwdDist);
        }
        ArrayList<T> intermediateNodeList = this.gf.getGraph().getIntermediateNodeList();
        for (i = intermediateNodeList.size() - 1; i > 0; --i) {
            curNode = (Matter)intermediateNodeList.get(i);
            ScoreDist fwdDist = this.gf.getFwdTable().get(curNode);
            if (fwdDist == null) continue;
            ScoreDist bwdDist = factory.getInstance(fwdDist.getMinScore(), fwdDist.getMaxScore());
            bwdTable.put(curNode, bwdDist);
        }
        for (i = sinkList.size() - 1; i >= 0; --i) {
            curNode = (Matter)sinkList.get(i);
            this.setBackwardNodes(curNode, bwdTable);
        }
        for (i = intermediateNodeList.size() - 1; i > 0; --i) {
            curNode = (Matter)intermediateNodeList.get(i);
            this.setBackwardNodes(curNode, bwdTable);
        }
        this.bwdTable = bwdTable;
        return this;
    }

    private void setBackwardNodes(T curNode, HashMap<T, ScoreDist> bwdTable) {
        ScoreDist curBwdDist = bwdTable.get(curNode);
        if (curBwdDist == null) {
            return;
        }
        BacktrackPointer pointer = (BacktrackPointer)this.gf.getBacktrackTable().get(curNode);
        int curNodeScore = pointer.getNodeScore();
        int bits = 0;
        ScoreDist[] prevBwdDists = new ScoreDist[this.gf.getGraph().getAASet().size()];
        for (int score = curBwdDist.getMaxScore() - 1; score >= curBwdDist.getMinScore(); --score) {
            double numberRecs = curBwdDist.getNumberRecs(score);
            if (numberRecs == 0.0) continue;
            for (DeNovoGraph.Edge<T> edge : this.gf.getGraph().getEdges(curNode)) {
                ScoreDist prevBwdDist;
                int aaIndex = edge.getEdgeIndex();
                T prevNode = edge.getPrevNode();
                if ((bits & 1 << aaIndex) == 0) {
                    bits |= 1 << aaIndex;
                    prevBwdDists[aaIndex] = bwdTable.get(prevNode);
                }
                if ((prevBwdDist = prevBwdDists[aaIndex]) == null) continue;
                prevBwdDist.addNumber(score - curNodeScore, numberRecs);
            }
        }
    }
}

