/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msgf;

import edu.ucsd.msjava.msgf.ScoreBound;

public class ScoreDist
extends ScoreBound {
    private double[] numDistribution;
    private double[] probDistribution;

    ScoreDist(int minScore, int maxScore, boolean calcNumber, boolean calcProb) {
        super(minScore, maxScore);
        if (calcNumber) {
            this.numDistribution = new double[maxScore - minScore];
        }
        if (calcProb) {
            this.probDistribution = new double[maxScore - minScore];
        }
    }

    public boolean isProbSet() {
        return this.probDistribution != null;
    }

    public boolean isNumSet() {
        return this.numDistribution != null;
    }

    public void setNumber(int score, double number) {
        this.numDistribution[score - this.minScore] = number;
    }

    public void setProb(int score, double prob) {
        this.probDistribution[score - this.minScore] = prob;
    }

    public void addNumber(int score, double number) {
        int n = score - this.minScore;
        this.numDistribution[n] = this.numDistribution[n] + number;
    }

    public void addProb(int score, double prob) {
        int n = score - this.minScore;
        this.probDistribution[n] = this.probDistribution[n] + prob;
    }

    public double getProbability(int score) {
        int index = score >= this.minScore ? score - this.minScore : 0;
        return this.probDistribution[index];
    }

    public double getNumberRecs(int score) {
        int index = score >= this.minScore ? score - this.minScore : 0;
        return this.numDistribution[index];
    }

    public double getSpectralProbability(int score) {
        int minIndex;
        double specProb = 0.0;
        for (int t = minIndex = score >= this.minScore ? score - this.minScore : 0; t < this.probDistribution.length; ++t) {
            specProb += this.probDistribution[t];
        }
        if (specProb > 1.0) {
            specProb = 1.0;
        }
        return specProb;
    }

    public double getSpectralProbability(double specProbThreshold) {
        double specProb = 0.0;
        for (int t = this.probDistribution.length - 1; t >= 0 && specProb + this.probDistribution[t] <= specProbThreshold; --t) {
            specProb += this.probDistribution[t];
        }
        return specProb;
    }

    public double getNumEqualOrBetterPeptides(int score) {
        int minIndex;
        double numBetterPeptides = 0.0;
        for (int t = minIndex = score >= this.minScore ? score - this.minScore : 0; t < this.numDistribution.length; ++t) {
            numBetterPeptides += this.numDistribution[t];
        }
        return numBetterPeptides;
    }

    public void addNumDist(ScoreDist otherDist, int scoreDiff) {
        this.addNumDist(otherDist, scoreDiff, 1);
    }

    public void addNumDist(ScoreDist otherDist, int scoreDiff, int coeff) {
        if (otherDist == null) {
            return;
        }
        for (int t = Math.max(otherDist.minScore, this.minScore - scoreDiff); t < otherDist.maxScore; ++t) {
            int n = t + scoreDiff - this.minScore;
            this.numDistribution[n] = this.numDistribution[n] + (double)coeff * otherDist.numDistribution[t - otherDist.minScore];
        }
    }

    public void addProbDist(ScoreDist otherDist, int scoreDiff, float aaProb) {
        if (otherDist == null) {
            return;
        }
        for (int t = Math.max(otherDist.minScore, this.minScore - scoreDiff); t < otherDist.maxScore; ++t) {
            double prob = otherDist.probDistribution[t - otherDist.minScore] * (double)aaProb;
            int n = t + scoreDiff - this.minScore;
            this.probDistribution[n] = this.probDistribution[n] + prob;
        }
    }

    public float getMeanScore() {
        double sumScores = 0.0;
        double sumNum = 0.0;
        for (int score = this.getMinScore(); score < this.getMaxScore(); ++score) {
            sumNum += this.getNumberRecs(score);
            sumScores += this.getNumberRecs(score) * (double)score;
        }
        return (float)(sumScores / sumNum);
    }

    public ScoreBound getPercentileRange(float percentile) {
        return null;
    }
}

