/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msgf;

import edu.ucsd.msjava.msgf.ScoredSpectrum;
import edu.ucsd.msjava.msutil.ActivationMethod;
import edu.ucsd.msjava.msutil.Matter;
import edu.ucsd.msjava.msutil.Peak;
import java.util.List;

public class ScoredSpectrumSum<T extends Matter>
implements ScoredSpectrum<T> {
    private List<ScoredSpectrum<T>> scoredSpecList;
    private final Peak precursor;
    private final ActivationMethod[] activationMethodArr;
    private final int[] scanNumArr;

    public ScoredSpectrumSum(List<ScoredSpectrum<T>> scoredSpecList) {
        this.scoredSpecList = scoredSpecList;
        this.scanNumArr = new int[scoredSpecList.size()];
        this.activationMethodArr = new ActivationMethod[scoredSpecList.size()];
        int i = 0;
        this.precursor = scoredSpecList.get(0).getPrecursorPeak();
        for (ScoredSpectrum<T> scoredSpec : scoredSpecList) {
            this.scanNumArr[i] = scoredSpec.getScanNumArr()[0];
            this.activationMethodArr[i] = scoredSpec.getActivationMethodArr()[0];
            ++i;
        }
    }

    @Override
    public int getNodeScore(T prefixResidueNode, T suffixResidueNode) {
        int sum = 0;
        for (ScoredSpectrum<T> scoredSpec : this.scoredSpecList) {
            sum += scoredSpec.getNodeScore(prefixResidueNode, suffixResidueNode);
        }
        return sum;
    }

    @Override
    public int getEdgeScore(T curNode, T prevNode, float theoMass) {
        int sum = 0;
        for (ScoredSpectrum<T> scoredSpec : this.scoredSpecList) {
            sum += scoredSpec.getEdgeScore(curNode, prevNode, theoMass);
        }
        return sum;
    }

    @Override
    public boolean getMainIonDirection() {
        return false;
    }

    @Override
    public Peak getPrecursorPeak() {
        return this.precursor;
    }

    @Override
    public float getNodeScore(T node, boolean isPrefix) {
        float sum = 0.0f;
        for (ScoredSpectrum<T> scoredSpec : this.scoredSpecList) {
            sum += scoredSpec.getNodeScore(node, isPrefix);
        }
        return sum;
    }

    @Override
    public ActivationMethod[] getActivationMethodArr() {
        return this.activationMethodArr;
    }

    @Override
    public int[] getScanNumArr() {
        return this.scanNumArr;
    }
}

