/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msgf.analysis;

import edu.ucsd.msjava.msutil.Pair;
import edu.ucsd.msjava.msutil.ScoredString;
import edu.ucsd.msjava.parser.BufferedLineReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;

public class ROCGenerator {
    public static final float FDR_REPORT_THRESHOLD = 0.1f;

    public static void main(String[] argv) {
        File targetFile = null;
        int scoreCol = -1;
        String identifier = null;
        boolean isGreaterBetter = false;
        boolean hasHeader = true;
        File decoyFile = null;
        String delimiter = "\t";
        int pepCol = -1;
        int scanNumCol = -1;
        boolean isConcatenated = false;
        int dbCol = -1;
        String decoyPrefix = "XXX";
        ArrayList<Pair<Integer, String>> reqStrList = null;
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equalsIgnoreCase("-i")) {
                identifier = argv[i + 1];
                i += 2;
                continue;
            }
            if (argv[i].equalsIgnoreCase("-f")) {
                if (i + 2 >= argv.length) {
                    ROCGenerator.printUsageAndExit("Invalid parameter: " + argv[i]);
                }
                if (!(targetFile = new File(argv[i + 1])).exists()) {
                    ROCGenerator.printUsageAndExit(argv[i + 1] + " doesn't exist.");
                } else if (!targetFile.isFile()) {
                    ROCGenerator.printUsageAndExit(argv[i + 1] + " is not a file.");
                }
                if (i + 3 < argv.length && !argv[i + 3].startsWith("-")) {
                    dbCol = Integer.parseInt(argv[i + 2]);
                    decoyPrefix = argv[i + 3];
                    isConcatenated = true;
                    i += 4;
                    continue;
                }
                decoyFile = new File(argv[i + 2]);
                if (!decoyFile.exists()) {
                    ROCGenerator.printUsageAndExit(argv[i + 2] + " doesn't exist.");
                } else if (!decoyFile.isFile()) {
                    ROCGenerator.printUsageAndExit(argv[i + 2] + " is not a file.");
                }
                isConcatenated = false;
                i += 3;
                continue;
            }
            if (argv[i].equalsIgnoreCase("-s")) {
                if (i + 2 >= argv.length) {
                    ROCGenerator.printUsageAndExit("Invalid parameter: " + argv[i]);
                }
                try {
                    scoreCol = Integer.parseInt(argv[i + 1]);
                }
                catch (NumberFormatException e) {
                    ROCGenerator.printUsageAndExit("Invalid scoreCol: " + argv[i + 1]);
                }
                isGreaterBetter = argv[i + 2].equalsIgnoreCase("1");
                i += 3;
                continue;
            }
            if (argv[i].equalsIgnoreCase("-h")) {
                if (argv[i + 1].equalsIgnoreCase("0")) {
                    hasHeader = false;
                }
                i += 2;
                continue;
            }
            if (argv[i].equalsIgnoreCase("-delim")) {
                if (i + 1 >= argv.length) {
                    ROCGenerator.printUsageAndExit("Invalid parameter: " + argv[i]);
                }
                delimiter = argv[i + 1];
                i += 2;
                continue;
            }
            if (argv[i].equalsIgnoreCase("-p")) {
                if (i + 1 >= argv.length) {
                    ROCGenerator.printUsageAndExit("Invalid parameter: " + argv[i]);
                }
                try {
                    pepCol = Integer.parseInt(argv[i + 1]);
                }
                catch (NumberFormatException e) {
                    ROCGenerator.printUsageAndExit("Invalid pepCol: " + argv[i + 1]);
                }
                i += 2;
                continue;
            }
            if (argv[i].equalsIgnoreCase("-n")) {
                if (i + 1 >= argv.length) {
                    ROCGenerator.printUsageAndExit("Invalid parameter: " + argv[i]);
                }
                try {
                    scanNumCol = Integer.parseInt(argv[i + 1]);
                }
                catch (NumberFormatException e) {
                    ROCGenerator.printUsageAndExit("Invalid pepCol: " + argv[i + 1]);
                }
                i += 2;
                continue;
            }
            if (argv[i].equalsIgnoreCase("-m")) {
                String[] token;
                if (reqStrList == null) {
                    reqStrList = new ArrayList<Pair<Integer, String>>();
                }
                int matchCol = -1;
                if (i + 2 >= argv.length) {
                    ROCGenerator.printUsageAndExit("Invalid parameter: " + argv[i]);
                }
                try {
                    matchCol = Integer.parseInt(argv[i + 1]);
                }
                catch (NumberFormatException e) {
                    ROCGenerator.printUsageAndExit("Invalid matchCol: " + argv[i + 1]);
                }
                for (String requiredStr : token = argv[i + 2].split(",")) {
                    reqStrList.add(new Pair<Integer, String>(matchCol, requiredStr));
                }
                i += 3;
                continue;
            }
            if (argv[i].equalsIgnoreCase("-decoyprefix")) {
                if (i + 1 >= argv.length) {
                    ROCGenerator.printUsageAndExit("Invalid parameter: " + argv[i]);
                }
                decoyPrefix = argv[i + 1];
                i += 2;
                continue;
            }
            ROCGenerator.printUsageAndExit("Invalid parameter");
        }
        if (targetFile == null) {
            ROCGenerator.printUsageAndExit("Target is missing!");
        }
        if (scoreCol < 0) {
            ROCGenerator.printUsageAndExit("scoreCol is missing or Invalid!");
        }
        ROCGenerator.printROCCurve(identifier, targetFile, decoyFile, scoreCol, isGreaterBetter, delimiter, scanNumCol, pepCol, reqStrList, isConcatenated, hasHeader, dbCol, decoyPrefix);
    }

    public static void printUsageAndExit(String message) {
        System.err.println(message);
        System.out.print("usage: java ROCGenerator \n\t -f resultFileName dbCol decoyPrefix or -f targetFileName decoyFileName\n\t -s scoreCol 0/1 (0: smaller better, 1: greater better)\n\t [-delim delimiter] (default: \\t)\n\t [-p pepCol] (if specified, the peptide level FDRs will be calculated)\n\t [-n scanNumCol] (if specified, only best score per spectrum will be considered)\n\t [-m colNum keyword (the column 'colNum' must contain 'keyword'. If 'keyword' is delimited by '|' (e.g. A,B,C), then at least one must be matched.)]\n\t [-h 0/1] (0: no header, 1: header (default))\n\t [-i identifier] (to generate a Matlab code for ROC curves)\n\t [-decoyPrefix DecoyPrefixName] (default: XXX)\n");
        System.exit(-1);
    }

    public static void printROCCurve(String identifier, File targetFile, File decoyFile, int scoreCol, boolean isGreaterBetter, String delimiter, int scanNumCol, int pepCol, ArrayList<Pair<Integer, String>> reqStrList, boolean isConcatenated, boolean hasHeader, int dbCol, String decoyPrefix) {
        ArrayList<Float> target = null;
        ArrayList<Float> decoy = null;
        if (dbCol >= 0) {
            target = ROCGenerator.getScoreList(ROCGenerator.getScoredStringList(targetFile, scoreCol, isGreaterBetter, delimiter, scanNumCol, pepCol, reqStrList, hasHeader, dbCol, decoyPrefix, true));
            decoy = ROCGenerator.getScoreList(ROCGenerator.getScoredStringList(targetFile, scoreCol, isGreaterBetter, delimiter, scanNumCol, pepCol, reqStrList, hasHeader, dbCol, decoyPrefix, false));
        } else {
            target = ROCGenerator.getScoreList(ROCGenerator.getScoredStringList(targetFile, scoreCol, isGreaterBetter, delimiter, scanNumCol, pepCol, reqStrList, hasHeader, dbCol, decoyPrefix, true));
            decoy = ROCGenerator.getScoreList(ROCGenerator.getScoredStringList(decoyFile, scoreCol, isGreaterBetter, delimiter, scanNumCol, pepCol, reqStrList, hasHeader, dbCol, decoyPrefix, true));
        }
        ROCGenerator.printROCCurve(identifier, target, decoy, isGreaterBetter, isConcatenated);
    }

    private static ArrayList<Float> getScoreList(ArrayList<ScoredString> list) {
        ArrayList<Float> scoreList = new ArrayList<Float>();
        for (ScoredString s : list) {
            scoreList.add(Float.valueOf(s.getScore()));
        }
        return scoreList;
    }

    private static ArrayList<Float> getScoreList(Hashtable<String, Float> table) {
        ArrayList<Float> list = new ArrayList<Float>();
        for (Map.Entry<String, Float> entry : table.entrySet()) {
            list.add(entry.getValue());
        }
        return list;
    }

    private static ArrayList<ScoredString> getScoredStringList(File file, int scoreCol, boolean isGreaterBetter, String delimiter, int scanNumCol, int pepCol, ArrayList<Pair<Integer, String>> reqStrList, boolean hasHeader, int dbCol, String decoyPrefix, boolean isTarget) {
        String s;
        ArrayList<ScoredString> list = new ArrayList<ScoredString>();
        BufferedLineReader in = null;
        try {
            in = new BufferedLineReader(file.getPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (hasHeader) {
            in.readLine();
        }
        Hashtable<String, Float> prevScoreTable = new Hashtable<String, Float>();
        ArrayList<Float> scoreList = new ArrayList<Float>();
        String prevScanNum = "asdfasfdasdf";
        while ((s = in.readLine()) != null) {
            String[] token;
            if (s.startsWith("#") || scoreCol >= (token = s.split(delimiter)).length || pepCol >= token.length || dbCol >= token.length) continue;
            if (scanNumCol >= 0) {
                String scanNum = token[scanNumCol];
                if (scanNum.equalsIgnoreCase(prevScanNum)) continue;
                prevScanNum = scanNum;
            }
            if (dbCol >= 0 && (!isTarget ? !token[dbCol].startsWith(decoyPrefix) : token[dbCol].startsWith(decoyPrefix))) continue;
            if (reqStrList != null) {
                boolean containingReqSeq = false;
                for (Pair<Integer, String> pair : reqStrList) {
                    if (!token[pair.getFirst()].equalsIgnoreCase(pair.getSecond())) continue;
                    containingReqSeq = true;
                }
                if (!containingReqSeq) continue;
            }
            float score = Float.parseFloat(token[scoreCol]);
            if (pepCol >= 0) {
                Float prevScore;
                int lastDotIndex;
                String pep = token[pepCol];
                int firstDotIndex = pep.indexOf(46);
                if (firstDotIndex < (lastDotIndex = pep.lastIndexOf(46))) {
                    pep = pep.substring(firstDotIndex + 1, lastDotIndex);
                }
                if (!((prevScore = (Float)prevScoreTable.get(pep = pep.toUpperCase())) == null || isGreaterBetter && score > prevScore.floatValue()) && (isGreaterBetter || !(score < prevScore.floatValue()))) continue;
                prevScoreTable.put(pep, Float.valueOf(score));
                continue;
            }
            scoreList.add(Float.valueOf(score));
        }
        if (pepCol >= 0) {
            for (Map.Entry entry : prevScoreTable.entrySet()) {
                list.add(new ScoredString((String)entry.getKey(), (Float)entry.getValue()));
            }
        } else {
            for (Float score : scoreList) {
                list.add(new ScoredString(null, score));
            }
        }
        return list;
    }

    public static TreeMap<Float, Float> printROCCurve(String identifier, ArrayList<Float> target, ArrayList<Float> decoy, boolean isGreaterBetter, boolean isConcatenated) {
        TreeMap<Float, Float> fdrMap = new TreeMap<Float, Float>();
        float[] fdrInterested = new float[]{0.01f};
        if (!isGreaterBetter) {
            Collections.sort(target);
            Collections.sort(decoy);
        } else {
            Collections.sort(target, Collections.reverseOrder());
            Collections.sort(decoy, Collections.reverseOrder());
        }
        ArrayList<Pair<Float, Integer>> curve = new ArrayList<Pair<Float, Integer>>();
        ArrayList<Float> threshold = new ArrayList<Float>();
        float prevFDR = -1.0f;
        int prevNumber = -1;
        int targetIndex = 0;
        float[] fdrToBeReported = new float[fdrInterested.length];
        float[] thresholds = new float[fdrInterested.length];
        int[] numTargetMatches = new int[fdrInterested.length];
        float prevDecoyScore = Float.MIN_VALUE;
        for (int decoyIndex = 0; decoyIndex < decoy.size(); ++decoyIndex) {
            float decoyScore = decoy.get(decoyIndex).floatValue();
            if (decoyScore == prevDecoyScore) continue;
            prevDecoyScore = decoyScore;
            if (isGreaterBetter) {
                while (targetIndex < target.size() && target.get(targetIndex).floatValue() > decoyScore) {
                    ++targetIndex;
                }
            } else {
                while (targetIndex < target.size() && target.get(targetIndex).floatValue() < decoyScore) {
                    ++targetIndex;
                }
            }
            if (targetIndex <= 0) continue;
            float fdr = !isConcatenated ? (float)decoyIndex / (float)targetIndex : (float)(2 * decoyIndex) / (float)targetIndex;
            fdrMap.put(Float.valueOf(decoyScore), Float.valueOf(fdr));
            if (fdr > prevFDR && targetIndex > prevNumber && fdr <= 0.1f) {
                curve.add(new Pair<Float, Integer>(Float.valueOf(fdr), targetIndex));
                threshold.add(Float.valueOf(decoyScore));
                prevFDR = fdr;
                prevNumber = targetIndex;
            }
            for (int i = 0; i < fdrInterested.length; ++i) {
                if (fdr > fdrInterested[i] || targetIndex <= numTargetMatches[i]) continue;
                fdrToBeReported[i] = fdr;
                thresholds[i] = decoyScore;
                numTargetMatches[i] = targetIndex;
            }
        }
        if (curve.size() > 0) {
            int i;
            System.out.print(identifier + "_FDR=[" + ((Pair)curve.get(0)).getFirst());
            for (i = 1; i < curve.size(); ++i) {
                System.out.print("," + ((Pair)curve.get(i)).getFirst());
            }
            System.out.println("];");
            System.out.print(identifier + "_NUM=[" + ((Pair)curve.get(0)).getSecond());
            for (i = 1; i < curve.size(); ++i) {
                System.out.print("," + ((Pair)curve.get(i)).getSecond());
            }
            System.out.println("];");
            System.out.print(identifier + "_THR=[" + threshold.get(0));
            for (i = 1; i < threshold.size(); ++i) {
                System.out.print("," + threshold.get(i));
            }
            System.out.println("];");
            for (i = 0; i < fdrInterested.length; ++i) {
                System.out.println("%" + fdrToBeReported[i] + " " + thresholds[i] + " " + numTargetMatches[i]);
            }
        }
        return fdrMap;
    }
}

