/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msgf2d;

import edu.ucsd.msjava.msgf2d.ScoreBound2D;

public class BacktrackPointer2D
extends ScoreBound2D {
    private int[][] backtrackPointer;
    private int curScore1;
    private int curScore2;

    public BacktrackPointer2D(ScoreBound2D scoreBound, int curScore1, int curScore2) {
        super(scoreBound);
        this.curScore1 = curScore1;
        this.curScore2 = curScore2;
        this.backtrackPointer = new int[this.scoreBound1.getRange()][this.scoreBound2.getRange()];
    }

    public int getCurScore1() {
        return this.curScore1;
    }

    public int getCurScore2() {
        return this.curScore2;
    }

    public void setBacktrack(int score1, int score2, int aaIndex) {
        int[] nArray = this.backtrackPointer[score1 - this.scoreBound1.getMinScore()];
        int n = score2 - this.scoreBound2.getMinScore();
        nArray[n] = nArray[n] | 1 << aaIndex;
    }

    public int getBacktrackPointers(int score1, int score2) {
        return this.backtrackPointer[score1 - this.scoreBound1.getMinScore()][score2 - this.scoreBound2.getMinScore()];
    }

    public boolean isSet(int score1, int score2, int aaIndex) {
        int mask = 1 << aaIndex;
        return (this.backtrackPointer[score1 - this.scoreBound1.getMinScore()][score2 - this.scoreBound2.getMinScore()] & mask) != 0;
    }

    public void addBacktrackPointers(BacktrackPointer2D prevPointer, int aaIndex) {
        for (int t1 = Math.max(prevPointer.scoreBound1.getMinScore(), this.scoreBound1.getMinScore() - this.curScore1); t1 < prevPointer.scoreBound1.getMaxScore(); ++t1) {
            for (int t2 = Math.max(prevPointer.scoreBound2.getMinScore(), this.scoreBound2.getMinScore() - this.curScore2); t2 < prevPointer.scoreBound2.getMaxScore(); ++t2) {
                if (prevPointer.getBacktrackPointers(t1, t2) == 0) continue;
                this.setBacktrack(t1 + this.curScore1, t2 + this.curScore2, aaIndex);
            }
        }
    }
}

