/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msgf2d;

import edu.ucsd.msjava.msgf.DeNovoGraph;
import edu.ucsd.msjava.msgf.ScoredSpectrum;
import edu.ucsd.msjava.msgf2d.BacktrackPointer2D;
import edu.ucsd.msjava.msgf2d.BacktrackTable2D;
import edu.ucsd.msjava.msgf2d.ScoreBound2D;
import edu.ucsd.msjava.msgf2d.ScoreDist2D;
import edu.ucsd.msjava.msgf2d.ScoreDistMerged;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Annotation;
import edu.ucsd.msjava.msutil.Matter;
import edu.ucsd.msjava.msutil.Peptide;
import edu.ucsd.msjava.suffixarray.SuffixArray;
import java.util.ArrayList;
import java.util.Hashtable;

public class GeneratingFunction2D<T extends Matter> {
    private final ScoredSpectrum<T> scoredSpec1;
    private final ScoredSpectrum<T> scoredSpec2;
    private final DeNovoGraph<T> graph;
    private final AminoAcidSet aaSet;
    private boolean backtrack = true;
    private boolean calcNumber = true;
    private boolean calcProb = true;
    private int numScoreBinsPerNode = 1000;
    private ScoreDistMerged distribution = null;
    private BacktrackTable2D<T> backtrackTable = null;
    private Hashtable<T, ScoreDist2D> fwdTable;
    private Hashtable<T, Integer> srmScore1 = null;
    private Hashtable<T, Integer> srmScore2 = null;

    public GeneratingFunction2D(ScoredSpectrum<T> scoredSpec1, ScoredSpectrum<T> scoredSpec2, DeNovoGraph<T> graph) {
        this.scoredSpec1 = scoredSpec1;
        this.scoredSpec2 = scoredSpec2;
        this.graph = graph;
        this.aaSet = graph.getAASet();
    }

    public GeneratingFunction2D<T> doNotBacktrack() {
        this.backtrack = false;
        return this;
    }

    public GeneratingFunction2D<T> doNotCalcNumber() {
        this.calcNumber = false;
        return this;
    }

    public GeneratingFunction2D<T> doNotCalcProb() {
        this.calcProb = false;
        return this;
    }

    public GeneratingFunction2D<T> numScoreBinsPerNode(int numBins) {
        this.numScoreBinsPerNode = numBins;
        return this;
    }

    public boolean backtrack() {
        return this.backtrack;
    }

    public boolean calcNumber() {
        return this.calcNumber;
    }

    public boolean calcProb() {
        return this.calcProb;
    }

    public int getNumScoreBinsPerNode() {
        return this.numScoreBinsPerNode;
    }

    protected Hashtable<T, ScoreDist2D> getFwdTable() {
        return this.fwdTable;
    }

    protected DeNovoGraph<T> getGraph() {
        return this.graph;
    }

    protected ScoredSpectrum<T> getScoredSpectrum1() {
        return this.scoredSpec1;
    }

    protected ScoredSpectrum<T> getScoredSpectrum2() {
        return this.scoredSpec2;
    }

    protected BacktrackTable2D<T> getBacktrackTable() {
        return this.backtrackTable;
    }

    public AminoAcidSet getAASet() {
        return this.aaSet;
    }

    public float getScoreForDBScan(Annotation annotation) {
        int score1 = this.getScore1(annotation);
        int score2 = this.getScore2(annotation);
        float combinedScore = (float)(-Math.log(this.getSpectralProbability1(score1)) - Math.log(this.getSpectralProbability2(score2)));
        return combinedScore;
    }

    public int getScore1(Annotation annotation) {
        return -1;
    }

    public int getScore2(Annotation annotation) {
        return -1;
    }

    public int getScore1(Peptide pep) {
        return -1;
    }

    public int getScore2(Peptide pep) {
        return -1;
    }

    public int getMaxScore1() {
        return this.distribution.getMaxScore1();
    }

    public int getMaxScore2() {
        return this.distribution.getMaxScore2();
    }

    public int getMinScore1() {
        return this.distribution.getMinScore1();
    }

    public int getMinScore2() {
        return this.distribution.getMinScore2();
    }

    public float getSpectralProbability1(Peptide seq) {
        int score1 = this.getScore1(seq);
        return this.distribution.getSpectralProbability1(score1);
    }

    public float getSpectralProbability1(int score1) {
        return this.distribution.getSpectralProbability1(score1);
    }

    public float getSpectralProbability2(Peptide seq) {
        int score2 = this.getScore2(seq);
        return this.distribution.getSpectralProbability2(score2);
    }

    public float getSpectralProbability2(int score2) {
        return this.distribution.getSpectralProbability2(score2);
    }

    public float getSpectralProbabilitySumScores(Peptide seq) {
        int score1 = this.getScore1(seq);
        int score2 = this.getScore2(seq);
        return this.distribution.getSpectralProbabilitySumScores(score1, score2);
    }

    public float getNumEqualBetterPeptidesSumScores(Peptide seq) {
        int score1 = this.getScore1(seq);
        int score2 = this.getScore2(seq);
        return this.distribution.getNumEqualOrBetterPeptidesSumScores(score1, score2);
    }

    public float getSpectralProbability(Peptide seq) {
        int score1 = this.getScore1(seq);
        int score2 = this.getScore2(seq);
        return this.distribution.getSpectralProbability(score1, score2);
    }

    public float getProbabilityAt(int score1, int score2) {
        return this.distribution.getProbabilityAt(score1, score2);
    }

    public float getNumRecsAt(int score1, int score2) {
        return this.distribution.getNumRecsAt(score1, score2);
    }

    public float getSpectralProbability(int score1, int score2) {
        return this.distribution.getSpectralProbability(score1, score2);
    }

    public float getProbBetterBoth(Peptide seq) {
        int score1 = this.getScore1(seq);
        int score2 = this.getScore2(seq);
        return this.distribution.getProbBetterBoth(score1, score2);
    }

    public float getProbBetterBoth(int score1, int score2) {
        return this.distribution.getProbBetterBoth(score1, score2);
    }

    public float getNumBetterBoth(Peptide seq) {
        int score1 = this.getScore1(seq);
        int score2 = this.getScore2(seq);
        return this.distribution.getNumBetterBoth(score1, score2);
    }

    public float getNumBetterBoth(int score1, int score2) {
        return this.distribution.getNumBetterBoth(score1, score2);
    }

    public float getNumEqualBetterPeptides(Peptide seq) {
        int score1 = this.getScore1(seq);
        int score2 = this.getScore2(seq);
        return this.distribution.getNumEqualOrBetterPeptides(score1, score2);
    }

    public float getNumEqualBetterPeptides1(Peptide seq) {
        return this.distribution.getNumEqualOrBetterPeptides1(this.getScore1(seq));
    }

    public float getNumEqualBetterPeptides2(Peptide seq) {
        return this.distribution.getNumEqualOrBetterPeptides2(this.getScore2(seq));
    }

    public float getNumEqualOrBetterPeptides(int score1, int score2) {
        return this.distribution.getNumEqualOrBetterPeptides(score1, score2);
    }

    public int getThresholdScore(float specProb) {
        return -1;
    }

    private void generateReconstructions(int score1, int score2, ArrayList<String> reconstructions, SuffixArray sa) {
        if (this.backtrackTable == null) {
            return;
        }
        for (Matter sink : this.graph.getSinkList()) {
            this.backtrackTable.getReconstructions(sink, score1, score2, "", reconstructions, sa);
        }
    }

    public String getOneReconstruction(int score1, int score2) {
        if (this.backtrackTable == null) {
            return null;
        }
        return this.backtrackTable.getOneReconstruction(this.graph.getPMNode(), score1, score2, "");
    }

    public ArrayList<String> getReconstructions(int score1, int score2) {
        ArrayList<String> reconstructions = new ArrayList<String>();
        this.generateReconstructions(score1, score2, reconstructions, null);
        return reconstructions;
    }

    public ArrayList<String> getReconstructionsEqualOrAboveScore(int score1, int score2) {
        ArrayList<String> reconstructions = new ArrayList<String>();
        for (int t1 = this.getMaxScore1() - 1; t1 >= score1; --t1) {
            for (int t2 = this.getMaxScore2() - 1; t2 >= score2; --t2) {
                this.generateReconstructions(t1, t2, reconstructions, null);
            }
        }
        return reconstructions;
    }

    public ArrayList<String> getDictionary(float specProbThreshold) {
        return null;
    }

    public ArrayList<String> getReconstructions(float specProbThreshold, float numRecsThreshold, boolean isNumInclusive, SuffixArray sa) {
        return null;
    }

    public void computeGeneratingFunction() {
        ScoreBound2D sourceBound = new ScoreBound2D(0, 1, 0, 1);
        ScoreDist2D source = new ScoreDist2D(sourceBound);
        if (this.calcNumber) {
            source.setNumber(0, 0, 1.0f);
        }
        if (this.calcProb) {
            source.setProb(0, 0, 1.0f);
        }
        this.fwdTable = new Hashtable();
        this.fwdTable.put(this.graph.getSource(), source);
        if (this.backtrack) {
            this.backtrackTable = new BacktrackTable2D<T>(this.graph, this.aaSet);
            BacktrackPointer2D sourcePointer = new BacktrackPointer2D(sourceBound, 0, 0);
            sourcePointer.setBacktrack(0, 0, 0);
            this.backtrackTable.put(this.graph.getSource(), sourcePointer);
        }
        ArrayList<T> intermediateNodeList = this.graph.getIntermediateNodeList();
        this.srmScore1 = new Hashtable();
        this.srmScore2 = new Hashtable();
        for (int i = 1; i < intermediateNodeList.size(); ++i) {
            Matter curNode;
            Matter srm = curNode = (Matter)intermediateNodeList.get(i);
            Matter prm = this.graph.getComplementNode(srm);
            int curScore1 = this.scoredSpec1.getNodeScore(prm, srm);
            this.srmScore1.put(curNode, curScore1);
            int curScore2 = this.scoredSpec2.getNodeScore(prm, srm);
            this.srmScore2.put(curNode, curScore2);
            this.setCurNode(curNode, curScore1, curScore2);
        }
        int minScore1 = Integer.MAX_VALUE;
        int minScore2 = Integer.MAX_VALUE;
        int maxScore1 = Integer.MIN_VALUE;
        int maxScore2 = Integer.MIN_VALUE;
        for (Matter curNode : this.graph.getSinkList()) {
            this.setCurNode(curNode, 0, 0);
            ScoreDist2D curDist = this.fwdTable.get(curNode);
            if (curDist == null) continue;
            if (curDist.getMinScore1() < minScore1) {
                minScore1 = curDist.getMinScore1();
            }
            if (curDist.getMinScore2() < minScore2) {
                minScore2 = curDist.getMinScore2();
            }
            if (curDist.getMaxScore1() > maxScore1) {
                maxScore1 = curDist.getMaxScore1();
            }
            if (curDist.getMaxScore2() <= maxScore2) continue;
            maxScore2 = curDist.getMaxScore2();
        }
        assert (maxScore1 > minScore1);
        assert (maxScore2 > minScore2);
        ScoreDist2D finalDist = new ScoreDist2D(minScore1, maxScore1, minScore2, maxScore2);
        for (Matter sinkNode : this.graph.getSinkList()) {
            if (this.calcNumber) {
                finalDist.addNumDist(this.fwdTable.get(sinkNode), 0, 0, 1);
            }
            if (!this.calcProb) continue;
            finalDist.addProbDist(this.fwdTable.get(sinkNode), 0, 0, 1.0f);
        }
        this.distribution = new ScoreDistMerged(finalDist);
    }

    private void setCurNode(T curNode, int curScore1, int curScore2) {
        int prevMinScore1 = Integer.MAX_VALUE;
        int prevMinScore2 = Integer.MAX_VALUE;
        int prevMaxScore1 = Integer.MIN_VALUE;
        int prevMaxScore2 = Integer.MIN_VALUE;
        for (DeNovoGraph.Edge<T> edge : this.graph.getEdges(curNode)) {
            T prevNode = edge.getPrevNode();
            ScoreDist2D prevDist = this.fwdTable.get(prevNode);
            if (prevDist == null) continue;
            if (prevDist.getMaxScore1() > prevMaxScore1) {
                prevMaxScore1 = prevDist.getMaxScore1();
            }
            if (prevDist.getMaxScore2() > prevMaxScore2) {
                prevMaxScore2 = prevDist.getMaxScore2();
            }
            if (prevDist.getMinScore1() < prevMinScore1) {
                prevMinScore1 = prevDist.getMinScore1();
            }
            if (prevDist.getMinScore2() >= prevMinScore2) continue;
            prevMinScore2 = prevDist.getMinScore2();
        }
        if (prevMinScore1 >= prevMaxScore1 || prevMinScore2 >= prevMaxScore2) {
            return;
        }
        if (prevMaxScore1 - prevMinScore1 > this.numScoreBinsPerNode) {
            prevMinScore1 = prevMaxScore1 - this.numScoreBinsPerNode;
        }
        if (prevMaxScore2 - prevMinScore2 > this.numScoreBinsPerNode) {
            prevMinScore2 = prevMaxScore2 - this.numScoreBinsPerNode;
        }
        ScoreBound2D curBound = new ScoreBound2D(prevMinScore1 + curScore1, prevMaxScore1 + curScore1, prevMinScore2 + curScore2, prevMaxScore2 + curScore2);
        ScoreDist2D curDist = new ScoreDist2D(curBound);
        BacktrackPointer2D backPointer = null;
        if (this.backtrack) {
            backPointer = new BacktrackPointer2D(curBound, curScore1, curScore2);
        }
        for (DeNovoGraph.Edge<T> edge : this.graph.getEdges(curNode)) {
            T prevNode = edge.getPrevNode();
            int edgeIndex = edge.getEdgeIndex();
            ScoreDist2D prevDist = this.fwdTable.get(prevNode);
            if (prevDist == null) continue;
            if (this.calcNumber) {
                curDist.addNumDist(prevDist, curScore1, curScore2, 1);
            }
            if (this.calcProb) {
                curDist.addProbDist(prevDist, curScore1, curScore2, edge.getEdgeProbability());
            }
            if (!this.backtrack) continue;
            BacktrackPointer2D prevPointer = (BacktrackPointer2D)this.backtrackTable.get(prevNode);
            backPointer.addBacktrackPointers(prevPointer, edgeIndex);
        }
        this.fwdTable.put(curNode, curDist);
        if (this.backtrack) {
            this.backtrackTable.put(curNode, backPointer);
        }
    }
}

