/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msscorer;

import edu.ucsd.msjava.msgf.NominalMass;
import edu.ucsd.msjava.msgf.ScoredSpectrum;
import edu.ucsd.msjava.msgf.ScoredSpectrumSum;
import edu.ucsd.msjava.msscorer.DBScanScorer;
import edu.ucsd.msjava.msscorer.NewScoredSpectrum;
import edu.ucsd.msjava.msscorer.SimpleDBSearchScorer;
import java.util.List;

public class DBScanScorerSum
extends ScoredSpectrumSum<NominalMass>
implements SimpleDBSearchScorer<NominalMass> {
    private DBScanScorer[] scorerArr;

    public DBScanScorerSum(List<ScoredSpectrum<NominalMass>> scoredSpecList, int peptideMass) {
        super(scoredSpecList);
        this.scorerArr = new DBScanScorer[scoredSpecList.size()];
        for (int i = 0; i < scoredSpecList.size(); ++i) {
            NewScoredSpectrum scoredSpec = (NewScoredSpectrum)scoredSpecList.get(i);
            this.scorerArr[i] = new DBScanScorer(scoredSpec, peptideMass);
        }
    }

    @Override
    public int getScore(double[] prefixMassArr, int[] nominalPrefixMassArr, int fromIndex, int toIndex, int numMods) {
        int sum = 0;
        for (DBScanScorer scorer : this.scorerArr) {
            sum += scorer.getScore(prefixMassArr, nominalPrefixMassArr, fromIndex, toIndex, numMods);
        }
        return sum;
    }

    @Override
    public int getEdgeScore(NominalMass curNode, NominalMass prevNode, float theoMass) {
        int sum = 0;
        for (DBScanScorer scoredSpec : this.scorerArr) {
            sum += scoredSpec.getEdgeScore(curNode, prevNode, theoMass);
        }
        return sum;
    }
}

