/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msscorer;

import edu.ucsd.msjava.msgf.NominalMass;
import edu.ucsd.msjava.msgf.ScoredSpectrum;
import edu.ucsd.msjava.msscorer.SimpleDBSearchScorer;
import edu.ucsd.msjava.msutil.ActivationMethod;
import edu.ucsd.msjava.msutil.Peak;

public class FastScorer
implements SimpleDBSearchScorer<NominalMass> {
    protected float[] prefixScore = null;
    protected float[] suffixScore = null;
    private boolean mainIonDirection;
    protected Peak precursor;
    protected ActivationMethod[] activationMethodArr;
    private int[] scanNumArr;

    public FastScorer(ScoredSpectrum<NominalMass> scoredSpec, int peptideMass) {
        this.prefixScore = new float[peptideMass];
        this.suffixScore = new float[peptideMass];
        for (int i = 0; i < this.prefixScore.length; ++i) {
            this.prefixScore[i] = Float.MIN_VALUE;
        }
        for (int nominalMass = 1; nominalMass < peptideMass; ++nominalMass) {
            NominalMass node = new NominalMass(nominalMass);
            this.prefixScore[nominalMass] = scoredSpec.getNodeScore(node, true);
            this.suffixScore[nominalMass] = scoredSpec.getNodeScore(node, false);
        }
        this.mainIonDirection = scoredSpec.getMainIonDirection();
        this.precursor = scoredSpec.getPrecursorPeak();
        this.activationMethodArr = scoredSpec.getActivationMethodArr();
        this.scanNumArr = scoredSpec.getScanNumArr();
    }

    @Override
    public Peak getPrecursorPeak() {
        return this.precursor;
    }

    @Override
    public ActivationMethod[] getActivationMethodArr() {
        return this.activationMethodArr;
    }

    public float getParentMass() {
        return this.precursor.getMass();
    }

    public float getPeptideMass() {
        return this.precursor.getMass() - 18.010565f;
    }

    public int getCharge() {
        return this.precursor.getCharge();
    }

    @Override
    public int getScore(double[] prefixMassArr, int[] nominalPrefixMassArr, int fromIndex, int toIndex, int numMods) {
        int score = 0;
        int peptideMass = nominalPrefixMassArr[toIndex - 1];
        for (int i = fromIndex; i < toIndex - 1; ++i) {
            int curScore;
            int prefixMass = nominalPrefixMassArr[i];
            int suffixMass = peptideMass - prefixMass;
            try {
                curScore = Math.round(this.prefixScore[prefixMass] + this.suffixScore[suffixMass]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                curScore = 0;
            }
            score += curScore;
        }
        return score += 0 * numMods;
    }

    @Override
    public int getNodeScore(NominalMass prefixMass, NominalMass suffixMass) {
        int preNormMass = prefixMass.getNominalMass();
        int sufNormMass = suffixMass.getNominalMass();
        if (preNormMass >= this.prefixScore.length || sufNormMass >= this.suffixScore.length || preNormMass < 0 || sufNormMass < 0) {
            return 0;
        }
        return Math.round(this.prefixScore[prefixMass.getNominalMass()] + this.suffixScore[suffixMass.getNominalMass()]);
    }

    @Override
    public int getEdgeScore(NominalMass curNode, NominalMass prevNode, float theoMass) {
        return 0;
    }

    @Override
    public boolean getMainIonDirection() {
        return this.mainIonDirection;
    }

    @Override
    public float getNodeScore(NominalMass node, boolean isPrefix) {
        if (isPrefix) {
            return this.prefixScore[node.getNominalMass()];
        }
        return this.suffixScore[node.getNominalMass()];
    }

    @Override
    public int[] getScanNumArr() {
        return this.scanNumArr;
    }
}

