/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msscorer;

import edu.ucsd.msjava.msgf.ScoredSpectrum;
import edu.ucsd.msjava.msgf.Tolerance;
import edu.ucsd.msjava.msscorer.NewRankScorer;
import edu.ucsd.msjava.msscorer.Partition;
import edu.ucsd.msjava.msscorer.PrecursorOffsetFrequency;
import edu.ucsd.msjava.msutil.ActivationMethod;
import edu.ucsd.msjava.msutil.IonType;
import edu.ucsd.msjava.msutil.Matter;
import edu.ucsd.msjava.msutil.Pair;
import edu.ucsd.msjava.msutil.Peak;
import edu.ucsd.msjava.msutil.Spectrum;

public class NewScoredSpectrum<T extends Matter>
implements ScoredSpectrum<T> {
    private Spectrum spec;
    private NewRankScorer scorer;
    private Tolerance mme;
    private IonType[][] ionTypes;
    private final int charge;
    private final float parentMass;
    private final Peak precursor;
    private final int[] scanNumArr;
    private ActivationMethod[] activationMethodArr;
    private IonType mainIon;
    private Partition partition;
    private float probPeak;

    public NewScoredSpectrum(Spectrum spec, NewRankScorer scorer) {
        this.scorer = scorer;
        this.charge = spec.getCharge();
        this.parentMass = spec.getPrecursorMass();
        this.mme = scorer.mme;
        this.precursor = spec.getPrecursorPeak().clone();
        this.activationMethodArr = new ActivationMethod[1];
        this.activationMethodArr[0] = spec.getActivationMethod() != null ? spec.getActivationMethod() : scorer.getSpecDataType().getActivationMethod();
        this.scanNumArr = new int[1];
        this.scanNumArr[0] = spec.getScanNum();
        int numSegments = scorer.getNumSegments();
        this.ionTypes = new IonType[numSegments][];
        for (int seg = 0; seg < numSegments; ++seg) {
            this.ionTypes[seg] = scorer.getIonTypes(this.charge, this.parentMass, seg);
        }
        for (PrecursorOffsetFrequency off : scorer.getPrecursorOFF(spec.getCharge())) {
            spec.filterPrecursorPeaks(this.mme, off.getReducedCharge(), off.getOffset());
        }
        spec.setRanksOfPeaks();
        if (scorer.applyDeconvolution()) {
            spec = spec.getDeconvolutedSpectrum(scorer.deconvolutionErrorTolerance());
        }
        this.partition = scorer.getPartition(spec.getCharge(), spec.getPrecursorMass(), scorer.getNumSegments() - 1);
        this.mainIon = scorer.getMainIonType(this.partition);
        float approxNumBins = spec.getPeptideMass() / (scorer.getMME().getValue() * 2.0f);
        this.probPeak = spec.size() == 0 ? 1.0f / Math.max(approxNumBins, 1.0f) : (float)spec.size() / Math.max(approxNumBins, 1.0f);
        this.spec = spec;
    }

    @Override
    public Peak getPrecursorPeak() {
        return this.precursor;
    }

    @Override
    public ActivationMethod[] getActivationMethodArr() {
        return this.activationMethodArr;
    }

    @Override
    public int getNodeScore(T prm, T srm) {
        float prefScore = this.getNodeScore(prm, true);
        float sufScore = this.getNodeScore(srm, false);
        return Math.round(prefScore + sufScore);
    }

    @Override
    public int getEdgeScore(T curNode, T prevNode, float theoMass) {
        Float prevNodeMass;
        if (!this.scorer.supportEdgeScores()) {
            return 0;
        }
        int ionExistenceIndex = 0;
        float curNodeMass = this.getNodeMass(curNode);
        if (curNodeMass >= 0.0f) {
            ++ionExistenceIndex;
        }
        if ((prevNodeMass = Float.valueOf(this.getNodeMass(prevNode))).floatValue() >= 0.0f) {
            ionExistenceIndex += 2;
        }
        float edgeScore = this.scorer.getIonExistenceScore(this.partition, ionExistenceIndex, this.probPeak);
        if (ionExistenceIndex == 3) {
            edgeScore += this.scorer.getErrorScore(this.partition, curNodeMass - prevNodeMass.floatValue() - theoMass);
        }
        return Math.round(edgeScore);
    }

    public NewRankScorer getScorer() {
        return this.scorer;
    }

    public Partition getPartition() {
        return this.partition;
    }

    public float getProbPeak() {
        return this.probPeak;
    }

    public IonType getMainIon() {
        return this.mainIon;
    }

    @Override
    public boolean getMainIonDirection() {
        return this.mainIon.isPrefixIon();
    }

    public float getNodeMass(T node) {
        if (((Matter)node).getNominalMass() == 0) {
            return 0.0f;
        }
        float theoMass = this.mainIon.getMz(((Matter)node).getMass());
        Peak p = this.spec.getPeakByMass(theoMass, this.scorer.getMME());
        if (p != null) {
            return this.mainIon.getMass(p.getMz());
        }
        return -1.0f;
    }

    @Override
    public float getNodeScore(T node, boolean isPrefix) {
        return this.getNodeScore(((Matter)node).getMass(), isPrefix);
    }

    @Override
    public float getNodeScore(float nodeMass, boolean isPrefix) {
        float score = 0.0f;
        for (int segIndex = 0; segIndex < this.scorer.getNumSegments(); ++segIndex) {
            for (IonType ion : this.ionTypes[segIndex]) {
                float theoMass;
                if (isPrefix) {
                    if (!(ion instanceof IonType.PrefixIon)) continue;
                    theoMass = ion.getMz(nodeMass);
                } else {
                    if (!(ion instanceof IonType.SuffixIon)) continue;
                    theoMass = ion.getMz(nodeMass);
                }
                int segNum = this.scorer.getSegmentNum(theoMass, this.parentMass);
                if (segNum != segIndex) continue;
                Peak p = this.spec.getPeakByMass(theoMass, this.mme);
                Partition part = this.scorer.getPartition(this.charge, this.parentMass, segNum);
                if (p != null) {
                    score += this.scorer.getNodeScore(part, ion, p.getRank());
                    continue;
                }
                score += this.scorer.getMissingIonScore(part, ion);
            }
        }
        return score;
    }

    public float getExplainedIonCurrent(float residueMass, boolean isPrefix, Tolerance fragmentTolerance) {
        float explainedIonCurrent = 0.0f;
        for (int segIndex = 0; segIndex < this.scorer.getNumSegments(); ++segIndex) {
            for (IonType ion : this.ionTypes[segIndex]) {
                Peak p;
                float theoMass;
                if (isPrefix) {
                    if (!(ion instanceof IonType.PrefixIon)) continue;
                    theoMass = ion.getMz(residueMass);
                } else {
                    if (!(ion instanceof IonType.SuffixIon)) continue;
                    theoMass = ion.getMz(residueMass);
                }
                int segNum = this.scorer.getSegmentNum(theoMass, this.parentMass);
                if (segNum != segIndex || (p = this.spec.getPeakByMass(theoMass, fragmentTolerance)) == null) continue;
                explainedIonCurrent += p.getIntensity();
            }
        }
        return explainedIonCurrent;
    }

    public Pair<Float, Float> getMassErrorWithIntensity(float residueMass, boolean isPrefix, Tolerance fragmentTolerance) {
        Float error = null;
        float maxIntensity = 0.0f;
        for (int segIndex = 0; segIndex < this.scorer.getNumSegments(); ++segIndex) {
            for (IonType ion : this.ionTypes[segIndex]) {
                Peak p;
                float theoMass;
                if (ion.getCharge() != 1) continue;
                if (isPrefix) {
                    if (!(ion instanceof IonType.PrefixIon)) continue;
                    theoMass = ion.getMz(residueMass);
                } else {
                    if (!(ion instanceof IonType.SuffixIon)) continue;
                    theoMass = ion.getMz(residueMass);
                }
                int segNum = this.scorer.getSegmentNum(theoMass, this.parentMass);
                if (segNum != segIndex || (p = this.spec.getPeakByMass(theoMass, fragmentTolerance)) == null) continue;
                float err = (p.getMz() - theoMass) / theoMass * 1000000.0f;
                float intensity = p.getIntensity();
                if (!(intensity > maxIntensity)) continue;
                error = Float.valueOf(err);
                maxIntensity = intensity;
            }
        }
        if (error == null) {
            return null;
        }
        return new Pair<Object, Float>(error, Float.valueOf(maxIntensity));
    }

    public Pair<Float, Float> getNodeMassAndScore(float residueMass, boolean isPrefix) {
        Float nodeMass = null;
        float nodeScore = 0.0f;
        float curBestScore = 0.0f;
        for (int segIndex = 0; segIndex < this.scorer.getNumSegments(); ++segIndex) {
            for (IonType ion : this.ionTypes[segIndex]) {
                float theoMass;
                if (isPrefix) {
                    if (!(ion instanceof IonType.PrefixIon)) continue;
                    theoMass = ion.getMz(residueMass);
                } else {
                    if (!(ion instanceof IonType.SuffixIon)) continue;
                    theoMass = ion.getMz(residueMass);
                }
                int segNum = this.scorer.getSegmentNum(theoMass, this.parentMass);
                if (segNum != segIndex) continue;
                Peak p = this.spec.getPeakByMass(theoMass, this.mme);
                Partition part = this.scorer.getPartition(this.charge, this.parentMass, segNum);
                if (p != null) {
                    float score = this.scorer.getNodeScore(part, ion, p.getRank());
                    if (ion.getCharge() == 1 && score > curBestScore) {
                        nodeMass = Float.valueOf(ion.getMass(p.getMz()));
                        curBestScore = score;
                    }
                    nodeScore += score;
                    continue;
                }
                nodeScore += this.scorer.getMissingIonScore(part, ion);
            }
        }
        return new Pair<Object, Float>(nodeMass, Float.valueOf(nodeScore));
    }

    @Override
    public int[] getScanNumArr() {
        return this.scanNumArr;
    }
}

