/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msscorer;

import edu.ucsd.msjava.msscorer.NewRankScorer;
import edu.ucsd.msjava.msutil.ActivationMethod;
import edu.ucsd.msjava.msutil.Enzyme;
import edu.ucsd.msjava.msutil.InstrumentType;
import edu.ucsd.msjava.msutil.Protocol;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Hashtable;

public class NewScorerFactory {
    private static final String IONSTAT_RESOURCE_DIR = "ionstat/";
    private static Hashtable<SpecDataType, NewRankScorer> scorerTable = new Hashtable();

    private NewScorerFactory() {
    }

    @Deprecated
    public static NewRankScorer get(ActivationMethod method, Enzyme enzyme) {
        if (method != ActivationMethod.HCD) {
            return NewScorerFactory.get(method, InstrumentType.LOW_RESOLUTION_LTQ, enzyme, Protocol.STANDARD);
        }
        return NewScorerFactory.get(method, InstrumentType.HIGH_RESOLUTION_LTQ, enzyme, Protocol.STANDARD);
    }

    public static NewRankScorer get(ActivationMethod method, InstrumentType instType, Enzyme enzyme, Protocol protocol) {
        SpecDataType condition;
        NewRankScorer scorer;
        if (method == null || method == ActivationMethod.PQD) {
            method = ActivationMethod.CID;
        }
        if (enzyme == null) {
            enzyme = Enzyme.TRYPSIN;
        }
        if (instType == null) {
            instType = InstrumentType.LOW_RESOLUTION_LTQ;
        }
        if (method == ActivationMethod.HCD && instType != InstrumentType.HIGH_RESOLUTION_LTQ && instType != InstrumentType.QEXACTIVE) {
            instType = InstrumentType.QEXACTIVE;
        }
        if ((scorer = scorerTable.get(condition = new SpecDataType(method, instType, enzyme, protocol))) != null) {
            return scorer;
        }
        File userParamFile = Paths.get("params", condition + ".param").toFile();
        if (userParamFile.exists()) {
            System.out.println("Loading user param file: " + userParamFile.getName());
            scorer = new NewRankScorer(userParamFile.getPath());
            scorerTable.put(condition, scorer);
            return scorer;
        }
        InputStream is = ClassLoader.getSystemResourceAsStream(IONSTAT_RESOURCE_DIR + condition + ".param");
        if (is != null) {
            System.out.println("Loading built-in param file: " + condition + ".param");
            scorer = new NewRankScorer(new BufferedInputStream(is));
            scorerTable.put(condition, scorer);
            return scorer;
        }
        return NewScorerFactory.get(method, instType, enzyme);
    }

    private static NewRankScorer get(ActivationMethod method, InstrumentType instType, Enzyme enzyme) {
        if (method != null && method == ActivationMethod.FUSION) {
            return null;
        }
        SpecDataType condition = new SpecDataType(method, instType, enzyme);
        NewRankScorer scorer = scorerTable.get(condition);
        if (scorer == null) {
            InputStream is = ClassLoader.getSystemResourceAsStream(IONSTAT_RESOURCE_DIR + condition + ".param");
            if (is == null) {
                Enzyme alternativeEnzyme = enzyme.isCTerm() ? Enzyme.TRYPSIN : Enzyme.LysN;
                SpecDataType newCond = new SpecDataType(method, instType, alternativeEnzyme);
                is = ClassLoader.getSystemResourceAsStream(IONSTAT_RESOURCE_DIR + newCond + ".param");
                if (is == null) {
                    newCond = method == ActivationMethod.HCD && (instType == InstrumentType.TOF || instType == InstrumentType.HIGH_RESOLUTION_LTQ) && enzyme.isCTerm() ? new SpecDataType(ActivationMethod.CID, InstrumentType.TOF, Enzyme.TRYPSIN) : (method.isElectronBased() && enzyme.isCTerm() ? new SpecDataType(ActivationMethod.ETD, InstrumentType.LOW_RESOLUTION_LTQ, Enzyme.TRYPSIN) : (method.isElectronBased() && enzyme.isNTerm() ? new SpecDataType(ActivationMethod.ETD, InstrumentType.LOW_RESOLUTION_LTQ, Enzyme.LysN) : (!method.isElectronBased() && enzyme.isNTerm() ? new SpecDataType(ActivationMethod.CID, InstrumentType.LOW_RESOLUTION_LTQ, Enzyme.LysN) : new SpecDataType(ActivationMethod.CID, InstrumentType.LOW_RESOLUTION_LTQ, Enzyme.TRYPSIN))));
                    is = ClassLoader.getSystemResourceAsStream(IONSTAT_RESOURCE_DIR + newCond + ".param");
                }
            }
            assert (is != null) : "param file is missing!: " + method.getName() + " " + enzyme.getName();
            scorer = new NewRankScorer(new BufferedInputStream(is));
            assert (scorer != null) : "scorer is null:" + method.getName() + " " + enzyme.getName();
            scorerTable.put(condition, scorer);
        }
        return scorer;
    }

    public static void main(String[] argv) {
        for (ActivationMethod method : ActivationMethod.getAllRegisteredActivationMethods()) {
            if (method == ActivationMethod.FUSION || method == ActivationMethod.ASWRITTEN) continue;
            for (InstrumentType inst : InstrumentType.getAllRegisteredInstrumentTypes()) {
                for (Enzyme enzyme : Enzyme.getAllRegisteredEnzymes()) {
                    for (Protocol protocol : Protocol.getAllRegisteredProtocols()) {
                        NewRankScorer scorer = NewScorerFactory.get(method, inst, enzyme, protocol);
                        System.out.print(method.getName() + "_" + inst.getName() + "_" + enzyme.getName() + "_" + protocol.getName() + " -> ");
                        if (scorer != null) {
                            System.out.println(scorer.getSpecDataType());
                            continue;
                        }
                        System.err.println("Null!");
                        System.exit(-1);
                    }
                }
            }
        }
    }

    public static class SpecDataType {
        private ActivationMethod method;
        private InstrumentType instType;
        private Enzyme enzyme;
        private Protocol protocol;

        public SpecDataType(ActivationMethod method, InstrumentType instType, Enzyme enzyme) {
            this(method, instType, enzyme, Protocol.STANDARD);
        }

        public SpecDataType(ActivationMethod method, InstrumentType instType, Enzyme enzyme, Protocol protocol) {
            this.method = method;
            this.instType = instType;
            this.enzyme = enzyme;
            this.protocol = protocol;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SpecDataType) {
                SpecDataType other = (SpecDataType)obj;
                if (this.method == other.method && this.instType == other.instType && this.enzyme == other.enzyme && this.protocol == other.protocol) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.method.hashCode() * (this.enzyme == null ? 1 : this.enzyme.hashCode()) * this.instType.hashCode() * (this.protocol == null ? 1 : this.protocol.hashCode());
        }

        public String toString() {
            if (this.protocol == Protocol.STANDARD) {
                return this.method.getName() + "_" + this.instType.getName() + "_" + (this.enzyme == null ? "null" : this.enzyme.getName());
            }
            return this.method.getName() + "_" + this.instType.getName() + "_" + (this.enzyme == null ? "null" : this.enzyme.getName()) + "_" + this.protocol.getName();
        }

        public ActivationMethod getActivationMethod() {
            return this.method;
        }

        public InstrumentType getInstrumentType() {
            return this.instType;
        }

        public Enzyme getEnzyme() {
            return this.enzyme;
        }

        public Protocol getProtocol() {
            return this.protocol;
        }
    }
}

