/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msscorer;

import edu.ucsd.msjava.msgf.Tolerance;
import java.util.ArrayList;

public class PrecursorOffsetFrequency
implements Comparable<PrecursorOffsetFrequency> {
    private int reducedCharge;
    private float offset;
    private float frequency;
    private Tolerance tolerance;

    public PrecursorOffsetFrequency(int reducedCharge, float offset, float frequency) {
        this.reducedCharge = reducedCharge;
        this.offset = offset;
        this.frequency = frequency;
        this.tolerance = new Tolerance(0.5f);
    }

    public PrecursorOffsetFrequency tolerance(Tolerance tolerance) {
        this.tolerance = tolerance;
        return this;
    }

    public int getReducedCharge() {
        return this.reducedCharge;
    }

    public void setReducedCharge(int reducedCharge) {
        this.reducedCharge = reducedCharge;
    }

    public float getOffset() {
        return this.offset;
    }

    public void setOffset(float offset) {
        this.offset = offset;
    }

    public float getFrequency() {
        return this.frequency;
    }

    public void setFrequency(float probability) {
        this.frequency = probability;
    }

    public Tolerance getTolerance() {
        return this.tolerance;
    }

    @Override
    public int compareTo(PrecursorOffsetFrequency o) {
        return new Float(this.frequency).compareTo(new Float(o.frequency));
    }

    public static ArrayList<PrecursorOffsetFrequency> getClusteredOFF(ArrayList<PrecursorOffsetFrequency> offList, float granularity) {
        ArrayList<PrecursorOffsetFrequency> clusteredOFF = new ArrayList<PrecursorOffsetFrequency>();
        if (offList == null) {
            return null;
        }
        if (offList.size() == 0) {
            return clusteredOFF;
        }
        PrecursorOffsetFrequency prevOFF = offList.get(0);
        int clusterStartIndex = 0;
        float clusterFreq = prevOFF.getFrequency();
        int reducedCharge = prevOFF.getReducedCharge();
        for (int i = 1; i < offList.size(); ++i) {
            PrecursorOffsetFrequency off = offList.get(i);
            if (Math.abs(off.getOffset() - prevOFF.getOffset() - granularity) < granularity * 0.1f) {
                clusterFreq += off.getFrequency();
            } else {
                float offset = (offList.get(clusterStartIndex).getOffset() + offList.get(i - 1).getOffset()) / 2.0f;
                float tolDa = granularity / 2.0f * (float)(i - clusterStartIndex);
                clusteredOFF.add(new PrecursorOffsetFrequency(reducedCharge, offset, clusterFreq).tolerance(new Tolerance(tolDa)));
                clusterStartIndex = i;
                clusterFreq = off.getFrequency();
            }
            prevOFF = off;
        }
        float offset = offList.get(clusterStartIndex).getOffset() + offList.get(offList.size() - 1).getOffset() / 2.0f;
        float tolDa = granularity / 2.0f * (float)(offList.size() - clusterStartIndex);
        clusteredOFF.add(new PrecursorOffsetFrequency(reducedCharge, offset, clusterFreq).tolerance(new Tolerance(tolDa)));
        return clusteredOFF;
    }
}

