/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msscorer;

import edu.ucsd.msjava.msgf.Histogram;
import edu.ucsd.msjava.msgf.NominalMass;
import edu.ucsd.msjava.msgf.Tolerance;
import edu.ucsd.msjava.msscorer.FragmentOffsetFrequency;
import edu.ucsd.msjava.msscorer.NewRankScorer;
import edu.ucsd.msjava.msscorer.NewScorerFactory;
import edu.ucsd.msjava.msscorer.Partition;
import edu.ucsd.msjava.msscorer.PrecursorOffsetFrequency;
import edu.ucsd.msjava.msutil.ActivationMethod;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Composition;
import edu.ucsd.msjava.msutil.Enzyme;
import edu.ucsd.msjava.msutil.InstrumentType;
import edu.ucsd.msjava.msutil.IonType;
import edu.ucsd.msjava.msutil.Pair;
import edu.ucsd.msjava.msutil.Peak;
import edu.ucsd.msjava.msutil.Peptide;
import edu.ucsd.msjava.msutil.Protocol;
import edu.ucsd.msjava.msutil.SpectraContainer;
import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.parser.MgfSpectrumParser;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.TreeMap;
import java.util.TreeSet;

public class ScoringParameterGenerator
extends NewRankScorer {
    private static final float MIN_OFFSET_MASS = -120.0f;
    private static final float MAX_OFFSET_MASS = 38.0f;
    private static final float MIN_PRECURSOR_OFFSET = -300.0f;
    private static final float MAX_PRECURSOR_OFFSET = 30.0f;
    private static final int MIN_NUM_SPECTRA_PER_PARTITION = 400;
    private static final int MIN_NUM_SPECTRA_FOR_PRECURSOR_OFF = 150;
    private static final float MIN_PRECURSOR_OFFSET_PROBABILITY = 0.15f;
    private static final float MIN_ION_OFFSET_PROBABILITY = 0.15f;
    private static final int MAX_RANK = 150;
    private static final int NUM_SEGMENTS_PER_SPECTRUM = 2;
    private static final int[] smoothingRanks = new int[]{3, 5, 10, 20, 50, Integer.MAX_VALUE};
    private static final int[] smoothingWindowSize = new int[]{0, 1, 2, 3, 4, 5};
    private static final int NUM_NOISE_IONS = 10;
    protected static final int MAX_CHARGE = 20;
    private SpectraContainer specContainer;

    public static void main(String[] argv) {
        File specFile = null;
        File outputFile = null;
        boolean isText = false;
        AminoAcidSet aaSet = AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys();
        int numSpecsPerPeptide = 1;
        int errorScalingFactor = 10;
        ActivationMethod activationMethod = null;
        InstrumentType instType = null;
        Enzyme enzyme = null;
        for (int i = 0; i < argv.length; i += 2) {
            if (!argv[i].startsWith("-") || i + 1 >= argv.length) {
                ScoringParameterGenerator.printUsageAndExit("Invalid parameter!");
            }
            if (argv[i].equalsIgnoreCase("-i")) {
                int posDot;
                specFile = new File(argv[i + 1]);
                if (!specFile.exists()) {
                    ScoringParameterGenerator.printUsageAndExit(argv[i + 1] + " doesn't exist.");
                }
                if ((posDot = specFile.getName().lastIndexOf(46)) >= 0) {
                    String extension = specFile.getName().substring(posDot);
                    if (extension.equalsIgnoreCase(".mgf")) continue;
                    ScoringParameterGenerator.printUsageAndExit("Invalid spectrum format: " + argv[i + 1]);
                    continue;
                }
                ScoringParameterGenerator.printUsageAndExit("Invalid spectrum format: " + argv[i + 1]);
                continue;
            }
            if (argv[i].equalsIgnoreCase("-o")) {
                outputFile = new File(argv[i + 1]);
                continue;
            }
            if (argv[i].equalsIgnoreCase("-t")) {
                outputFile = new File(argv[i + 1]);
                isText = true;
                continue;
            }
            if (argv[i].equalsIgnoreCase("-fixMod")) {
                if (argv[i + 1].equalsIgnoreCase("0")) {
                    aaSet = AminoAcidSet.getStandardAminoAcidSet();
                    continue;
                }
                if (argv[i + 1].equalsIgnoreCase("1")) {
                    aaSet = AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys();
                    continue;
                }
                if (argv[i + 1].equalsIgnoreCase("2")) {
                    aaSet = AminoAcidSet.getStandardAminoAcidSetWithFixedCarboxymethylatedCys();
                    continue;
                }
                ScoringParameterGenerator.printUsageAndExit("Invalid -fixMod parameter: " + argv[i + 1]);
                continue;
            }
            if (argv[i].equalsIgnoreCase("-pep")) {
                numSpecsPerPeptide = Integer.parseInt(argv[i + 1]);
                continue;
            }
            if (argv[i].equalsIgnoreCase("-err")) {
                errorScalingFactor = Integer.parseInt(argv[i + 1]);
                continue;
            }
            if (argv[i].equalsIgnoreCase("-m")) {
                if (argv[i + 1].equalsIgnoreCase("1")) {
                    activationMethod = ActivationMethod.CID;
                    continue;
                }
                if (argv[i + 1].equalsIgnoreCase("2")) {
                    activationMethod = ActivationMethod.ETD;
                    continue;
                }
                if (argv[i + 1].equalsIgnoreCase("3")) {
                    activationMethod = ActivationMethod.HCD;
                    continue;
                }
                if (argv[i + 1].equalsIgnoreCase("4")) {
                    activationMethod = ActivationMethod.UVPD;
                    continue;
                }
                ScoringParameterGenerator.printUsageAndExit("Invalid activation method: " + argv[i + 1]);
                continue;
            }
            if (argv[i].equalsIgnoreCase("-inst")) {
                if (argv[i + 1].equalsIgnoreCase("0")) {
                    instType = InstrumentType.LOW_RESOLUTION_LTQ;
                    continue;
                }
                if (argv[i + 1].equalsIgnoreCase("1")) {
                    instType = InstrumentType.TOF;
                    continue;
                }
                if (argv[i + 1].equalsIgnoreCase("2")) {
                    instType = InstrumentType.HIGH_RESOLUTION_LTQ;
                    continue;
                }
                ScoringParameterGenerator.printUsageAndExit("Invalid instrument type: " + argv[i + 1]);
                continue;
            }
            if (argv[i].equalsIgnoreCase("-e")) {
                if (argv[i + 1].equalsIgnoreCase("0")) {
                    enzyme = null;
                    continue;
                }
                if (argv[i + 1].equalsIgnoreCase("1")) {
                    enzyme = Enzyme.TRYPSIN;
                    continue;
                }
                if (argv[i + 1].equalsIgnoreCase("2")) {
                    enzyme = Enzyme.CHYMOTRYPSIN;
                    continue;
                }
                if (argv[i + 1].equalsIgnoreCase("3")) {
                    enzyme = Enzyme.LysC;
                    continue;
                }
                if (argv[i + 1].equalsIgnoreCase("4")) {
                    enzyme = Enzyme.LysN;
                    continue;
                }
                if (argv[i + 1].equalsIgnoreCase("5")) {
                    enzyme = Enzyme.GluC;
                    continue;
                }
                if (argv[i + 1].equalsIgnoreCase("6")) {
                    enzyme = Enzyme.ArgC;
                    continue;
                }
                if (argv[i + 1].equalsIgnoreCase("7")) {
                    enzyme = Enzyme.AspN;
                    continue;
                }
                ScoringParameterGenerator.printUsageAndExit("Invalid enzyme: " + argv[i + 1]);
                continue;
            }
            ScoringParameterGenerator.printUsageAndExit("Invalid parameters!");
        }
        if (specFile == null) {
            ScoringParameterGenerator.printUsageAndExit("missing annotatedMgfFileName!");
        }
        if (outputFile == null) {
            ScoringParameterGenerator.printUsageAndExit("missing outputFileName!");
        }
        if (activationMethod == null) {
            ScoringParameterGenerator.printUsageAndExit("missing activationMethod!");
        }
        if (instType == null) {
            ScoringParameterGenerator.printUsageAndExit("missing instrumentType!");
        }
        ScoringParameterGenerator.generateParameters(specFile, activationMethod, instType, enzyme, Protocol.AUTOMATIC, numSpecsPerPeptide, errorScalingFactor, outputFile, aaSet, isText, false);
    }

    public static void printUsageAndExit(String message) {
        System.err.println(message);
        System.out.println("usage: java -Xmx2000M -cp MSGF.jar msscorer.ScoringParameterGenerator\n\t-i annotatedMgfFileName (*.mgf)\n\t-o outputFileName (e.g. CID_Tryp.param)\n\t-m FragmentationMethodID (1: CID, 2: ETD, 3: HCD, 4: UVPD)\n\t-inst InstrumentID (0: Low-res LCQ/LTQ, 1: TOF , 2: High-res LTQ)\n\t-e EnzymeID (0: No enzyme, 1: Trypsin (Default), 2: Chymotrypsin, 3: Lys-C, 4: Lys-N, 5: Glu-C, 6: Arg-C, 7: Asp-N)\n\t[-fixMod 0/1/2] (0: NoCysteineProtection, 1: CarbamidomethyC (default), 2: CarboxymethylC)\n\t[-pep numPeptidesPerSpec]  (default: 1)\n\t[-err errorScalingFactor]  (default: 10)");
        System.exit(0);
    }

    public static void generateParameters(File specFile, ActivationMethod activationMethod, InstrumentType instType, Enzyme enzyme, Protocol protocol, int numSpecsPerPeptide, int errorScalingFactor, File outputFile, AminoAcidSet aaSet, boolean isText, boolean verbose) {
        SpectraContainer container = new SpectraContainer(specFile.getPath(), new MgfSpectrumParser().aaSet(aaSet));
        HashMap pepSpecMap = new HashMap();
        SpectraContainer specContOnePerPep = new SpectraContainer();
        for (Spectrum spec : container) {
            String pep = spec.getAnnotationStr() + ":" + spec.getCharge();
            if (pep == null || pep.length() <= 0) continue;
            ArrayList<Spectrum> specList = (ArrayList<Spectrum>)pepSpecMap.get(pep);
            if (specList == null) {
                specList = new ArrayList<Spectrum>();
                pepSpecMap.put(pep, specList);
            }
            if (specList.size() >= numSpecsPerPeptide) continue;
            specList.add(spec);
        }
        for (ArrayList specList : pepSpecMap.values()) {
            for (Spectrum spec : specList) {
                specContOnePerPep.add(spec);
            }
        }
        NewScorerFactory.SpecDataType dataType = new NewScorerFactory.SpecDataType(activationMethod, instType, enzyme, protocol);
        ScoringParameterGenerator gen = new ScoringParameterGenerator(specContOnePerPep, dataType);
        gen.tolerance(new Tolerance(0.50025165f));
        gen.partition(2);
        if (verbose) {
            System.out.println("Partition: " + gen.partitionSet.size());
        }
        gen.precursorOFF(0.15f);
        if (verbose) {
            System.out.println("PrecursorOFF Done.");
        }
        gen.filterPrecursorPeaks();
        if (verbose) {
            System.out.println("Filtering Done.");
        }
        gen.selectIonTypes(0.15f);
        if (verbose) {
            System.out.println("Ion types selected.");
        }
        gen.generateRankDist(150);
        if (verbose) {
            System.out.println("Rank distribution computed.");
        }
        gen.smoothing();
        if (verbose) {
            System.out.println("Smoothing complete.");
        }
        if (!isText) {
            gen.writeParameters(outputFile);
        } else {
            gen.writeParametersPlainText(outputFile);
        }
        if (verbose) {
            System.out.println("Writing Done.");
        }
    }

    public ScoringParameterGenerator(SpectraContainer specContainer, NewScorerFactory.SpecDataType dataType) {
        this.specContainer = specContainer;
        this.dataType = dataType;
    }

    public void partition(int numSegments) {
        this.numSegments = numSegments;
        this.chargeHist = new Histogram();
        this.partitionSet = new TreeSet();
        Hashtable<Integer, ArrayList<Float>> parentMassMap = new Hashtable<Integer, ArrayList<Float>>();
        for (Spectrum spec : this.specContainer) {
            int charge = spec.getCharge();
            if (charge <= 0) continue;
            this.chargeHist.add(charge);
            if (spec.getAnnotation() == null) continue;
            ArrayList<Float> precursorList = (ArrayList<Float>)parentMassMap.get(charge);
            if (precursorList == null) {
                precursorList = new ArrayList<Float>();
                parentMassMap.put(charge, precursorList);
            }
            precursorList.add(Float.valueOf(spec.getPrecursorMass()));
        }
        for (int c = ((Integer)this.chargeHist.minKey()).intValue(); c <= (Integer)this.chargeHist.maxKey(); ++c) {
            int numSpec;
            ArrayList parentMassList = (ArrayList)parentMassMap.get(c);
            if (parentMassList == null || (numSpec = parentMassList.size()) < Math.round(360.0f)) continue;
            Collections.sort(parentMassList);
            int bestSetSize = 0;
            int smallestRemainder = 400;
            for (int i = Math.round(360.0f); i <= Math.round(440.0f); ++i) {
                int remainder = numSpec % i;
                if (i - remainder < remainder) {
                    remainder = i - remainder;
                }
                if (remainder >= smallestRemainder && (remainder != smallestRemainder || Math.abs(400 - i) >= Math.abs(400 - bestSetSize))) continue;
                bestSetSize = i;
                smallestRemainder = remainder;
            }
            int num = 0;
            for (int i = 0; i == 0 || i < Math.round((float)numSpec / (float)bestSetSize); ++i) {
                int seg;
                if (num != 0) {
                    for (seg = 0; seg < numSegments; ++seg) {
                        this.partitionSet.add(new Partition(c, ((Float)parentMassList.get(num)).floatValue(), seg));
                    }
                } else {
                    for (seg = 0; seg < numSegments; ++seg) {
                        this.partitionSet.add(new Partition(c, 0.0f, seg));
                    }
                }
                num += bestSetSize;
            }
        }
    }

    private void precursorOFF(float minProbThreshold) {
        if (this.chargeHist == null) {
            assert (false) : "partition() must have been called before";
            return;
        }
        this.precursorOFFMap = new TreeMap();
        this.numPrecurOFF = 0;
        for (int charge = ((Integer)this.chargeHist.minKey()).intValue(); charge <= (Integer)this.chargeHist.maxKey(); ++charge) {
            int c;
            if (this.chargeHist.get(charge) < 150) continue;
            ArrayList<PrecursorOffsetFrequency> precursorOffsetList = new ArrayList<PrecursorOffsetFrequency>();
            int numSpecs = 0;
            Hashtable histList = new Hashtable();
            for (c = charge; c >= 2; --c) {
                histList.put(c, new Histogram());
            }
            for (Spectrum spec : this.specContainer) {
                if (spec.getAnnotation() == null || spec.getCharge() != charge) continue;
                ++numSpecs;
                spec = this.filter.apply(spec);
                float precursorNeutralMass = spec.getPrecursorMass();
                for (int c2 = charge; c2 >= 2; --c2) {
                    float precursorMz = (precursorNeutralMass + (float)c2 * (float)Composition.ChargeCarrierMass()) / (float)c2;
                    ArrayList<Peak> peakList = spec.getPeakListByMassRange(precursorMz + -300.0f / (float)c2 - this.mme.getToleranceAsDa(precursorMz + -300.0f / (float)c2) / 2.0f, precursorMz + 30.0f / (float)c2 + this.mme.getToleranceAsDa(precursorMz + 30.0f / (float)c2) / 2.0f);
                    int prevMassIndexDiff = Integer.MIN_VALUE;
                    for (Peak p : peakList) {
                        float peakMass = p.getMz();
                        int massIndexDiff = NominalMass.toNominalMass(peakMass - precursorMz);
                        if (massIndexDiff <= prevMassIndexDiff) continue;
                        ((Histogram)histList.get(c2)).add(massIndexDiff);
                        prevMassIndexDiff = massIndexDiff;
                    }
                }
            }
            for (c = charge; c >= 2; --c) {
                ArrayList keyList = new ArrayList(((Histogram)histList.get(c)).keySet());
                Collections.sort(keyList);
                for (Integer key : keyList) {
                    float prob = (float)((Histogram)histList.get(c)).get(key).intValue() / (float)numSpecs;
                    if (!(prob > minProbThreshold)) continue;
                    precursorOffsetList.add(new PrecursorOffsetFrequency(charge - c, NominalMass.getMassFromNominalMass(key), prob));
                }
            }
            this.precursorOFFMap.put(charge, precursorOffsetList);
            this.numPrecurOFF += precursorOffsetList.size();
        }
    }

    private void filterPrecursorPeaks() {
        if (this.precursorOFFMap == null) {
            return;
        }
        for (Spectrum spec : this.specContainer) {
            for (PrecursorOffsetFrequency off : this.getPrecursorOFF(spec.getCharge())) {
                spec.filterPrecursorPeaks(this.mme, off.getReducedCharge(), off.getOffset());
            }
        }
    }

    private Pair<Float, Float> getPrecursorMassRange(Partition partition) {
        float minParentMass = partition.getParentMass();
        float maxParentMass = Float.MAX_VALUE;
        Partition higherPartition = this.partitionSet.higher(partition);
        if (higherPartition != null && higherPartition.getCharge() == partition.getCharge() && higherPartition.getSegNum() == partition.getSegNum()) {
            maxParentMass = higherPartition.getParentMass();
        }
        return new Pair<Float, Float>(Float.valueOf(minParentMass), Float.valueOf(maxParentMass));
    }

    private void selectIonTypes(float minProbThreshold) {
        if (this.partitionSet == null) {
            assert (false) : "partition() must have been called before!";
            return;
        }
        this.fragOFFTable = new Hashtable();
        this.insignificantFragOFFTable = new Hashtable();
        for (Partition partition : this.partitionSet) {
            int charge = partition.getCharge();
            Pair<Float, Float> parentMassRange = this.getPrecursorMassRange(partition);
            int seg = partition.getSegNum();
            int numSpec = 0;
            Hashtable prefixIonFreq = new Hashtable();
            Hashtable suffixIonFreq = new Hashtable();
            for (int c = 1; c <= charge; ++c) {
                prefixIonFreq.put(c, new Histogram());
                suffixIonFreq.put(c, new Histogram());
            }
            int numCleavages = 0;
            for (Spectrum spec : this.specContainer) {
                float curParentMass;
                if (spec.getAnnotation() == null || spec.getCharge() != charge || (curParentMass = spec.getPrecursorMass()) < parentMassRange.getFirst().floatValue() || curParentMass >= parentMassRange.getSecond().floatValue()) continue;
                Peptide annotation = spec.getAnnotation();
                numCleavages += annotation.size() - 1;
                ++numSpec;
                spec = this.filter.apply(spec);
                for (int c = 1; c <= charge; ++c) {
                    for (int direction = 0; direction < 2; ++direction) {
                        double accurateMass = 0.0;
                        Hashtable ionFreq = null;
                        for (int i = 0; i < annotation.size() - 1; ++i) {
                            if (direction == 0) {
                                accurateMass += annotation.get(i).getAccurateMass();
                                ionFreq = prefixIonFreq;
                            } else if (direction == 1) {
                                accurateMass += annotation.get(annotation.size() - 1 - i).getAccurateMass();
                                ionFreq = suffixIonFreq;
                            }
                            float mass = (float)(accurateMass / (double)c);
                            ArrayList<Peak> peakList = spec.getPeakListByMassRange(mass + -120.0f / (float)c - this.mme.getToleranceAsDa(mass), mass + 38.0f / (float)c + this.mme.getToleranceAsDa(mass));
                            int prevIntOffset = Integer.MIN_VALUE;
                            for (Peak p : peakList) {
                                float offset;
                                int intOffset;
                                float peakMz = p.getMz();
                                int segNum = this.getSegmentNum(peakMz, curParentMass);
                                if (segNum != seg || (intOffset = NominalMass.toNominalMass(offset = peakMz - mass)) <= prevIntOffset) continue;
                                ((Histogram)ionFreq.get(c)).add(intOffset);
                                prevIntOffset = intOffset;
                            }
                        }
                    }
                }
            }
            float maxProb = 0.0f;
            int maxCharge = 0;
            int maxDirection = 0;
            float maxOffset = 0.0f;
            ArrayList<FragmentOffsetFrequency> fragmentOffsetFrequencyList = new ArrayList<FragmentOffsetFrequency>();
            ArrayList<FragmentOffsetFrequency> insignificantFragmentOffsetFrequencyList = new ArrayList<FragmentOffsetFrequency>();
            for (int c = 1; c <= charge; ++c) {
                for (int direction = 0; direction < 2; ++direction) {
                    ArrayList keyList = direction == 0 ? new ArrayList(((Histogram)prefixIonFreq.get(c)).keySet()) : new ArrayList(((Histogram)suffixIonFreq.get(c)).keySet());
                    Collections.sort(keyList);
                    for (Integer key : keyList) {
                        float offset = NominalMass.getMassFromNominalMass(key);
                        int freq = direction == 0 ? ((Histogram)prefixIonFreq.get(c)).get(key).intValue() : ((Histogram)suffixIonFreq.get(c)).get(key).intValue();
                        float prob = (float)freq / (float)numCleavages * (float)this.numSegments;
                        if (prob > maxProb) {
                            maxProb = prob;
                            maxCharge = c;
                            maxDirection = direction;
                            maxOffset = offset;
                        }
                        if (prob > minProbThreshold) {
                            if (direction == 0) {
                                fragmentOffsetFrequencyList.add(new FragmentOffsetFrequency(new IonType.PrefixIon(c, offset), prob));
                                continue;
                            }
                            fragmentOffsetFrequencyList.add(new FragmentOffsetFrequency(new IonType.SuffixIon(c, offset), prob));
                            continue;
                        }
                        if (direction == 0) {
                            insignificantFragmentOffsetFrequencyList.add(new FragmentOffsetFrequency(new IonType.PrefixIon(c, offset), prob));
                            continue;
                        }
                        insignificantFragmentOffsetFrequencyList.add(new FragmentOffsetFrequency(new IonType.SuffixIon(c, offset), prob));
                    }
                }
            }
            if (fragmentOffsetFrequencyList.size() == 0) {
                if (maxDirection == 0) {
                    fragmentOffsetFrequencyList.add(new FragmentOffsetFrequency(new IonType.PrefixIon(maxCharge, maxOffset), maxProb));
                } else {
                    fragmentOffsetFrequencyList.add(new FragmentOffsetFrequency(new IonType.SuffixIon(maxCharge, maxOffset), maxProb));
                }
            }
            Collections.sort(insignificantFragmentOffsetFrequencyList);
            ArrayList<FragmentOffsetFrequency> noiseOffsetFrequencyList = new ArrayList<FragmentOffsetFrequency>(10);
            int numNoise = 0;
            for (FragmentOffsetFrequency off : insignificantFragmentOffsetFrequencyList) {
                if (off.getIonType().getCharge() == 1) {
                    noiseOffsetFrequencyList.add(off);
                }
                if (++numNoise < 10) continue;
                break;
            }
            Collections.sort(fragmentOffsetFrequencyList, Collections.reverseOrder());
            this.fragOFFTable.put(partition, fragmentOffsetFrequencyList);
            this.insignificantFragOFFTable.put(partition, noiseOffsetFrequencyList);
        }
    }

    private void generateRankDist(int maxRank) {
        if (this.partitionSet == null) {
            assert (false) : "partition() must have been called!";
            return;
        }
        this.rankDistTable = new Hashtable();
        this.maxRank = maxRank;
        for (Partition partition : this.partitionSet) {
            int charge = partition.getCharge();
            IonType[] ionTypes = this.getIonTypes(partition);
            if (ionTypes == null || ionTypes.length == 0) continue;
            Pair<Float, Float> parentMassRange = this.getPrecursorMassRange(partition);
            int seg = partition.getSegNum();
            int numSpec = 0;
            Hashtable rankDist = new Hashtable();
            Hashtable<IonType, Float> rankDistMaxRank = new Hashtable<IonType, Float>();
            Hashtable<IonType, Float> rankDistUnexplained = new Hashtable<IonType, Float>();
            for (IonType ionType : ionTypes) {
                rankDist.put(ionType, new Histogram());
                rankDistMaxRank.put(ionType, Float.valueOf(0.0f));
                rankDistUnexplained.put(ionType, Float.valueOf(0.0f));
            }
            rankDist.put(IonType.NOISE, new Histogram());
            float[] noiseDist = new float[maxRank + 2];
            int numMaxRankPeaks = 0;
            int totalCleavageSites = 0;
            for (IonType[] spec : this.specContainer) {
                float curParentMass;
                int numExplainedPeaks = 0;
                if (spec.getAnnotation() == null || spec.getCharge() != charge || (curParentMass = spec.getPrecursorMass()) < parentMassRange.getFirst().floatValue() || curParentMass >= parentMassRange.getSecond().floatValue()) continue;
                Peptide annotation = spec.getAnnotation();
                spec.setRanksOfPeaks();
                ++numSpec;
                numMaxRankPeaks += spec.size() - maxRank + 1;
                totalCleavageSites += annotation.size() - 1;
                int prmMassIndex = 0;
                int srmMassIndex = 0;
                HashSet<Peak> explainedPeakSet = new HashSet<Peak>();
                Hashtable<IonType, Integer> numExplainedMaxRankPeaks = new Hashtable<IonType, Integer>();
                for (IonType ion3 : ionTypes) {
                    numExplainedMaxRankPeaks.put(ion3, 0);
                }
                int numSignalBinsAtThisSegment = 0;
                for (int i = 0; i < annotation.size() - 1; ++i) {
                    float prm = NominalMass.getMassFromNominalMass(prmMassIndex += NominalMass.toNominalMass(annotation.get(i).getMass()));
                    float srm = NominalMass.getMassFromNominalMass(srmMassIndex += NominalMass.toNominalMass(annotation.get(annotation.size() - 1 - i).getMass()));
                    for (IonType ion4 : ionTypes) {
                        float theoMass = ion4 instanceof IonType.PrefixIon ? ion4.getMz(prm) : ion4.getMz(srm);
                        int segNum = super.getSegmentNum(theoMass, curParentMass);
                        if (segNum != seg) continue;
                        ++numSignalBinsAtThisSegment;
                        Peak p = spec.getPeakByMass(theoMass, this.mme);
                        if (p != null) {
                            ++numExplainedPeaks;
                            int rank = p.getRank();
                            if (rank >= maxRank) {
                                rank = maxRank;
                                numExplainedMaxRankPeaks.put(ion4, (Integer)numExplainedMaxRankPeaks.get(ion4) + 1);
                            }
                            explainedPeakSet.add(p);
                            ((Histogram)rankDist.get(ion4)).add(rank);
                            continue;
                        }
                        ((Histogram)rankDist.get(ion4)).add(maxRank + 1);
                    }
                }
                ArrayList<Peak> unexplainedPeaksAtThisSegment = new ArrayList<Peak>();
                int numPeaksAtThisSegment = 0;
                int numMaxRankPeaksAtThisSegment = 0;
                for (Peak peak : spec) {
                    if (super.getSegmentNum(peak.getMz(), curParentMass) != seg) continue;
                    ++numPeaksAtThisSegment;
                    if (peak.getRank() >= maxRank) {
                        ++numMaxRankPeaksAtThisSegment;
                    }
                    if (explainedPeakSet.contains(peak)) continue;
                    unexplainedPeaksAtThisSegment.add(peak);
                }
                float midMassThisSegment = (1.0f / (float)this.numSegments * (float)seg + 1.0f / (float)this.numSegments / 2.0f) * annotation.getParentMass();
                float f = annotation.getParentMass() / (float)this.numSegments / this.mme.getToleranceAsDa(midMassThisSegment) / 2.0f;
                for (Peak p : unexplainedPeaksAtThisSegment) {
                    int rank = p.getRank();
                    float noiseFreq = (float)((annotation.size() - 1) / this.numSegments) / f;
                    if (rank >= maxRank) {
                        int n = maxRank;
                        noiseDist[n] = noiseDist[n] + noiseFreq / (float)numMaxRankPeaksAtThisSegment;
                        continue;
                    }
                    int n = rank;
                    noiseDist[n] = noiseDist[n] + noiseFreq;
                }
                for (IonType ion5 : ionTypes) {
                    if (numMaxRankPeaksAtThisSegment <= 0) continue;
                    Float prevSumFreq = (Float)rankDistMaxRank.get(ion5);
                    float curFreq = (float)((Integer)numExplainedMaxRankPeaks.get(ion5)).intValue() / (float)numMaxRankPeaksAtThisSegment;
                    rankDistMaxRank.put(ion5, Float.valueOf(prevSumFreq.floatValue() + curFreq));
                }
                int n = maxRank + 1;
                noiseDist[n] = noiseDist[n] + (f - (float)numPeaksAtThisSegment) * (float)(annotation.size() - 1) / (float)this.numSegments / f;
            }
            Hashtable<IonType, Float[]> hashtable = new Hashtable<IonType, Float[]>();
            for (IonType ion6 : ionTypes) {
                Float[] dist = new Float[maxRank + 1];
                Histogram hist = (Histogram)rankDist.get(ion6);
                for (int i = 1; i <= maxRank - 1; ++i) {
                    Integer num = hist.get(i);
                    dist[i - 1] = Float.valueOf((float)num.intValue() / (float)numSpec);
                }
                dist[maxRank - 1] = Float.valueOf(((Float)rankDistMaxRank.get(ion6)).floatValue() / (float)numSpec);
                dist[maxRank] = Float.valueOf((float)hist.get(maxRank + 1).intValue() / (float)numSpec);
                hashtable.put(ion6, dist);
            }
            Float[] dist = new Float[maxRank + 1];
            for (int i = 1; i <= maxRank + 1; ++i) {
                dist[i - 1] = Float.valueOf(noiseDist[i] / (float)numSpec);
            }
            hashtable.put(IonType.NOISE, dist);
            this.rankDistTable.put(partition, hashtable);
        }
    }

    protected void smoothing() {
        this.smoothingRankDistTable();
    }

    protected void smoothingRankDistTable() {
        if (this.rankDistTable == null) {
            return;
        }
        assert (smoothingRanks.length == smoothingWindowSize.length);
        for (Partition partition : this.rankDistTable.keySet()) {
            Hashtable table = (Hashtable)this.rankDistTable.get(partition);
            for (IonType ion : table.keySet()) {
                int i;
                Float[] freq = (Float[])table.get(ion);
                Float[] smoothedFreq = new Float[freq.length];
                int smoothingIndex = 0;
                for (i = 0; i < freq.length - 2; ++i) {
                    if (smoothingIndex < smoothingRanks.length - 1 && i == smoothingRanks[smoothingIndex]) {
                        ++smoothingIndex;
                    }
                    int windowSize = smoothingWindowSize[smoothingIndex];
                    float sumFrequencies = 0.0f;
                    int numIndicesSummed = 0;
                    for (int d = -windowSize; d <= windowSize; ++d) {
                        int index = i + d;
                        if (index < 0 || index > freq.length - 3) continue;
                        sumFrequencies += freq[index].floatValue();
                        ++numIndicesSummed;
                    }
                    while (sumFrequencies == 0.0f && windowSize < freq.length - 4) {
                        int index;
                        if ((index = i - ++windowSize) >= 0) {
                            sumFrequencies += freq[index].floatValue();
                            ++numIndicesSummed;
                        }
                        if ((index = i + windowSize) > freq.length - 3) continue;
                        sumFrequencies += freq[index].floatValue();
                        ++numIndicesSummed;
                    }
                    if (sumFrequencies != 0.0f) {
                        smoothedFreq[i] = Float.valueOf(sumFrequencies / (float)numIndicesSummed);
                        continue;
                    }
                    assert (false);
                }
                for (i = 0; i < freq.length - 2; ++i) {
                    freq[i] = smoothedFreq[i];
                }
                if (freq[freq.length - 1].floatValue() == 0.0f) {
                    freq[freq.length - 1] = Float.valueOf(Float.MIN_VALUE);
                }
                if (freq[freq.length - 2].floatValue() != 0.0f) continue;
                freq[freq.length - 2] = freq[freq.length - 3];
            }
        }
    }
}

