/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.mstag;

import edu.ucsd.msjava.mstag.Tag;
import edu.ucsd.msjava.msutil.AminoAcid;
import edu.ucsd.msjava.msutil.Mass;
import edu.ucsd.msjava.msutil.Peak;
import edu.ucsd.msjava.msutil.Peptide;
import edu.ucsd.msjava.msutil.RankFilter;
import edu.ucsd.msjava.msutil.SpectraContainer;
import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.parser.MgfSpectrumParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.PriorityQueue;
import java.util.Stack;

public class Tagger {
    private static final AminoAcid[] stdAminoAcids = AminoAcid.getStandardAminoAcids();
    private static final float maxMass;

    private static final AminoAcid[] getAminoAcids(Float mass, float tolerance) {
        AminoAcid target = AminoAcid.getCustomAminoAcid('X', mass.floatValue());
        int index = Arrays.binarySearch(stdAminoAcids, target);
        if (index < 0) {
            index = -index - 1;
        }
        LinkedList<AminoAcid> results = new LinkedList<AminoAcid>();
        while (index < stdAminoAcids.length && stdAminoAcids[index].getMass() <= mass.floatValue() + tolerance) {
            ++index;
        }
        --index;
        while (index >= 0 && stdAminoAcids[index].getMass() >= mass.floatValue() - tolerance) {
            results.addFirst(stdAminoAcids[index]);
            --index;
        }
        return results.toArray(new AminoAcid[0]);
    }

    private Tagger() {
    }

    public static void main(String[] args) throws Exception {
        float cutOffFraction = 0.5f;
        float ppmTolerance = 10.0f;
        String spectrumFile = "/Users/jung/Research/USTags/centroidedMGF/spec1845.mgf";
        SpectraContainer sc = new SpectraContainer(spectrumFile, new MgfSpectrumParser());
        RankFilter wf = new RankFilter(380);
        Spectrum s = wf.apply((Spectrum)sc.get(0));
        System.out.println("Parent mass " + s.getPrecursorMass());
        for (Peak p : s) {
            p.setIntensity((float)Math.log(p.getIntensity()));
        }
        System.out.println("Peak count before filtering " + s.size());
        ArrayList<Tag> results = Tagger.makeTags(s, ppmTolerance, cutOffFraction);
        System.out.println(results.size());
        int rank = 1;
        for (Tag tag : results) {
            System.out.println(rank + "\t" + tag);
            if (++rank <= 10) continue;
            break;
        }
        rank = 1;
        for (Tag tag : results) {
            String seqStr = tag.getTagStr();
            if (seqStr.equals("GFTFSFPAS")) {
                System.out.println(rank + "\t" + tag);
            }
            ++rank;
        }
    }

    public static ArrayList<Tag> makeTags(Spectrum s, float ppmTolerance, float cutOffFraction) {
        LinkedList<Peak> peakBuffer = new LinkedList<Peak>();
        Cell[] table = new Cell[s.size()];
        for (int i = table.length - 1; i >= 0; --i) {
            table[i] = new Cell((Peak)s.get(i));
            table[i].setScore(((Peak)s.get(i)).getIntensity());
        }
        float maxScore = Float.NEGATIVE_INFINITY;
        int peakIndex = 0;
        for (Peak current : s) {
            while (peakBuffer.size() > 0 && ((Peak)peakBuffer.getFirst()).getMass() < current.getMass() - maxMass) {
                peakBuffer.removeFirst();
            }
            for (Peak previous : peakBuffer) {
                AminoAcid[] matches;
                float massDiff = current.getMass() - previous.getMass();
                for (AminoAcid aa : matches = Tagger.getAminoAcids(Float.valueOf(massDiff), current.toUnitTolerance(ppmTolerance))) {
                    Cell previousCell = table[previous.getIndex()];
                    float thisDelta = current.getIntensity();
                    float thisScore = previousCell.getScore() + thisDelta;
                    table[peakIndex].addLink(thisScore, previousCell, aa);
                    if (!(thisScore > maxScore)) continue;
                    maxScore = thisScore;
                }
            }
            current.setIndex(peakIndex);
            peakBuffer.addLast(current);
            ++peakIndex;
        }
        float cutOff = maxScore * cutOffFraction;
        ArrayList<Tag> results = new ArrayList<Tag>();
        for (Cell c : table) {
            if (!(c.score >= cutOff)) continue;
            Stack<Peak> peaks = new Stack<Peak>();
            peaks.push(c.peak);
            Tagger.retrieve(c, new Stack<AminoAcid>(), peaks, c.peak.getIntensity(), cutOff, s.getPrecursorMass() - c.peak.getMass(), results);
        }
        Collections.sort(results);
        return results;
    }

    private static void retrieve(Cell target, Stack<AminoAcid> sequence, Stack<Peak> peaks, float cumScore, float cutOff, float rightMass, ArrayList<Tag> results) {
        float thisScore = cumScore + target.peak.getIntensity();
        if (thisScore >= cutOff) {
            Peptide tag = new Peptide(sequence.toArray(new AminoAcid[sequence.size()]));
            Peak[] finalPeaks = peaks.toArray(new Peak[peaks.size()]);
            Mass left = new Mass(((Peak)peaks.get(0)).getMass());
            Mass right = new Mass(rightMass);
            results.add(new Tag(left, tag, right, finalPeaks, thisScore));
        }
        for (Cell.Link link : target.getLinks()) {
            Cell previous = link.previous;
            float bestScore = previous.score + cumScore;
            if (!(bestScore >= cutOff)) continue;
            float newCumScore = target.peak.getIntensity() + cumScore;
            sequence.push(link.aa);
            peaks.push(target.peak);
            Tagger.retrieve(previous, sequence, peaks, newCumScore, cutOff, rightMass, results);
            sequence.pop();
            peaks.pop();
        }
    }

    static {
        Arrays.sort(stdAminoAcids);
        maxMass = stdAminoAcids[stdAminoAcids.length - 1].getMass();
    }

    private static class Cell {
        private float score = Float.NEGATIVE_INFINITY;
        private Peak peak;
        private PriorityQueue<Link> links = new PriorityQueue();

        private Cell(Peak peak) {
            this.peak = peak;
        }

        public void setScore(float score) {
            this.score = score;
        }

        public float getScore() {
            return this.score;
        }

        public Collection<Link> getLinks() {
            return this.links;
        }

        private void addLink(float score, Cell previous, AminoAcid aa) {
            if (this.score < score) {
                this.score = score;
            }
            this.links.add(new Link(score, previous, aa));
        }

        private class Link
        implements Comparable<Link> {
            private float score;
            private Cell previous;
            private AminoAcid aa;

            private Link(float score, Cell previous, AminoAcid aa) {
                this.score = score;
                this.previous = previous;
                this.aa = aa;
            }

            @Override
            public int compareTo(Link other) {
                if (this.score > other.score) {
                    return -1;
                }
                if (other.score > this.score) {
                    return 1;
                }
                return 0;
            }
        }
    }
}

