/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msutil;

import edu.ucsd.msjava.msutil.Composition;
import edu.ucsd.msjava.msutil.Matter;
import edu.ucsd.msjava.msutil.Modification;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;

public class AminoAcid
extends Matter {
    private static final long serialVersionUID = 1L;
    private double mass;
    private int nominalMass;
    private char residue;
    private String name;
    private float probability = 0.05f;
    private Composition composition;
    private static Hashtable<Character, AminoAcid> residueMap;
    private static final AminoAcid[] standardAATable;
    private static HashMap<Integer, ArrayList<AminoAcid>> mass2aa;

    protected AminoAcid(char residue, String name, Composition composition) {
        this.mass = composition.getAccurateMass();
        this.nominalMass = composition.getNominalMass();
        this.residue = residue;
        this.name = name;
        this.composition = composition;
    }

    protected AminoAcid(char residue, String name, double mass) {
        this.mass = mass;
        this.nominalMass = Math.round(0.999497f * (float)mass);
        this.residue = residue;
        this.name = name;
    }

    public AminoAcid setProbability(float probability) {
        this.probability = probability;
        return this;
    }

    @Override
    public String toString() {
        return String.valueOf(this.residue) + ": " + String.format("%.2f", this.mass);
    }

    public boolean isModified() {
        return false;
    }

    public int getNumVariableMods() {
        return 0;
    }

    public boolean hasTerminalVariableMod() {
        return false;
    }

    public boolean hasResidueSpecificVariableMod() {
        return false;
    }

    @Override
    public float getMass() {
        return (float)this.mass;
    }

    @Override
    public double getAccurateMass() {
        return this.mass;
    }

    @Override
    public int getNominalMass() {
        return this.nominalMass;
    }

    public float getProbability() {
        return this.probability;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AminoAcid)) {
            return false;
        }
        AminoAcid aa = (AminoAcid)obj;
        return this == aa;
    }

    public String getResidueStr() {
        return String.valueOf(this.residue);
    }

    public char getResidue() {
        return this.residue;
    }

    public char getUnmodResidue() {
        return this.residue;
    }

    public String getName() {
        return this.name;
    }

    public Composition getComposition() {
        return this.composition;
    }

    public static AminoAcid getStandardAminoAcid(char residue) {
        return residueMap.get(Character.valueOf(residue));
    }

    public static AminoAcid[] getStandardAminoAcids() {
        return standardAATable;
    }

    public AminoAcid getAAWithFixedModification(Modification mod) {
        String name = mod.getName() + " " + this.getName();
        AminoAcid modAA = mod.getComposition() == null ? AminoAcid.getCustomAminoAcid(this.residue, name, this.mass + mod.getAccurateMass()) : AminoAcid.getAminoAcid(this.residue, name, this.composition.getAddition(mod.getComposition()));
        return modAA;
    }

    public static AminoAcid getCustomAminoAcid(char residue, String name, double mass) {
        AminoAcid standardAA = AminoAcid.getStandardAminoAcid(residue);
        if (standardAA != null && Math.abs(mass - (double)standardAA.getMass()) < (double)0.001f) {
            return standardAA;
        }
        return new AminoAcid(residue, name, mass);
    }

    public static AminoAcid getCustomAminoAcid(char residue, float mass) {
        return new AminoAcid(residue, "Custom amino acid", mass);
    }

    public static AminoAcid getAminoAcid(char residue, String name, Composition composition) {
        AminoAcid standardAA = AminoAcid.getStandardAminoAcid(residue);
        if (standardAA != null && composition.getAccurateMass() == standardAA.getAccurateMass()) {
            return standardAA;
        }
        return new AminoAcid(residue, name, composition);
    }

    public int hashCode() {
        return this.residue;
    }

    public static ArrayList<AminoAcid> getAminoAcids(int mass) {
        if (mass2aa.containsKey(mass)) {
            return mass2aa.get(mass);
        }
        return new ArrayList<AminoAcid>();
    }

    public static boolean isStdAminoAcid(char c) {
        return residueMap.containsKey(Character.valueOf(c));
    }

    static {
        standardAATable = new AminoAcid[]{new AminoAcid('G', "Glycine", new Composition(2, 3, 1, 1, 0)), new AminoAcid('A', "Alanine", new Composition(3, 5, 1, 1, 0)), new AminoAcid('S', "Serine", new Composition(3, 5, 1, 2, 0)), new AminoAcid('P', "Proline", new Composition(5, 7, 1, 1, 0)), new AminoAcid('V', "Valine", new Composition(5, 9, 1, 1, 0)), new AminoAcid('T', "Threonine", new Composition(4, 7, 1, 2, 0)), new AminoAcid('C', "Cystine", new Composition(3, 5, 1, 1, 1)), new AminoAcid('L', "Leucine", new Composition(6, 11, 1, 1, 0)), new AminoAcid('I', "Isoleucine", new Composition(6, 11, 1, 1, 0)), new AminoAcid('N', "Asparagine", new Composition(4, 6, 2, 2, 0)), new AminoAcid('D', "Aspartate", new Composition(4, 5, 1, 3, 0)), new AminoAcid('Q', "Glutamine", new Composition(5, 8, 2, 2, 0)), new AminoAcid('K', "Lysine", new Composition(6, 12, 2, 1, 0)), new AminoAcid('E', "Glutamate", new Composition(5, 7, 1, 3, 0)), new AminoAcid('M', "Methionine", new Composition(5, 9, 1, 1, 1)), new AminoAcid('H', "Histidine", new Composition(6, 7, 3, 1, 0)), new AminoAcid('F', "Phenylalanine", new Composition(9, 9, 1, 1, 0)), new AminoAcid('R', "Arginine", new Composition(6, 12, 4, 1, 0)), new AminoAcid('Y', "Tyrosine", new Composition(9, 9, 1, 2, 0)), new AminoAcid('W', "Tryptophan", new Composition(11, 10, 2, 1, 0))};
        residueMap = new Hashtable();
        for (AminoAcid aa : standardAATable) {
            residueMap.put(Character.valueOf(aa.getResidue()), aa);
        }
        mass2aa = new HashMap();
        for (AminoAcid aa : AminoAcid.getStandardAminoAcids()) {
            if (!mass2aa.containsKey(aa.getNominalMass())) {
                mass2aa.put(aa.getNominalMass(), new ArrayList());
            }
            mass2aa.get(aa.getNominalMass()).add(aa);
        }
    }
}

