/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msutil;

import edu.ucsd.msjava.msgf.IntMassFactory;
import edu.ucsd.msjava.msutil.AminoAcid;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class IntMassAASet {
    private Integer[] intMassArr;
    private HashMap<Integer, Integer> intMassNumTable = new HashMap();
    private HashMap<Integer, Float> intMassProbTable = new HashMap();
    private HashMap<Integer, ArrayList<AminoAcid>> intMassAATable = new HashMap();

    public IntMassAASet(IntMassFactory factory, ArrayList<AminoAcid> aaList) {
        for (AminoAcid aa : aaList) {
            float aaProb = aa.getProbability();
            int intMass = factory.getMassIndex(aa.getMass());
            Integer nNum = this.intMassNumTable.get(intMass);
            if (nNum == null) {
                this.intMassNumTable.put(intMass, 1);
                this.intMassProbTable.put(intMass, Float.valueOf(aaProb));
                ArrayList<AminoAcid> newAAList = new ArrayList<AminoAcid>();
                newAAList.add(aa);
                this.intMassAATable.put(intMass, newAAList);
                continue;
            }
            this.intMassNumTable.put(intMass, nNum + 1);
            this.intMassProbTable.put(intMass, Float.valueOf(this.intMassProbTable.get(intMass).floatValue() + aaProb));
            ArrayList<AminoAcid> existingAAList = this.intMassAATable.get(intMass);
            existingAAList.add(aa);
        }
        this.intMassArr = this.intMassNumTable.keySet().toArray(new Integer[0]);
        Arrays.sort((Object[])this.intMassArr);
    }

    public Integer[] getDistinctIntMasses() {
        return this.intMassArr;
    }

    public int getNumAAWithIntMass(int intMass) {
        Integer num = this.intMassNumTable.get(intMass);
        if (num == null) {
            return 0;
        }
        return num;
    }

    public float getSumProbWithIntMass(int intMass) {
        Float prob = this.intMassProbTable.get(intMass);
        if (prob == null) {
            return 0.0f;
        }
        return prob.floatValue();
    }

    public ArrayList<AminoAcid> getAAListWithIntMass(int intMass) {
        return this.intMassAATable.get(intMass);
    }
}

