/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.msutil;

import edu.ucsd.msjava.msutil.Composition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.StringTokenizer;

public abstract class IonType {
    private String name;
    private int charge;
    private float offset;
    protected static Hashtable<String, IonType> ionTable;
    protected static Hashtable<String, Float> compositionOffsetTable;
    protected static Hashtable<String, IonType> offsetToIonTable;
    public static final IonType Y;
    public static final IonType Z;
    public static final IonType X;
    public static final IonType Xr;
    public static final IonType B;
    public static final IonType A;
    public static final IonType Ar;
    public static final IonType C;
    public static final IonType NOISE;

    public String toString() {
        return this.name + "(" + this.charge + "," + this.offset + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IonType)) {
            return false;
        }
        IonType io = (IonType)o;
        return io.name.equals(this.name) && io.charge == this.charge && io.offset == this.offset;
    }

    public int hashCode() {
        return this.name.hashCode() * this.charge * new Float(this.offset).hashCode();
    }

    protected IonType(String name, int charge, float offset) {
        this.name = name;
        this.charge = charge;
        this.offset = offset;
    }

    public int getCharge() {
        return this.charge;
    }

    public String getName() {
        return this.name;
    }

    public float getOffset() {
        return this.offset;
    }

    public boolean isPrefixIon() {
        return this instanceof PrefixIon;
    }

    public boolean isSuffixIon() {
        return this instanceof SuffixIon;
    }

    public float getMz(float mass) {
        return mass / (float)this.charge + this.offset;
    }

    public float getMass(float mz) {
        return (mz - this.offset) * (float)this.charge;
    }

    public static IonType getIonType(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        if (name.startsWith("s/") || name.startsWith("p/") || name.startsWith("i/") || name.startsWith("r/")) {
            StringTokenizer s = new StringTokenizer(name, "/", false);
            s.nextToken();
            if (!s.hasMoreTokens()) {
                return null;
            }
            String t = s.nextToken();
            try {
                int charge = Integer.parseInt(t.replace("+", ""));
                if (!s.hasMoreTokens()) {
                    return null;
                }
                t = s.nextToken();
                float offset = Float.parseFloat(t);
                IonType it = name.startsWith("s") ? new SuffixIon(name, charge, offset) : (name.startsWith("p") ? new PrefixIon(name, charge, offset) : (name.startsWith("i") ? new InternalIon(name, charge, offset) : new PrecursorIon(name, charge, offset)));
                return it;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        StringTokenizer s = new StringTokenizer(name, "+-", true);
        String token = s.nextToken();
        IonType base = ionTable.get(token);
        if (base == null) {
            return null;
        }
        float offset = 0.0f;
        while (s.hasMoreTokens()) {
            token = s.nextToken();
            int sign = token.equals("+") ? 1 : -1;
            if (!s.hasMoreTokens()) {
                throw new Error();
            }
            token = s.nextToken();
            Float offs = compositionOffsetTable.get(token);
            if (offs == null) {
                try {
                    offs = Float.valueOf(Float.parseFloat(token));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            offset += (float)sign * offs.floatValue();
        }
        IonType it = base instanceof PrefixIon ? new PrefixIon(name, base.charge, base.offset + offset / (float)base.charge) : (base instanceof SuffixIon ? new SuffixIon(name, base.charge, base.offset + offset / (float)base.charge) : (base instanceof InternalIon ? new InternalIon(name, base.charge, base.offset + offset / (float)base.charge) : null));
        return it;
    }

    public static ArrayList<IonType> getAllKnownIonTypes(int maxCharge, boolean removeRedundancy) {
        return IonType.getAllKnownIonTypes(maxCharge, removeRedundancy, false, false, false);
    }

    public static ArrayList<IonType> getAllKnownIonTypes(int maxCharge, boolean removeRedundancy, boolean addPhosphoNL, boolean addiTRAQNL, boolean addTMTNL) {
        String nlString;
        String phospho = "H3PO4";
        String iTRAQ = "iTRAQ";
        String tmt = "TMT";
        if (addPhosphoNL) {
            nlString = phospho;
            if (addiTRAQNL) {
                nlString = nlString + "," + iTRAQ;
            } else if (addTMTNL) {
                nlString = nlString + "," + tmt;
            }
        } else {
            nlString = addiTRAQNL ? iTRAQ : (addTMTNL ? tmt : "");
        }
        return IonType.getAllKnownIonTypes(maxCharge, removeRedundancy, nlString);
    }

    public static ArrayList<IonType> getAllKnownIonTypes(int maxCharge, boolean removeRedundancy, String nlString) {
        int i;
        String[] nlExt;
        String[] base = new String[]{"x", "x.", "y", "z", "a", "a.", "b", "c"};
        String[] extension = new String[]{"", "-H2O", "-H2O-H2O", "-NH3", "-NH3-NH3", "-NH3-H2O", "+n", "+n2", "-H"};
        if (nlString != null && nlString.length() > 0) {
            String[] token = nlString.split(",");
            nlExt = new String[token.length + 1];
            nlExt[0] = "";
            for (int i2 = 0; i2 < token.length; ++i2) {
                nlExt[i2 + 1] = "-" + token[i2].trim();
            }
        } else {
            nlExt = new String[]{""};
        }
        ArrayList<IonType> ionList = new ArrayList<IonType>();
        for (int charge = 1; charge <= maxCharge; ++charge) {
            for (i = 0; i < base.length; ++i) {
                for (int j = 0; j < extension.length; ++j) {
                    if (i == 7 && j == 3) continue;
                    for (int k = 0; k < nlExt.length; ++k) {
                        IonType ion = IonType.getIonType(base[i] + (charge > 1 ? Integer.valueOf(charge) : "") + extension[j] + nlExt[k]);
                        assert (ion != null) : base[i] + extension[j] + nlExt[k];
                        ionList.add(ion);
                    }
                }
            }
        }
        Collections.sort(ionList, new IonTypeComparator());
        if (!removeRedundancy) {
            return ionList;
        }
        LinkedList<IonType> newIonList = new LinkedList<IonType>();
        for (i = 1; i < ionList.size(); ++i) {
            IonType prevIon = ionList.get(i - 1);
            IonType curIon = ionList.get(i);
            if (curIon.getOffset() - prevIon.getOffset() < 0.1f && curIon.getCharge() == prevIon.getCharge() && curIon.isPrefixIon() == prevIon.isPrefixIon()) {
                if (curIon.getName().length() >= prevIon.getName().length()) continue;
                newIonList.removeLast();
                newIonList.add(curIon);
                continue;
            }
            newIonList.add(curIon);
        }
        return new ArrayList<IonType>(newIonList);
    }

    public static void main(String[] args) {
        ArrayList<IonType> allIons = IonType.getAllKnownIonTypes(3, true, true, false, true);
        for (IonType ion : allIons) {
            System.out.println(ion.getName() + "\t" + ion.getOffset());
        }
    }

    static {
        Y = new SuffixIon("y", 1, (float)Composition.OffsetY());
        Z = new SuffixIon("z", 1, (float)((double)IonType.Y.offset - 16.01872407));
        X = new SuffixIon("x", 1, (float)((double)IonType.Y.offset + 27.99491463));
        Xr = new SuffixIon("x.", 1, (float)((double)IonType.X.offset + 1.007825035));
        B = new PrefixIon("b", 1, (float)Composition.OffsetB());
        A = new PrefixIon("a", 1, (float)((double)IonType.B.offset - 27.99491463));
        Ar = new PrefixIon("a.", 1, (float)((double)IonType.A.offset + 1.007825035));
        C = new PrefixIon("c", 1, (float)((double)IonType.B.offset + 17.026549105));
        NOISE = new PrefixIon("noise", 0, 0.0f);
        ionTable = new Hashtable();
        ionTable.put("x", X);
        ionTable.put("x.", Xr);
        ionTable.put("y", Y);
        ionTable.put("z", Z);
        ionTable.put("a", A);
        ionTable.put("a.", Ar);
        ionTable.put("b", B);
        ionTable.put("c", C);
        for (int charge = 2; charge <= 4; ++charge) {
            ionTable.put("x" + charge, new SuffixIon("x" + charge, charge, (float)(((double)IonType.X.offset + Composition.ChargeCarrierMass() * (double)(charge - 1)) / (double)charge)));
            ionTable.put("x." + charge, new SuffixIon("x." + charge, charge, (float)(((double)IonType.Xr.offset + Composition.ChargeCarrierMass() * (double)(charge - 1)) / (double)charge)));
            ionTable.put("y" + charge, new SuffixIon("y" + charge, charge, (float)(((double)IonType.Y.offset + Composition.ChargeCarrierMass() * (double)(charge - 1)) / (double)charge)));
            ionTable.put("z" + charge, new SuffixIon("z" + charge, charge, (float)(((double)IonType.Z.offset + Composition.ChargeCarrierMass() * (double)(charge - 1)) / (double)charge)));
            ionTable.put("a" + charge, new PrefixIon("a" + charge, charge, (float)(((double)IonType.A.offset + Composition.ChargeCarrierMass() * (double)(charge - 1)) / (double)charge)));
            ionTable.put("a." + charge, new PrefixIon("a." + charge, charge, (float)(((double)IonType.Ar.offset + Composition.ChargeCarrierMass() * (double)(charge - 1)) / (double)charge)));
            ionTable.put("b" + charge, new PrefixIon("b" + charge, charge, (float)(((double)IonType.B.offset + Composition.ChargeCarrierMass() * (double)(charge - 1)) / (double)charge)));
            ionTable.put("c" + charge, new PrefixIon("c" + charge, charge, (float)(((double)IonType.C.offset + Composition.ChargeCarrierMass() * (double)(charge - 1)) / (double)charge)));
        }
        compositionOffsetTable = new Hashtable();
        compositionOffsetTable.put("H2O", Float.valueOf(18.010565f));
        compositionOffsetTable.put("NH3", Float.valueOf(17.026548f));
        compositionOffsetTable.put("NH", Float.valueOf(15.010899f));
        compositionOffsetTable.put("n", Float.valueOf(1.0033548f));
        compositionOffsetTable.put("n2", Float.valueOf(2.003241f));
        compositionOffsetTable.put("H", Float.valueOf(1.007825f));
        compositionOffsetTable.put("H3PO4", Float.valueOf(97.9769f));
        compositionOffsetTable.put("iTRAQ", Float.valueOf(144.10207f));
        compositionOffsetTable.put("TMT", Float.valueOf(229.16293f));
    }

    private static class IonTypeComparator
    implements Comparator<IonType> {
        private IonTypeComparator() {
        }

        @Override
        public int compare(IonType i1, IonType i2) {
            if (i1.getCharge() < i2.getCharge()) {
                return -1;
            }
            if (i1.getCharge() > i2.getCharge()) {
                return 1;
            }
            if (i1.getOffset() < i2.getOffset()) {
                return -1;
            }
            if (i1.getOffset() > i2.getOffset()) {
                return 1;
            }
            return 0;
        }
    }

    public static class SuffixIon
    extends IonType {
        public SuffixIon(String name, int charge, float offset) {
            super(name, charge, offset);
        }

        public SuffixIon(int charge, float offset) {
            super("S_" + charge + "_" + Math.round(offset), charge, offset);
        }
    }

    public static class PrefixIon
    extends IonType {
        public PrefixIon(String name, int charge, float offset) {
            super(name, charge, offset);
        }

        public PrefixIon(int charge, float offset) {
            super("P_" + charge + "_" + Math.round(offset), charge, offset);
        }
    }

    public static class PrecursorIon
    extends IonType {
        public PrecursorIon(String name, int charge, float offset) {
            super(name, charge, offset);
        }

        public PrecursorIon(int charge, float offset) {
            super("R_" + charge + "_" + Math.round(offset), charge, offset);
        }
    }

    public static class CyclicIon
    extends IonType {
        public CyclicIon(String name, int charge, float offset) {
            super(name, charge, offset);
        }

        public CyclicIon(int charge, float offset) {
            super("C_" + charge + "_" + Math.round(offset), charge, offset);
        }
    }

    public static class InternalIon
    extends IonType {
        public InternalIon(String name, int charge, float offset) {
            super(name, charge, offset);
        }

        public InternalIon(int charge, float offset) {
            super("I_" + charge + "_" + Math.round(offset), charge, offset);
        }
    }
}

